/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import org.beigesoft.doc.service.ToHexCoder;
import org.beigesoft.pdf.model.PdfToUnicode;
import org.beigesoft.pdf.service.AWriterPdfStream;

public class WriterPdfToUnicode
extends AWriterPdfStream<PdfToUnicode, PdfToUnicode> {
    private ToHexCoder toHexCoder;

    @Override
    public final void writeToBuffer(PdfToUnicode pPdfObj, OutputStream pOut) throws Exception {
        this.makeBfranges(pPdfObj);
        pPdfObj.getBuffer().write("/CIDInit /ProcSet findresource begin\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("12 dict begin\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("begincmap\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("/CIDSystemInfo\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("<< /Registry (Adobe)\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("/Ordering (UCS)\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("/Supplement 0\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write(">> def\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("/CMapName /Adobe-Identity-UCS def\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("/CMapType 2 def\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("1 begincodespacerange\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("<0000> <FFFF>\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("endcodespacerange\n".getBytes(this.getWriteHelper().getAscii()));
        String stFr = String.valueOf(pPdfObj.getBfranges().size()) + " beginbfrange\n";
        pPdfObj.getBuffer().write(stFr.getBytes(this.getWriteHelper().getAscii()));
        for (String bfr : pPdfObj.getBfranges()) {
            pPdfObj.getBuffer().write((bfr + "\n").getBytes(this.getWriteHelper().getAscii()));
        }
        pPdfObj.getBuffer().write("endbfrange\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("endcmap\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("CMapName currentdict /CMap defineresource pop\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("end\n".getBytes(this.getWriteHelper().getAscii()));
        pPdfObj.getBuffer().write("end\n".getBytes(this.getWriteHelper().getAscii()));
    }

    public final void makeBfranges(PdfToUnicode pPdfObj) {
        pPdfObj.getBfranges().clear();
        Character cidStart = null;
        Character cidEnd = null;
        Character uniStart = null;
        for (Character cid : pPdfObj.getUsedCids()) {
            if (pPdfObj.getUsedCidToUni().get(cid) == null) continue;
            if (cidStart == null) {
                cidStart = cid;
                uniStart = pPdfObj.getUsedCidToUni().get(cid);
                cidEnd = cid;
                continue;
            }
            if (cid.charValue() - cidEnd.charValue() == 1 && pPdfObj.getUsedCidToUni().get(cid).charValue() - pPdfObj.getUsedCidToUni().get(cidEnd).charValue() == 1) {
                cidEnd = cid;
                continue;
            }
            pPdfObj.getBfranges().add("<" + this.toHexCoder.encodeCodePoint(cidStart.charValue()) + "> <" + this.toHexCoder.encodeCodePoint(cidEnd.charValue()) + "> <" + this.toHexCoder.encodeCodePoint(uniStart.charValue()) + ">");
            cidStart = cid;
            uniStart = pPdfObj.getUsedCidToUni().get(cid);
            cidEnd = cid;
        }
        pPdfObj.getBfranges().add("<" + this.toHexCoder.encodeCodePoint(cidStart.charValue()) + "> <" + this.toHexCoder.encodeCodePoint(cidEnd.charValue()) + "> <" + this.toHexCoder.encodeCodePoint(uniStart.charValue()) + ">");
    }

    public final ToHexCoder getToHexCoder() {
        return this.toHexCoder;
    }

    public final void setToHexCoder(ToHexCoder pToHexCoder) {
        this.toHexCoder = pToHexCoder;
    }
}

