/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.beigesoft.delegate.IDelegator;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.replicator.filter.IFilterEntities;
import org.beigesoft.replicator.service.IDatabaseReader;
import org.beigesoft.replicator.service.IReplicator;
import org.beigesoft.replicator.service.ISrvEntityReader;
import org.beigesoft.replicator.service.ReplicatorXmlHttp;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.IUtilXml;
import org.beigesoft.settings.IMngSettings;

public class ReplicatorXmlHttps<RS>
implements IReplicator {
    private IMngSettings mngSettings;
    private ISrvEntityReader srvEntityReaderXml;
    private IDatabaseReader databaseReader;
    private ISrvDatabase<RS> srvDatabase;
    private ILogger logger;
    private String cookies;
    private IDelegator databasePrepearerBefore;
    private IDelegator databasePrepearerAfter;
    private IUtilXml utilXml;
    private Map<String, IFilterEntities> filtersEntities;

    @Override
    public final void replicate(Map<String, Object> pAddParams) throws Exception {
        Writer htmlWriter = (Writer)pAddParams.get("htmlWriter");
        try {
            String urlSourceStr = "https://" + (String)pAddParams.get("urlSource");
            if (urlSourceStr == null || urlSourceStr.length() < 10) {
                throw new ExceptionWithCode(1003, "Where is no urlSource!!!");
            }
            URL url = new URL(urlSourceStr);
            String authMethod = (String)pAddParams.get("authMethod");
            if ("base".equals(authMethod)) {
                final String userName = (String)pAddParams.get("userName");
                final String userPass = (String)pAddParams.get("userPass");
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(userName, userPass.toCharArray());
                    }
                });
            } else if ("form".equals(authMethod)) {
                CookieManager cookieManager = new CookieManager();
                CookieHandler.setDefault(cookieManager);
                cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                this.requestCookiesGet(pAddParams);
                this.authForm(pAddParams, cookieManager);
            }
            Map<String, Integer> classesCounts = this.makeJob(url, pAddParams);
            if (htmlWriter != null) {
                String statusString = ", replication has been done.";
                htmlWriter.write("<h4>" + new Date().toString() + statusString + "</h4>");
                pAddParams.put("statusString", new Date().toString() + ", " + ReplicatorXmlHttp.class.getSimpleName() + statusString);
                this.logger.info(null, ReplicatorXmlHttp.class, statusString);
                htmlWriter.write("<table>");
                htmlWriter.write("<tr><th style=\"padding: 5px;\">Class</th><th style=\"padding: 5px;\">Total records</th></tr>");
                for (Map.Entry<String, Integer> entry : classesCounts.entrySet()) {
                    htmlWriter.write("<tr>");
                    htmlWriter.write("<td>" + entry.getKey() + "</td>");
                    htmlWriter.write("<td>" + entry.getValue() + "</td>");
                    htmlWriter.write("</tr>");
                }
                htmlWriter.write("</table>");
            }
        }
        catch (ExceptionWithCode ex) {
            if (htmlWriter != null) {
                htmlWriter.write(new Date().toString() + ", " + ReplicatorXmlHttp.class.getSimpleName() + ", " + ex.getShortMessage());
            }
            this.logger.error(null, ReplicatorXmlHttp.class, ex.getShortMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Integer> makeJob(URL pUrl, Map<String, Object> pAddParams) throws Exception {
        String requestedDatabaseId = (String)pAddParams.get("requestedDatabaseId");
        String maxRecordsStr = (String)pAddParams.get("maxRecords");
        if (maxRecordsStr == null || maxRecordsStr.length() == 0) {
            throw new ExceptionWithCode(1003, "Where is no maxRecords!!!");
        }
        int maxRecords = Integer.parseInt(maxRecordsStr);
        LinkedHashMap<String, Integer> classesCounts = new LinkedHashMap<String, Integer>();
        Integer classCount = 0;
        boolean isDbPreparedBefore = false;
        int databaseVersion = this.srvDatabase.getVersionDatabase();
        for (Class clazz : this.mngSettings.getClasses()) {
            int entitiesReceived = 0;
            int firstRecord = 0;
            do {
                HttpsURLConnection urlConnection = (HttpsURLConnection)pUrl.openConnection();
                if (!pUrl.getHost().equals(urlConnection.getURL().getHost())) {
                    throw new ExceptionWithCode(1001, "You should sign-in in browser first!");
                }
                OutputStreamWriter writer = null;
                BufferedReader reader = null;
                try {
                    String cond;
                    IFilterEntities filterEntities;
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestMethod("POST");
                    if (this.getCookies() != null) {
                        urlConnection.addRequestProperty("Cookie", this.getCookies());
                    }
                    writer = new OutputStreamWriter(urlConnection.getOutputStream(), Charset.forName("UTF-8").newEncoder());
                    String nameFilterEntities = this.mngSettings.getClassesSettings().get(clazz).get("filter");
                    String conditions = "";
                    if (nameFilterEntities != null && (filterEntities = this.filtersEntities.get(nameFilterEntities)) != null && (cond = filterEntities.makeFilter(clazz, pAddParams)) != null) {
                        conditions = " where " + cond;
                    }
                    conditions = conditions + " limit " + maxRecords + " offset " + firstRecord;
                    String requestedDatabaseIdStr = "";
                    if (requestedDatabaseId != null) {
                        if (Integer.parseInt(requestedDatabaseId) == this.getSrvDatabase().getIdDatabase()) {
                            throw new ExceptionWithCode(1003, "requested_database_must_be_different");
                        }
                        requestedDatabaseIdStr = "&requestedDatabaseId=" + requestedDatabaseId;
                    }
                    writer.write("entityName=" + clazz.getCanonicalName() + "&conditions=" + conditions + "&requestingDatabaseVersion=" + databaseVersion + requestedDatabaseIdStr);
                    writer.write("&writerName=" + pAddParams.get("writerName"));
                    writer.flush();
                    if (200 == urlConnection.getResponseCode()) {
                        reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.forName("UTF-8").newDecoder()));
                        if (!this.utilXml.readUntilStart(reader, "message")) {
                            throw new ExceptionWithCode(1001, "Wrong XML response without message tag!!!");
                        }
                        Map<String, String> msgAttrsMap = this.srvEntityReaderXml.readAttributes(pAddParams, reader);
                        String error = msgAttrsMap.get("error");
                        if (error != null) {
                            throw new ExceptionWithCode(1001, error);
                        }
                        String entitiesCountStr = msgAttrsMap.get("entitiesCount");
                        if (entitiesCountStr == null) {
                            throw new ExceptionWithCode(1001, "Wrong XML response without entitiesCount in message!!!");
                        }
                        entitiesReceived = Integer.parseInt(entitiesCountStr);
                        if (entitiesReceived > 0) {
                            classCount = classCount + entitiesReceived;
                            this.logger.info(null, ReplicatorXmlHttp.class, "Try to parse entities total: " + entitiesReceived + " of " + clazz.getCanonicalName());
                            if (!isDbPreparedBefore) {
                                if (this.databasePrepearerBefore != null) {
                                    this.databasePrepearerBefore.make(pAddParams);
                                }
                                isDbPreparedBefore = true;
                            }
                            this.databaseReader.readAndStoreEntities(pAddParams, reader);
                            if (entitiesReceived == maxRecords) {
                                firstRecord += maxRecords;
                            } else {
                                firstRecord = 0;
                                entitiesReceived = 0;
                            }
                        } else {
                            firstRecord = 0;
                        }
                        continue;
                    }
                    throw new ExceptionWithCode(1001, "Can't receive data!!! Response code=" + urlConnection.getResponseCode());
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    urlConnection.disconnect();
                }
            } while (entitiesReceived > 0);
            classesCounts.put(clazz.getCanonicalName(), classCount);
            classCount = 0;
        }
        if (this.databasePrepearerAfter != null) {
            this.databasePrepearerAfter.make(pAddParams);
        }
        return classesCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestCookiesGet(Map<String, Object> pAddParams) throws Exception {
        block11: {
            String urlGetAuthCookStr = (String)pAddParams.get("urlGetAuthCookies");
            URL urlGetAuthCookies = new URL(urlGetAuthCookStr);
            HttpsURLConnection urlConnection = null;
            BufferedReader reader = null;
            try {
                urlConnection = (HttpsURLConnection)urlGetAuthCookies.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.addRequestProperty("Connection", "keep-alive");
                if (200 == urlConnection.getResponseCode()) {
                    reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.forName("UTF-8").newDecoder()));
                    while (reader.read() != -1) {
                    }
                    break block11;
                }
                throw new ExceptionWithCode(1001, "requestCookiesGet Can't receive data!!! Response code=" + urlConnection.getResponseCode());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void authForm(Map<String, Object> pAddParams, CookieManager pCookieManager) throws Exception {
        String authUrl = (String)pAddParams.get("authUrl");
        String authUserName = (String)pAddParams.get("authUserName");
        String authUserPass = (String)pAddParams.get("authUserPass");
        String userName = (String)pAddParams.get("userName");
        String userPass = (String)pAddParams.get("userPass");
        URL url = new URL(authUrl);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        if (!url.getHost().equals(urlConnection.getURL().getHost())) {
            throw new ExceptionWithCode(1001, "You should sign-in in browser first!");
        }
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        try {
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");
            String paramStr = authUserName + "=" + userName + "&" + authUserPass + "=" + userPass;
            StringBuffer cookiesSb = new StringBuffer();
            for (HttpCookie cookie : pCookieManager.getCookieStore().getCookies()) {
                cookiesSb.append(cookie.getName() + "=" + cookie.getValue() + ";");
            }
            this.setCookies(cookiesSb.toString());
            urlConnection.addRequestProperty("Cookie", this.getCookies());
            urlConnection.addRequestProperty("Connection", "keep-alive");
            urlConnection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.addRequestProperty("Content-Length", String.valueOf(paramStr.length()));
            boolean isDbg = this.getLogger().getIsShowDebugMessagesFor(this.getClass());
            int dbgDetLev = this.logger.getDetailLevel();
            if (isDbg && dbgDetLev > 30000) {
                this.getLogger().debug(null, ReplicatorXmlHttp.class, "Request before flush auth:");
                for (Map.Entry<String, List<String>> entry : urlConnection.getRequestProperties().entrySet()) {
                    this.logger.debug(null, ReplicatorXmlHttp.class, "  Request entry key: " + entry.getKey());
                    for (String val : entry.getValue()) {
                        this.logger.debug(null, ReplicatorXmlHttp.class, "   Request entry value: " + val);
                    }
                }
            }
            writer = new OutputStreamWriter(urlConnection.getOutputStream(), Charset.forName("UTF-8").newEncoder());
            writer.write(paramStr);
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.forName("UTF-8").newDecoder()));
            while (reader.read() != -1) {
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            urlConnection.disconnect();
        }
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final ISrvEntityReader getSrvEntityReaderXml() {
        return this.srvEntityReaderXml;
    }

    public final void setSrvEntityReaderXml(ISrvEntityReader pSrvEntityReaderXml) {
        this.srvEntityReaderXml = pSrvEntityReaderXml;
    }

    public final IDatabaseReader getDatabaseReader() {
        return this.databaseReader;
    }

    public final void setDatabaseReader(IDatabaseReader pDatabaseReader) {
        this.databaseReader = pDatabaseReader;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final String getCookies() {
        return this.cookies;
    }

    public final void setCookies(String pCookies) {
        this.cookies = pCookies;
    }

    public final IDelegator getDatabasePrepearerBefore() {
        return this.databasePrepearerBefore;
    }

    public final void setDatabasePrepearerBefore(IDelegator pDatabasePrepearerBefore) {
        this.databasePrepearerBefore = pDatabasePrepearerBefore;
    }

    public final IDelegator getDatabasePrepearerAfter() {
        return this.databasePrepearerAfter;
    }

    public final void setDatabasePrepearerAfter(IDelegator pDatabasePrepearerAfter) {
        this.databasePrepearerAfter = pDatabasePrepearerAfter;
    }

    public final IUtilXml getUtilXml() {
        return this.utilXml;
    }

    public final void setUtilXml(IUtilXml pUtilXml) {
        this.utilXml = pUtilXml;
    }

    public final Map<String, IFilterEntities> getFiltersEntities() {
        return this.filtersEntities;
    }

    public final void setFiltersEntities(Map<String, IFilterEntities> pFiltersEntities) {
        this.filtersEntities = pFiltersEntities;
    }
}

