/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.replicator.service.ISrvEntityFieldFiller;
import org.beigesoft.service.IUtilXml;
import org.beigesoft.service.UtlReflection;

public class SrvEntityFieldFillerStd
implements ISrvEntityFieldFiller {
    private UtlReflection utlReflection;
    private IUtilXml utilXml;

    @Override
    public final void fill(Map<String, Object> pAddParam, Object pEntity, String pFieldName, String pFieldStrValue) throws Exception {
        Field rField = this.getUtlReflection().retrieveField(pEntity.getClass(), pFieldName);
        rField.setAccessible(true);
        if ("NULL".equals(pFieldStrValue)) {
            rField.set(pEntity, null);
            return;
        }
        boolean isFilled = true;
        try {
            if (rField.getType() == Double.class) {
                rField.set(pEntity, Double.valueOf(pFieldStrValue));
            } else if (rField.getType() == Float.class) {
                rField.set(pEntity, Float.valueOf(pFieldStrValue));
            } else if (rField.getType() == BigDecimal.class) {
                rField.set(pEntity, new BigDecimal(pFieldStrValue));
            } else if (rField.getType() == Date.class) {
                rField.set(pEntity, new Date(Long.parseLong(pFieldStrValue)));
            } else if (Enum.class.isAssignableFrom(rField.getType())) {
                Integer intVal = Integer.valueOf(pFieldStrValue);
                Enum val = null;
                if (intVal != null) {
                    val = (Enum)rField.getType().getEnumConstants()[intVal];
                }
                rField.set(pEntity, val);
            } else if (rField.getType() == Boolean.class) {
                rField.set(pEntity, Boolean.valueOf(pFieldStrValue));
            } else if (Integer.class == rField.getType()) {
                rField.set(pEntity, Integer.valueOf(pFieldStrValue));
            } else if (Long.class == rField.getType()) {
                rField.set(pEntity, Long.valueOf(pFieldStrValue));
            } else if (String.class == rField.getType()) {
                String unescaped = this.utilXml.unescapeXml(pFieldStrValue);
                rField.set(pEntity, unescaped);
            } else {
                isFilled = false;
            }
        }
        catch (Exception ex) {
            throw new ExceptionWithCode(1003, "Can not fill field: " + pEntity + "/" + pFieldName + "/" + pFieldStrValue + ", " + ex.getMessage(), ex);
        }
        if (!isFilled) {
            throw new ExceptionWithCode(1002, "There is no rule to fill field: " + pEntity + "/" + pFieldName + "/" + pFieldStrValue);
        }
    }

    public final UtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(UtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }

    public final IUtilXml getUtilXml() {
        return this.utilXml;
    }

    public final void setUtilXml(IUtilXml pUtilXml) {
        this.utilXml = pUtilXml;
    }
}

