/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.persistable.AHasIdString;
import org.beigesoft.replicator.service.ISrvEntityFieldFiller;
import org.beigesoft.service.UtlReflection;

public class SrvEntityFieldHasIdStringRepl
implements ISrvEntityFieldFiller {
    private UtlReflection utlReflection;

    @Override
    public final void fill(Map<String, Object> pAddParam, Object pEntity, String pFieldName, String pFieldStrValue) throws Exception {
        Field rField = this.getUtlReflection().retrieveField(pEntity.getClass(), pFieldName);
        rField.setAccessible(true);
        if (!AHasIdString.class.isAssignableFrom(rField.getType())) {
            throw new ExceptionWithCode(1002, "It's wrong service to fill that field: " + pEntity + "/" + pFieldName + "/" + pFieldStrValue);
        }
        if ("NULL".equals(pFieldStrValue)) {
            rField.set(pEntity, null);
            return;
        }
        try {
            Constructor<?> constructor = rField.getType().getDeclaredConstructor(new Class[0]);
            Object ownedEntity = constructor.newInstance(new Object[0]);
            ((AHasIdString)ownedEntity).setItsId(pFieldStrValue);
            rField.set(pEntity, ownedEntity);
        }
        catch (Exception ex) {
            throw new ExceptionWithCode(1003, "Can not fill field: " + pEntity + "/" + pFieldName + "/" + pFieldStrValue + ", " + ex.getMessage(), ex);
        }
    }

    public final UtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(UtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }
}

