/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.replicator.service.ISrvEntityFieldFiller;
import org.beigesoft.replicator.service.ISrvEntityReader;
import org.beigesoft.service.IUtilXml;
import org.beigesoft.settings.IMngSettings;

public class SrvEntityReaderXml
implements ISrvEntityReader {
    private IMngSettings mngSettings;
    private Map<String, ISrvEntityFieldFiller> fieldsFillersMap;
    private IUtilXml utilXml;

    @Override
    public final Object read(Map<String, Object> pAddParam, Reader pReader) throws Exception {
        Map<String, String> attributesMap = this.readAttributes(pAddParam, pReader);
        if (attributesMap.get("class") == null) {
            throw new ExceptionWithCode(1002, "There is no class attribute for entity!");
        }
        Class<?> entityClass = Class.forName(attributesMap.get("class"));
        Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
        Object entity = constructor.newInstance(new Object[0]);
        Map<String, Map<String, String>> fieldsSettingsMap = this.getMngSettings().getFieldsSettings().get(entityClass);
        for (Map.Entry<String, Map<String, String>> entry : fieldsSettingsMap.entrySet()) {
            if (!"true".equals(entry.getValue().get("isEnabled")) || attributesMap.get(entry.getKey()) == null) continue;
            ISrvEntityFieldFiller srvEntityFieldFiller = this.getFieldsFillersMap().get(entry.getValue().get("ISrvEntityFieldFiller"));
            if (srvEntityFieldFiller == null) {
                throw new ExceptionWithCode(1002, "There is no ISrvEntityFieldFiller " + entry.getValue().get("ISrvEntityFieldFiller") + " for " + entityClass + " / " + entry.getKey());
            }
            srvEntityFieldFiller.fill(pAddParam, entity, entry.getKey(), attributesMap.get(entry.getKey()));
        }
        return entity;
    }

    @Override
    public final Map<String, String> readAttributes(Map<String, Object> pAddParam, Reader pReader) throws Exception {
        return this.utilXml.readAttributes(pReader, pAddParam);
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final Map<String, ISrvEntityFieldFiller> getFieldsFillersMap() {
        return this.fieldsFillersMap;
    }

    public final void setFieldsFillersMap(Map<String, ISrvEntityFieldFiller> pFieldsFillersMap) {
        this.fieldsFillersMap = pFieldsFillersMap;
    }

    public final IUtilXml getUtilXml() {
        return this.utilXml;
    }

    public final void setUtilXml(IUtilXml pUtilXml) {
        this.utilXml = pUtilXml;
    }
}

