/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.util.Map;
import org.beigesoft.accounting.persistable.AccountingEntries;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.replicator.service.ISrvEntitySync;
import org.beigesoft.service.ISrvOrm;

public class SrvEntitySyncAccEntry<RS>
implements ISrvEntitySync {
    private ISrvOrm<RS> srvOrm;
    private ISrvBalance srvBalance;
    private final Integer accountingEntriesCode = new AccountingEntries().constTypeCode();

    @Override
    public final boolean sync(Map<String, Object> pAddParam, Object pEntity) throws Exception {
        AccountingEntry entityPb = (AccountingEntry)pEntity;
        int currDbId = this.getSrvOrm().getIdDatabase();
        if (currDbId == entityPb.getIdDatabaseBirth()) {
            throw new ExceptionWithCode(1001, "Foreign entity born in this database! {ID, ID BIRTH, DB BIRTH}: {" + entityPb.getItsId() + ", " + entityPb.getIdBirth() + "," + entityPb.getIdDatabaseBirth());
        }
        String tblNm = pEntity.getClass().getSimpleName().toUpperCase();
        String whereStr = " where " + tblNm + ".IDBIRTH=" + entityPb.getItsId() + " and " + tblNm + ".IDDATABASEBIRTH=" + entityPb.getIdDatabaseBirth();
        AccountingEntry entityPbDb = (AccountingEntry)this.getSrvOrm().retrieveEntityWithConditions(pAddParam, entityPb.getClass(), whereStr);
        if (entityPb.getSourceType().equals(this.accountingEntriesCode)) {
            tblNm = AccountingEntries.class.getSimpleName().toUpperCase();
            whereStr = " where " + tblNm + ".IDBIRTH=" + entityPb.getSourceId() + " and " + tblNm + ".IDDATABASEBIRTH=" + entityPb.getIdDatabaseBirth();
            AccountingEntries accountingEntries = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, AccountingEntries.class, whereStr);
            if (accountingEntries == null) {
                throw new ExceptionWithCode(1001, "Can't find foreign AccountingEntries {ID BIRTH, DB BIRTH}: {" + entityPb.getSourceId() + "," + entityPb.getIdDatabaseBirth());
            }
            entityPb.setSourceId(accountingEntries.getItsId());
        }
        entityPb.setIdBirth(entityPb.getItsId());
        entityPb.setItsId(null);
        boolean isNew = true;
        if (entityPbDb != null) {
            entityPb.setItsId(entityPbDb.getItsId());
            isNew = false;
        }
        this.getSrvBalance().handleNewAccountEntry(pAddParam, null, null, entityPb.getItsDate());
        return isNew;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvBalance getSrvBalance() {
        return this.srvBalance;
    }

    public final void setSrvBalance(ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
    }
}

