/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.persistable.DatabaseInfo;
import org.beigesoft.service.ISrvDatabase;

public abstract class ASrvDatabase<RS>
implements ISrvDatabase<RS> {
    private int idDatabase = 0;
    private ILogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer evalIntegerResult(String pQuery, String pColumnName) throws Exception {
        Integer result = null;
        try (IRecordSet recordSet = null;){
            recordSet = this.retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                result = recordSet.getInteger(pColumnName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Long evalLongResult(String pQuery, String pColumnName) throws Exception {
        Long result = null;
        try (IRecordSet recordSet = null;){
            recordSet = this.retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                result = recordSet.getLong(pColumnName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Float evalFloatResult(String pQuery, String pColumnName) throws Exception {
        Float result = null;
        try (IRecordSet recordSet = null;){
            recordSet = this.retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                result = recordSet.getFloat(pColumnName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Double evalDoubleResult(String pQuery, String pColumnName) throws Exception {
        Double result = null;
        try (IRecordSet recordSet = null;){
            recordSet = this.retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                result = recordSet.getDouble(pColumnName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Double[] evalDoubleResults(String pQuery, String[] pColumnNames) throws Exception {
        Double[] result = new Double[pColumnNames.length];
        try (IRecordSet recordSet = null;){
            recordSet = this.retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                for (int i = 0; i < pColumnNames.length; ++i) {
                    result[i] = recordSet.getDouble(pColumnNames[i]);
                }
            }
        }
        return result;
    }

    @Override
    public final synchronized int getIdDatabase() {
        if (this.idDatabase == 0) {
            try {
                String query = "select count(*) as TOTALROWS from " + DatabaseInfo.class.getSimpleName().toUpperCase() + ";";
                Integer rowCount = this.evalIntegerResult(query, "TOTALROWS");
                if (rowCount != 1) {
                    throw new ExceptionWithCode(1002, "database_info_config_error");
                }
                query = "select DATABASEID from " + DatabaseInfo.class.getSimpleName().toUpperCase() + ";";
                Integer databaseId = this.evalIntegerResult(query, "DATABASEID");
                if (databaseId == null) {
                    throw new ExceptionWithCode(1002, "database_info_config_error");
                }
                this.idDatabase = databaseId;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.idDatabase;
    }

    @Override
    public final int getVersionDatabase() {
        try {
            String query = "select count(*) as TOTALROWS from " + DatabaseInfo.class.getSimpleName().toUpperCase() + ";";
            Integer rowCount = this.evalIntegerResult(query, "TOTALROWS");
            if (rowCount != 1) {
                throw new ExceptionWithCode(1002, "database_info_config_error");
            }
            query = "select DATABASEVERSION from " + DatabaseInfo.class.getSimpleName().toUpperCase() + ";";
            Integer databaseVersion = this.evalIntegerResult(query, "DATABASEVERSION");
            if (databaseVersion == null) {
                throw new ExceptionWithCode(1002, "database_info_config_error");
            }
            return databaseVersion;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

