/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beigesoft.service.IObjectReaderWriter;
import org.beigesoft.service.IUtlReflection;

public class ObjectReaderWriterStd<T>
implements IObjectReaderWriter<T> {
    private IUtlReflection utlReflection;
    private Class<T> objectClass;
    private Set<String> fieldsNames = new HashSet<String>();
    private Map<String, Method> settersMap = new HashMap<String, Method>();
    private Map<String, Method> gettersMap = new HashMap<String, Method>();

    @Override
    public final void write(Map<String, Object> pAddParam, T pObject, Object pFieldVal, String pFieldName) throws Exception {
        Method fldSetter = this.settersMap.get(pFieldName);
        fldSetter.invoke(pObject, pFieldVal);
    }

    @Override
    public final Object read(Map<String, Object> pAddParam, T pObject, String pFieldName) throws Exception {
        Method fldGetter = this.gettersMap.get(pFieldName);
        return fldGetter.invoke(pObject, new Object[0]);
    }

    @Override
    public final Set<String> getFieldsNames() {
        return this.fieldsNames;
    }

    public final synchronized void init(Class<T> pClass) throws Exception {
        Field[] fields;
        this.objectClass = pClass;
        this.fieldsNames.clear();
        this.gettersMap.clear();
        this.settersMap.clear();
        for (Field field : fields = this.getUtlReflection().retrieveFields(this.objectClass)) {
            Method getter = this.getUtlReflection().retrieveGetterForField(pClass, field.getName());
            Method setter = this.getUtlReflection().retrieveSetterForField(pClass, field.getName());
            this.gettersMap.put(field.getName(), getter);
            this.settersMap.put(field.getName(), setter);
            this.fieldsNames.add(field.getName());
        }
    }

    public final IUtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(IUtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }

    public final Class<T> getObjectClass() {
        return this.objectClass;
    }
}

