/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;

public class SrvI18n
implements ISrvI18n {
    private ILogger logger;
    private ResourceBundle messages;
    private final Map<String, ResourceBundle> messagesMap = new HashMap<String, ResourceBundle>();

    public final void initDefault() {
        try {
            this.messages = null;
            this.messages = ResourceBundle.getBundle("Messages");
        }
        catch (Exception e) {
            this.logger.error(null, SrvI18n.class, " when loading msgs for default locale ", e);
        }
        if (this.messages != null) {
            this.messagesMap.put(Locale.getDefault().getLanguage(), this.messages);
            this.logger.info(null, SrvI18n.class, "Added messages for default locale: " + Locale.getDefault());
        } else {
            this.logger.error(null, SrvI18n.class, "There is no messages for current locale: " + Locale.getDefault());
        }
    }

    public final void add(String[] pLangCountries) {
        if (pLangCountries != null && pLangCountries.length % 2 == 0) {
            for (int i = 0; i < pLangCountries.length / 2; ++i) {
                Locale locale = new Locale(pLangCountries[i * 2], pLangCountries[i * 2 + 1]);
                if (this.messages == null || !locale.equals(Locale.getDefault())) {
                    ResourceBundle msgs = null;
                    try {
                        msgs = ResourceBundle.getBundle("Messages", locale);
                    }
                    catch (Exception e) {
                        this.logger.error(null, SrvI18n.class, " when loading msg for locale " + locale, e);
                    }
                    if (msgs != null) {
                        this.messagesMap.put(pLangCountries[i * 2], msgs);
                        this.logger.info(null, SrvI18n.class, "Added messages for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
                        if (this.messages != null) continue;
                        this.messages = msgs;
                        continue;
                    }
                    this.logger.error(null, SrvI18n.class, "There is no messages for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
                    continue;
                }
                this.logger.info(null, SrvI18n.class, "Messages already added as default for lang/country: " + pLangCountries[i * 2] + "/" + pLangCountries[i * 2 + 1]);
            }
        } else {
            String msg = null;
            if (pLangCountries == null) {
                msg = "is null!";
            } else {
                for (String str : pLangCountries) {
                    msg = msg == null ? str : msg + "/" + str;
                }
            }
            this.logger.error(null, SrvI18n.class, "Parameters language error, pLangCountries: " + msg);
        }
    }

    @Override
    public final String getMsg(String key) {
        try {
            return this.messages.getString(key);
        }
        catch (Exception e) {
            return "[" + key + "]";
        }
    }

    @Override
    public final String getMsg(String pKey, String pLang) {
        try {
            ResourceBundle mb = this.messagesMap.get(pLang);
            if (mb != null) {
                return mb.getString(pKey);
            }
            return this.getMsg(pKey);
        }
        catch (Exception e) {
            return "[" + pKey + "]-" + pLang;
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ResourceBundle getMessages() {
        return this.messages;
    }

    public final void setMessages(ResourceBundle pMessages) {
        this.messages = pMessages;
    }

    public final Map<String, ResourceBundle> getMessagesMap() {
        return this.messagesMap;
    }
}

