/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingGlyf;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerGlyf
implements ITableMaker<TableForEmbeddingGlyf> {
    private ILogger logger;
    private boolean isShowDebugMessages;
    private int logDetailLevel;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingGlyf pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        pTde.setOffset(pOs.getSize());
        for (char gid : pUsedCids) {
            int mod4;
            Glyph gl = new Glyph();
            pGls.put(Integer.valueOf(gid), gl);
            if (pTfe.getTtf().getLoca().getOffsets16() != null) {
                gl.setOffset(pTfe.getTtf().getLoca().getOffsets16()[gid]);
                gl.setLength((long)pTfe.getTtf().getLoca().getOffsets16()[gid + '\u0001'] - gl.getOffset());
            } else {
                gl.setOffset(pTfe.getTtf().getLoca().getOffsets32()[gid]);
                gl.setLength(pTfe.getTtf().getLoca().getOffsets32()[gid + '\u0001'] - gl.getOffset());
            }
            if (gl.getLength() <= 0L) continue;
            if (pIs != null) {
                pIs.goAhead(pTfe.getSourceTde().getOffset() + gl.getOffset());
                if (this.isShowDebugMessages && this.logDetailLevel > 114) {
                    this.logger.debug(null, TableMakerGlyf.class, "Copy GID/offsetIs/offsetOs/offset/length " + gid + "/" + pIs.getOffset() + "/" + pOs.getSize() + "/" + gl.getOffset() + "/" + gl.getLength());
                }
                gl.setOffset(pOs.getSize() - pTde.getOffset());
                pOs.copyBytes(pIs, gl.getLength(), pTde, pCurrLongChksum);
            } else {
                if (this.isShowDebugMessages && this.logDetailLevel > 114) {
                    this.logger.debug(null, TableMakerGlyf.class, "Try to copy GID/offsetOs/offset/length " + gid + "/" + pOs.getSize() + "/" + gl.getOffset() + "/" + gl.getLength());
                }
                byte[] glypfData = Arrays.copyOfRange(pTfe.getTtf().getGlyf().getBufferInputStream().getBuffer(), (int)gl.getOffset(), (int)(gl.getOffset() + gl.getLength()));
                pOs.writeByteArr(glypfData, pTde, pCurrLongChksum);
            }
            if ((mod4 = (int)gl.getLength() % 4) == 0) continue;
            if (this.isShowDebugMessages && this.logDetailLevel > 114) {
                this.logger.debug(null, TableMakerGlyf.class, "4-bytes aligned GID/count zeros " + gid + "/" + (4 - mod4));
            }
            pOs.writeZeroBytes(4 - mod4, pTde, pCurrLongChksum);
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerGlyf.class, "Added glyf checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }

    public final int getLogDetailLevel() {
        return this.logDetailLevel;
    }

    public final void setLogDetailLevel(int pLogDetailLevel) {
        this.logDetailLevel = pLogDetailLevel;
    }
}

