/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingHhea;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerHhea
implements ITableMaker<TableForEmbeddingHhea> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingHhea pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        int numGlyphs = pUsedCids.get(pUsedCids.size() - 1).charValue() + '\u0001';
        pTde.setOffset(pOs.getSize());
        pTde.setLength(0L);
        pOs.writeByteArr(pTfe.getHhea().getVersion(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getAscent(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getDescent(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getLineGap(), pTde, pCurrLongChksum);
        pOs.writeUInt16(pTfe.getHhea().getAdvanceWidthMax(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getMinLeftSideBearing(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getMinRightSideBearing(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getXMaxExtent(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getCaretSlopeRise(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getCaretSlopeRun(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getCaretOffset(), pTde, pCurrLongChksum);
        pOs.writeByteArr(pTfe.getHhea().getReserved(), pTde, pCurrLongChksum);
        pOs.writeSInt16(pTfe.getHhea().getMetricDataFormat(), pTde, pCurrLongChksum);
        int nolm = Math.min(numGlyphs, pTfe.getHhea().getNumOfLongHorMetrics());
        pOs.writeUInt16(nolm, pTde, pCurrLongChksum);
        int mod4 = (int)pTde.getLength() % 4;
        if (mod4 != 0) {
            pOs.addZeroBytesToCheksum(4 - mod4, pTde, pCurrLongChksum);
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TableMakerHhea.class, "hhea added zeros to checksum " + (4 - mod4));
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerHhea.class, "Added hhea checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

