/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbedding;
import org.beigesoft.ttf.model.TtfFont;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITtfCompactFontMaker;
import org.beigesoft.ttf.service.ITtfSourceStreamer;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TtfCompactFontMaker
implements ITtfCompactFontMaker {
    private ILogger logger;
    private Map<String, TtfFont> ttfFonts;
    private Map<String, ITtfSourceStreamer> ttfFontsStreamers;
    private Map<String, String> ttfFontsPaths;
    private boolean isShowDebugMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] make(Map<String, Object> pAddParam, String pFontName, List<Character> pUsedCids) throws Exception {
        ITtfSourceStreamer ttfStreamer = this.ttfFontsStreamers.get(pFontName);
        TtfFont ttfFont = this.ttfFonts.get(pFontName);
        String fntPath = this.ttfFontsPaths.get(pFontName);
        if (ttfFont == null || ttfStreamer == null || fntPath == null) {
            throw new ExceptionPdfWr("There is no TTF font data for " + pFontName + "!");
        }
        if (ttfFont.getGlyf().getBufferInputStream() != null) {
            return this.makeCompact(pAddParam, ttfFont, null, pUsedCids);
        }
        this.logger.info(null, TtfCompactFontMaker.class, "Make input stream for font " + pFontName);
        try (TtfInputStream is = null;){
            is = ttfStreamer.makeInputStream(fntPath);
            byte[] byArray = this.makeCompact(pAddParam, ttfFont, is, pUsedCids);
            return byArray;
        }
    }

    public final byte[] makeCompact(Map<String, Object> pAddParam, TtfFont pTtf, TtfInputStream pIs, List<Character> pUsedCids) throws Exception {
        this.isShowDebugMessages = this.logger.getIsShowDebugMessagesFor(this.getClass());
        TtfOutputStream os = new TtfOutputStream(new ByteArrayOutputStream());
        os.writeUInt32(pTtf.getScalerType());
        int numTables = pTtf.getTablesForEmbedding().size();
        os.write(0);
        os.write(numTables);
        int mp2lent = numTables < 4 ? 2 : (numTables < 8 ? 4 : (numTables < 16 ? 8 : 16));
        int searchRange = mp2lent * 16;
        os.writeUInt16(searchRange);
        int entrySelector = (int)(Math.log(mp2lent) / Math.log(2.0));
        os.writeUInt16(entrySelector);
        int rangeShift = numTables * 16 - searchRange;
        os.writeUInt16(rangeShift);
        Long ofst = os.getSize() + (long)(numTables * 16);
        ArrayList<TtfTableDirEntry> tdes = new ArrayList<TtfTableDirEntry>();
        for (TableForEmbedding tfe : pTtf.getTablesForEmbedding()) {
            TtfTableDirEntry tde = tfe.getTdeMaker().makeTde(os, tfe, ofst);
            tdes.add(tde);
            if (ofst != null && tfe.getIsLengthSame()) {
                ofst = tde.getOffset() + tde.getLength();
                continue;
            }
            ofst = null;
        }
        HashMap<Integer, Glyph> gls = new HashMap<Integer, Glyph>();
        long[] currLongChksum = new long[]{-1L, -1L, -1L, -1L};
        for (int i = 0; i < pTtf.getTablesForEmbedding().size(); ++i) {
            TableForEmbedding tfe = pTtf.getTablesForEmbedding().get(i);
            tfe.getTableMaker().makeTable(pIs, os, tfe, (TtfTableDirEntry)tdes.get(i), currLongChksum, pUsedCids, gls);
            if (currLongChksum[0] == -1L) continue;
            throw new ExceptionPdfWr("Algorithm 4-bytes align ckecksum error!!! Table " + ((TtfTableDirEntry)tdes.get(i)).getTagString());
        }
        ByteArrayOutputStream baos = (ByteArrayOutputStream)os.getOutputStream();
        byte[] fntData = baos.toByteArray();
        for (TtfTableDirEntry tde : tdes) {
            this.fixTde(fntData, tde);
        }
        return fntData;
    }

    public final void fixTde(byte[] pArr, TtfTableDirEntry pTde) {
        if (pTde.getChecksumIdx() != null) {
            this.replaceUInt32(pArr, pTde.getChecksumIdx(), pTde.getChecksum());
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TtfCompactFontMaker.class, "Replaced checksum  tde/idx/value " + pTde.getTagString() + "/" + pTde.getChecksumIdx() + "/" + pTde.getChecksum());
            }
        }
        if (pTde.getOffsetIdx() != null) {
            this.replaceUInt32(pArr, pTde.getOffsetIdx(), pTde.getOffset());
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TtfCompactFontMaker.class, "Replaced offset tde/idx/value " + pTde.getTagString() + "/" + pTde.getOffsetIdx() + "/" + pTde.getOffset());
            }
        }
        if (pTde.getLengthIdx() != null) {
            this.replaceUInt32(pArr, pTde.getLengthIdx(), pTde.getLength());
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TtfCompactFontMaker.class, "Replaced length  tde/idx/value " + pTde.getTagString() + "/" + pTde.getLengthIdx() + "/" + pTde.getLength());
            }
        }
    }

    public final void replaceUInt32(byte[] pArr, int pIdx, long pData) {
        pArr[pIdx] = (byte)(pData >>> 24);
        pArr[pIdx + 1] = (byte)(pData >>> 16);
        pArr[pIdx + 2] = (byte)(pData >>> 8);
        pArr[pIdx + 3] = (byte)pData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] loadWholeFromResource(Map<String, Object> pAddParam, String pFontName, List<Character> pUsedCids) throws Exception {
        String fntFlNm = "/" + pFontName + ".ttf";
        URL url = TtfCompactFontMaker.class.getResource(fntFlNm);
        if (url != null) {
            this.logger.info(null, TtfCompactFontMaker.class, "Loading font " + pFontName);
            try (InputStream is = null;){
                int ibyte;
                is = TtfCompactFontMaker.class.getResourceAsStream(fntFlNm);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while ((ibyte = is.read()) != -1) {
                    os.write(ibyte);
                }
                byte[] byArray = os.toByteArray();
                return byArray;
            }
        }
        throw new ExceptionPdfWr("There is no file " + pFontName + "!");
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final Map<String, TtfFont> getTtfFonts() {
        return this.ttfFonts;
    }

    public final void setTtfFonts(Map<String, TtfFont> pTtfFonts) {
        this.ttfFonts = pTtfFonts;
    }

    public final Map<String, ITtfSourceStreamer> getTtfFontsStreamers() {
        return this.ttfFontsStreamers;
    }

    public final void setTtfFontsStreamers(Map<String, ITtfSourceStreamer> pTtfFontsStreamers) {
        this.ttfFontsStreamers = pTtfFontsStreamers;
    }

    public final Map<String, String> getTtfFontsPaths() {
        return this.ttfFontsPaths;
    }

    public final void setTtfFontsPaths(Map<String, String> pTtfFontsPaths) {
        this.ttfFontsPaths = pTtfFontsPaths;
    }
}

