/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.model;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.model.IRequestData;

public class HttpRequestData
implements IRequestData {
    private final HttpServletRequest httpReq;
    private final HttpServletResponse httpResp;

    public HttpRequestData(HttpServletRequest pHttpReq, HttpServletResponse pHttpResp) {
        this.httpReq = pHttpReq;
        this.httpResp = pHttpResp;
    }

    @Override
    public final String getParameter(String pParamName) {
        return this.httpReq.getParameter(pParamName);
    }

    @Override
    public final String[] getParameterValues(String pParamName) {
        return this.httpReq.getParameterValues(pParamName);
    }

    @Override
    public final Map<String, String[]> getParameterMap() {
        return this.httpReq.getParameterMap();
    }

    @Override
    public final String getUserName() {
        if (this.httpReq.getUserPrincipal() != null) {
            return this.httpReq.getUserPrincipal().getName();
        }
        return null;
    }

    @Override
    public final Object getAttribute(String pAttrName) {
        return this.httpReq.getAttribute(pAttrName);
    }

    @Override
    public final void setAttribute(String pAttrName, Object pAttribute) {
        this.httpReq.setAttribute(pAttrName, pAttribute);
    }

    @Override
    public final String getCookieValue(String pName) {
        if (this.httpReq.getCookies() == null) {
            return null;
        }
        for (Cookie co : this.httpReq.getCookies()) {
            if (!co.getName().equals(pName)) continue;
            return co.getValue();
        }
        return null;
    }

    @Override
    public final void setCookieValue(String pName, String pValue) {
        String path;
        Cookie cookie = null;
        if (this.httpReq.getCookies() != null) {
            for (Cookie co : this.httpReq.getCookies()) {
                if (!co.getName().equals(pName)) continue;
                cookie = co;
                cookie.setValue(pValue);
                break;
            }
        }
        if (cookie == null) {
            cookie = new Cookie(pName, pValue);
            cookie.setMaxAge(Integer.MAX_VALUE);
        }
        if ("".equals(path = this.httpReq.getServletContext().getContextPath())) {
            path = "/";
        }
        cookie.setPath(path);
        this.httpResp.addCookie(cookie);
    }

    @Override
    public final Locale getLocale() {
        return this.httpReq.getLocale();
    }

    public final HttpServletRequest getHttpReq() {
        return this.httpReq;
    }

    public final HttpServletResponse getHttpResp() {
        return this.httpResp;
    }
}

