/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.model.HttpRequestData;
import org.beigesoft.web.service.SrvAddTheFirstUser;
import org.beigesoft.web.service.UtlJsp;

public class WJspPublic
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "INIT", e);
                }
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    public final void doWork(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        try {
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            if (pReq.getParameter("logoff") != null) {
                pReq.getSession().invalidate();
            }
            ISrvI18n srvI18n = (ISrvI18n)this.factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)this.factoryAppBeans.lazyGet("UtlJsp");
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnd = pReq.getParameter("nmRnd");
            SrvAddTheFirstUser srvAddFiU = (SrvAddTheFirstUser)this.getServletContext().getAttribute("srvAddTheFirstUser");
            if (srvAddFiU != null && !srvAddFiU.checkIsThereAnyUser()) {
                nmRnd = "addFirstUser";
            } else if (nmRnd == null || nmRnd.length() == 0) {
                nmRnd = "index";
            }
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

