/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.replicator.service.ReplicatorXmlHttps;
import org.beigesoft.web.factory.AFactoryAppBeans;

public class WReplicator
extends HttpServlet {
    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        pResp.setContentType("text/html; charset=UTF-8");
        pResp.setStatus(200);
        AFactoryAppBeans factoryAppBeans = null;
        try {
            factoryAppBeans = (AFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            String replicatorName = pReq.getParameter("replicatorName");
            ReplicatorXmlHttps replicator = (ReplicatorXmlHttps)factoryAppBeans.lazyGet(replicatorName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Map<String, String[]> parameterMap = pReq.getParameterMap();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                params.put(entry.getKey(), entry.getValue()[0]);
            }
            String urlSource = "https://" + pReq.getParameter("urlSource");
            String userName = pReq.getParameter("userName");
            if (userName != null && userName.trim().length() > 0) {
                params.put("authMethod", "form");
                String urlBase = urlSource.substring(0, urlSource.indexOf("secure") - 1);
                params.put("urlBase", urlBase);
                params.put("authUrl", urlBase + "/secure/j_security_check");
                params.put("urlGetAuthCookies", urlBase + "/secure/jspd?nmRnd=main");
                params.put("authUserName", "j_username");
                params.put("authUserPass", "j_password");
            }
            PrintWriter writer = pResp.getWriter();
            params.put("htmlWriter", writer);
            writer.println("<!DOCTYPE html>");
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<meta charset=\"UTF-8\"/>");
            writer.println("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no\"/>");
            writer.println("<link rel=\"shortcut icon\" href=\"../static/img/favicon.png\"/>");
            writer.println("<link rel=\"stylesheet\" href=\"../static/css/beige.common.css\"/>");
            writer.println("<title>Replication data</title>");
            writer.println("</head>");
            writer.println("<body style=\"padding: 20px;\">");
            writer.println("<a href=\"../\" class=\"btn\">Home</a>");
            writer.println("<div style=\"text-align: center;\">");
            writer.println("<h3>Replication data from " + urlSource + "</h3>");
            writer.println("</div>");
            writer.println("<div>");
            replicator.replicate(params);
            writer.println("</div>");
            writer.println("</body>");
            writer.println("</html>");
            writer.close();
            if (replicatorName.equals("importFullDatabaseCopy")) {
                factoryAppBeans.handleDatabaseChanged();
            }
        }
        catch (Exception e) {
            if (factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }
}

