/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.handler.IHndlFileReportReq;
import org.beigesoft.log.ILogger;
import org.beigesoft.web.model.HttpRequestData;

public class WReportCsv
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;

    @Override
    public final void init() throws ServletException {
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "INIT", e);
                }
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doReportCsv(pReq, pResp);
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doReportCsv(pReq, pResp);
    }

    public final void doReportCsv(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        try {
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            String nameHandler = pReq.getParameter("nmHnd");
            IHndlFileReportReq srvHandleRequest = (IHndlFileReportReq)this.factoryAppBeans.lazyGet(nameHandler);
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            pResp.setContentType("text/csv");
            String fileName = pReq.getParameter("fileName");
            if (fileName == null || "".equals(fileName)) {
                fileName = "data";
            }
            pResp.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".csv");
            srvHandleRequest.handle(reqVars, requestData, pResp.getOutputStream());
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }
}

