/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.log.ILogger;
import org.beigesoft.replicator.service.IDatabaseWriter;

public class WSendEntities
extends HttpServlet {
    private String contentType;

    @Override
    public final void init() throws ServletException {
        this.contentType = this.getInitParameter("contentType");
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        pResp.setContentType(this.contentType + " charset=UTF-8");
        pResp.setStatus(200);
        IFactoryAppBeans factoryAppBeans = null;
        try {
            factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            String databaseWriterName = pReq.getParameter("writerName");
            IDatabaseWriter databaseWriter = (IDatabaseWriter)factoryAppBeans.lazyGet(databaseWriterName);
            PrintWriter writer = pResp.getWriter();
            Class<?> entityClass = Class.forName(pReq.getParameter("entityName"));
            HashMap<String, Object> params = new HashMap<String, Object>();
            String requestingDatabaseVersion = pReq.getParameter("requestingDatabaseVersion");
            params.put("requestingDatabaseVersion", requestingDatabaseVersion);
            String requestedDatabaseId = pReq.getParameter("requestedDatabaseId");
            params.put("requestedDatabaseId", requestedDatabaseId);
            String conditions = pReq.getParameter("conditions");
            params.put("conditions", conditions);
            databaseWriter.retrieveAndWriteEntities(params, entityClass, writer);
            writer.close();
        }
        catch (Exception e) {
            if (factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(String pContentType) {
        this.contentType = pContentType;
    }
}

