/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.model.HttpRequestData;
import org.beigesoft.web.service.UtlJsp;

public class WUploadSingle
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "INIT", e);
                }
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        try {
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            String fileParam = pReq.getParameter("paramNameFileToUpload");
            if (fileParam != null) {
                Part filePart = pReq.getPart(fileParam);
                String fileName = this.getSubmittedFileName(filePart);
                InputStream fileToUploadIs = filePart.getInputStream();
                requestData.setAttribute("fileToUploadInputStream", fileToUploadIs);
                requestData.setAttribute("fileToUploadName", fileName);
            }
            String nameHandlerUpload = pReq.getParameter("nmHnd");
            IHandlerRequest srvHandleRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet(nameHandlerUpload);
            srvHandleRequest.handle(reqVars, requestData);
            ISrvI18n srvI18n = (ISrvI18n)this.factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)this.factoryAppBeans.lazyGet("UtlJsp");
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            pResp.setCharacterEncoding("UTF-8");
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final String getSubmittedFileName(Part pPart) throws Exception {
        for (String cd : pPart.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String fileName = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return fileName.substring(fileName.lastIndexOf(47) + 1).substring(fileName.lastIndexOf(92) + 1);
        }
        throw new ExceptionWithCode(1001, "Can't retrieve file name");
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

