/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.handler;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IHasId;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.IFillerObjectsFrom;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class HndlSeSellerReq<RS>
implements IHandlerRequest {
    private IHandlerRequest i18nRequestHandler;
    private ILogger logger;
    private ILogger secureLogger;
    private ISrvDatabase<RS> srvDatabase;
    private IFillerObjectsFrom<IRequestData> fillEntityFromReq;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;
    private IFactoryAppBeansByName<IEntityProcessor> entitiesProcessorsFactory;
    private IHolderForClassByName<String> entitiesProcessorsNamesHolder;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;
    private IHolderForClassByName<String> processorsNamesHolder;
    private Map<String, Class<?>> entitiesMap;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        this.i18nRequestHandler.handle(pReqVars, pRequestData);
        String nmEnt = pRequestData.getParameter("nmEnt");
        if (nmEnt != null) {
            int detLev = this.logger.getDetailLevel();
            boolean isShowDebMsg = this.logger.getIsShowDebugMessages() && this.logger.getIsShowDebugMessagesFor(this.getClass());
            try {
                String[] actionsArr = pRequestData.getParameter("nmsAct").split(",");
                Class<?> entityClass = this.entitiesMap.get(nmEnt);
                if (entityClass == null) {
                    this.secureLogger.error(null, HndlSeSellerReq.class, "Trying to work with forbidden entity/seseller: " + nmEnt + "/" + pRequestData.getUserName());
                    throw new ExceptionWithCode(403, "Forbidden!");
                }
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                IHasId entity = null;
                if (actionsArr[0].startsWith("entity")) {
                    IFactorySimple<?> entFac = this.entitiesFactoriesFatory.lazyGet(pReqVars, entityClass);
                    entity = (IHasId)entFac.create(pReqVars);
                    this.fillEntityFromReq.fill(pReqVars, entity, pRequestData);
                }
                for (String actionNm : actionsArr) {
                    if (isShowDebMsg && detLev > 100) {
                        this.logger.debug(pReqVars, HndlSeSellerReq.class, "Action: " + actionNm);
                    }
                    if (actionNm.startsWith("entity")) {
                        if (entity == null) {
                            entity = (IHasId)pReqVars.get("nextEntity");
                            if (entity == null) {
                                throw new ExceptionWithCode(1003, "wrong_request_entity_not_filled");
                            }
                            entityClass = entity.getClass();
                        }
                        String entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionNm);
                        IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pReqVars, entProcNm);
                        if (isShowDebMsg && detLev > 100) {
                            this.logger.debug(pReqVars, HndlSeSellerReq.class, "It's used entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                        }
                        entity = ep.process(pReqVars, entity, pRequestData);
                        continue;
                    }
                    String procNm = this.processorsNamesHolder.getFor(entityClass, actionNm);
                    IProcessor proc = this.processorsFactory.lazyGet(pReqVars, procNm);
                    if (isShowDebMsg && detLev > 100) {
                        this.logger.debug(pReqVars, HndlSeSellerReq.class, "It's used procNm/IProcessor: " + procNm + "/" + proc.getClass());
                    }
                    proc.process(pReqVars, pRequestData);
                }
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        }
    }

    public final IHandlerRequest getI18nRequestHandler() {
        return this.i18nRequestHandler;
    }

    public final void setI18nRequestHandler(IHandlerRequest pI18nRequestHandler) {
        this.i18nRequestHandler = pI18nRequestHandler;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IFillerObjectsFrom<IRequestData> getFillEntityFromReq() {
        return this.fillEntityFromReq;
    }

    public final void setFillEntityFromReq(IFillerObjectsFrom<IRequestData> pFillEntityFromReq) {
        this.fillEntityFromReq = pFillEntityFromReq;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }

    public final IFactoryAppBeansByName<IEntityProcessor> getEntitiesProcessorsFactory() {
        return this.entitiesProcessorsFactory;
    }

    public final void setEntitiesProcessorsFactory(IFactoryAppBeansByName<IEntityProcessor> pEntitiesProcessorsFactory) {
        this.entitiesProcessorsFactory = pEntitiesProcessorsFactory;
    }

    public final IHolderForClassByName<String> getEntitiesProcessorsNamesHolder() {
        return this.entitiesProcessorsNamesHolder;
    }

    public final void setEntitiesProcessorsNamesHolder(IHolderForClassByName<String> pEntitiesProcessorsNamesHolder) {
        this.entitiesProcessorsNamesHolder = pEntitiesProcessorsNamesHolder;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }

    public final IHolderForClassByName<String> getProcessorsNamesHolder() {
        return this.processorsNamesHolder;
    }

    public final void setProcessorsNamesHolder(IHolderForClassByName<String> pProcessorsNamesHolder) {
        this.processorsNamesHolder = pProcessorsNamesHolder;
    }

    public final Map<String, Class<?>> getEntitiesMap() {
        return this.entitiesMap;
    }

    public final void setEntitiesMap(Map<String, Class<?>> pEntitiesMap) {
        this.entitiesMap = pEntitiesMap;
    }

    public final ILogger getSecureLogger() {
        return this.secureLogger;
    }

    public final void setSecureLogger(ILogger pSecureLogger) {
        this.secureLogger = pSecureLogger;
    }
}

