/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.CartItem;
import org.beigesoft.webstore.persistable.ShoppingCart;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcDelItemFromCart<RS>
implements IProcessor {
    private String queryCartTotals;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvShoppingCart;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        Double[] totals;
        ShoppingCart shoppingCart = this.srvShoppingCart.getShoppingCart(pAddParam, pRequestData, false);
        if (shoppingCart == null || shoppingCart.getItsItems() == null) {
            throw new ExceptionWithCode(1001, "there_is_no_cart_for_requestor");
        }
        String cartItemItsIdStr = pRequestData.getParameter("cartItemItsId");
        if (cartItemItsIdStr != null) {
            Long cartItemItsId = Long.valueOf(cartItemItsIdStr);
            CartItem cartItem = null;
            for (CartItem ci : shoppingCart.getItsItems()) {
                if (!ci.getItsId().equals(cartItemItsId)) continue;
                if (ci.getIsDisabled().booleanValue()) {
                    throw new ExceptionWithCode(1001, "requested_item_disabled");
                }
                cartItem = ci;
                break;
            }
            if (cartItem == null) {
                throw new ExceptionWithCode(1001, "requested_item_not_found");
            }
            cartItem.setIsDisabled(true);
            this.getSrvOrm().updateEntity(pAddParam, cartItem);
            String query = this.lazyGetQueryCartTotals();
            query = query.replace(":CARTID", shoppingCart.getItsId().getItsId().toString());
            String[] columns = new String[]{"ITSTOTAL", "TOTALITEMS"};
            totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            if (totals[0] == null) {
                totals[0] = 0.0;
            }
            if (totals[1] == null) {
                totals[1] = 0.0;
            }
        } else {
            throw new ExceptionWithCode(1001, "there_is_no_cart_item_id");
        }
        AccSettings accSettings = (AccSettings)pAddParam.get("accSettings");
        shoppingCart.setItsTotal(BigDecimal.valueOf(totals[0]).setScale((int)accSettings.getPricePrecision(), accSettings.getRoundingMode()));
        shoppingCart.setTotalItems(totals[1].intValue());
        this.getSrvOrm().updateEntity(pAddParam, shoppingCart);
        pRequestData.setAttribute("shoppingCart", shoppingCart);
        String processorName = pRequestData.getParameter("nmPrcRedirect");
        IProcessor proc = this.processorsFactory.lazyGet(pAddParam, processorName);
        proc.process(pAddParam, pRequestData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcDelItemFromCart.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcDelItemFromCart.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String lazyGetQueryCartTotals() throws Exception {
        if (this.queryCartTotals == null) {
            String flName = "/webstore/cartTotals.sql";
            this.queryCartTotals = this.loadString(flName);
        }
        return this.queryCartTotals;
    }

    public final void setQueryCartTotals(String pQueryCartTotals) {
        this.queryCartTotals = pQueryCartTotals;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

