/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.persistable.CartItem;
import org.beigesoft.webstore.persistable.GoodsPlace;
import org.beigesoft.webstore.persistable.GoodsSpecifics;
import org.beigesoft.webstore.persistable.PriceGoods;
import org.beigesoft.webstore.persistable.ServicePlace;
import org.beigesoft.webstore.persistable.ServicePrice;
import org.beigesoft.webstore.persistable.ServiceSpecifics;
import org.beigesoft.webstore.persistable.ShoppingCart;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.AItemPrice;
import org.beigesoft.webstore.persistable.base.AItemSpecifics;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcItemPage<RS>
implements IProcessor {
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvShoppingCart;
    private String querySpecificsGoodsDetailI18n;
    private String querySpecificsServiceDetailI18n;

    @Override
    public final void process(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        String itemTypeStr = pRequestData.getParameter("itemType");
        if (EShopItemType.GOODS.toString().equals(itemTypeStr)) {
            this.processGoods(pReqVars, pRequestData);
        } else if (EShopItemType.SERVICE.toString().equals(itemTypeStr)) {
            this.processService(pReqVars, pRequestData);
        } else {
            throw new Exception("Detail page not yet implemented for item type: " + itemTypeStr);
        }
    }

    public final void processGoods(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        ShoppingCart shoppingCart;
        Long itemId = Long.valueOf(pRequestData.getParameter("itemId"));
        List<GoodsSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pReqVars, itemId, GoodsSpecifics.class, InvItem.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRequestData.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        PriceGoods itemPrice = this.retrieveItemPrice(pReqVars, itemId, PriceGoods.class);
        List<GoodsPlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, GoodsPlace.class, " where ITEM=" + itemId);
        if (pRequestData.getAttribute("shoppingCart") == null && (shoppingCart = this.srvShoppingCart.getShoppingCart(pReqVars, pRequestData, false)) != null) {
            pRequestData.setAttribute("shoppingCart", shoppingCart);
        }
        if (pRequestData.getAttribute("shoppingCart") != null && (shoppingCart = (ShoppingCart)pRequestData.getAttribute("shoppingCart")).getItsItems() != null) {
            String itemTypeStr = pRequestData.getParameter("itemType");
            for (CartItem ci : shoppingCart.getItsItems()) {
                if (ci.getIsDisabled().booleanValue() || !ci.getItemId().equals(itemId) || !ci.getItemType().toString().equals(itemTypeStr)) continue;
                pRequestData.setAttribute("cartItem", ci);
                break;
            }
        }
        pRequestData.setAttribute("itemSpecLst", itemSpecLst);
        pRequestData.setAttribute("itemPlaceLst", itemPlaceLst);
        pRequestData.setAttribute("itemPrice", itemPrice);
    }

    public final void processService(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        ShoppingCart shoppingCart;
        Long itemId = Long.valueOf(pRequestData.getParameter("itemId"));
        List<ServiceSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pReqVars, itemId, ServiceSpecifics.class, ServiceToSale.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRequestData.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        ServicePrice itemPrice = this.retrieveItemPrice(pReqVars, itemId, ServicePrice.class);
        List<ServicePlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, ServicePlace.class, " where ITEM=" + itemId);
        if (pRequestData.getAttribute("shoppingCart") == null && (shoppingCart = this.srvShoppingCart.getShoppingCart(pReqVars, pRequestData, false)) != null) {
            pRequestData.setAttribute("shoppingCart", shoppingCart);
        }
        if (pRequestData.getAttribute("shoppingCart") != null && (shoppingCart = (ShoppingCart)pRequestData.getAttribute("shoppingCart")).getItsItems() != null) {
            String itemTypeStr = pRequestData.getParameter("itemType");
            for (CartItem ci : shoppingCart.getItsItems()) {
                if (ci.getIsDisabled().booleanValue() || !ci.getItemId().equals(itemId) || !ci.getItemType().toString().equals(itemTypeStr)) continue;
                pRequestData.setAttribute("cartItem", ci);
                break;
            }
        }
        pRequestData.setAttribute("itemSpecLst", itemSpecLst);
        pRequestData.setAttribute("itemPlaceLst", itemPlaceLst);
        pRequestData.setAttribute("itemPrice", itemPrice);
    }

    public final <T extends AItemPrice<?, ?>> T retrieveItemPrice(Map<String, Object> pReqVars, Long pItemId, Class<T> pItemPriceCl) throws Exception {
        TradingSettings ts = (TradingSettings)pReqVars.get("tradingSettings");
        if (ts.getIsUsePriceForCustomer().booleanValue()) {
            throw new Exception("Method price depends of customer's category not yet implemented!");
        }
        List<T> lst = this.getSrvOrm().retrieveListWithConditions(pReqVars, pItemPriceCl, " where ITEM=" + pItemId);
        if (lst.size() == 1) {
            return (T)((AItemPrice)lst.get(0));
        }
        String itemName = lst.size() > 0 ? ((AItemPrice)lst.get(0)).getItem().getItsName() : "?";
        this.logger.error(null, PrcItemPage.class, "It must be only price for goods/service: ID/Name/prices count/class" + pItemId + "/" + itemName + "/" + lst.size() + "/" + pItemPriceCl);
        return null;
    }

    public final <T extends AItemSpecifics<?, ?>> List<T> retrieveItemSpecificsList(Map<String, Object> pReqVars, Long pItemId, Class<T> pItemSpecCl, String pItemSn) throws Exception {
        String langDef;
        String lang;
        pReqVars.put(pItemSpecCl.getSimpleName() + "specificsdeepLevel", 3);
        HashSet<String> goodsFldNms = new HashSet<String>();
        goodsFldNms.add("itsId");
        goodsFldNms.add("itsName");
        pReqVars.put(pItemSn + "neededFields", goodsFldNms);
        HashSet<String> soiFldNms = new HashSet<String>();
        soiFldNms.add("itsId");
        soiFldNms.add("itsName");
        soiFldNms.add("isShowInList");
        soiFldNms.add("itsType");
        soiFldNms.add("itsGroop");
        soiFldNms.add("tempHtml");
        pReqVars.put("SpecificsOfItemneededFields", soiFldNms);
        HashSet<String> soigFldNms = new HashSet<String>();
        soigFldNms.add("itsId");
        soigFldNms.add("itsName");
        soigFldNms.add("templateStart");
        soigFldNms.add("templateEnd");
        soigFldNms.add("templateDetail");
        pReqVars.put("SpecificsOfItemGroupneededFields", soigFldNms);
        HashSet<String> htmTmFldNms = new HashSet<String>();
        htmTmFldNms.add("itsId");
        htmTmFldNms.add("htmlTemplate");
        pReqVars.put("HtmlTemplateneededFields", htmTmFldNms);
        TradingSettings tradingSettings = (TradingSettings)pReqVars.get("tradingSettings");
        List<T> result = null;
        if (tradingSettings.getUseAdvancedI18n().booleanValue() && !(lang = (String)pReqVars.get("lang")).equals(langDef = (String)pReqVars.get("langDef"))) {
            String qd;
            if (pItemSpecCl == GoodsSpecifics.class) {
                qd = this.lazyGetQuerySpecificsGoodsDetailI18n().replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else if (pItemSpecCl == ServiceSpecifics.class) {
                qd = this.lazyGetQuerySpecificsServiceDetailI18n().replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else {
                throw new Exception("NYI for " + pItemSpecCl);
            }
            result = this.getSrvOrm().retrieveListByQuery(pReqVars, pItemSpecCl, qd);
        }
        if (result == null) {
            result = this.getSrvOrm().retrieveListWithConditions(pReqVars, pItemSpecCl, " where " + pItemSpecCl.getSimpleName().toUpperCase() + ".ITEM=" + pItemId + " order by SPECIFICS.ITSINDEX");
        }
        pReqVars.remove(pItemSpecCl.getSimpleName() + "specificsdeepLevel");
        pReqVars.remove(pItemSn + "neededFields");
        pReqVars.remove("SpecificsOfItemneededFields");
        pReqVars.remove("SpecificsOfItemGroupneededFields");
        pReqVars.remove("HtmlTemplateneededFields");
        return result;
    }

    public final String lazyGetQuerySpecificsGoodsDetailI18n() throws Exception {
        if (this.querySpecificsGoodsDetailI18n == null) {
            String flName = "/webstore/specificsGoodsDetailI18n.sql";
            this.querySpecificsGoodsDetailI18n = this.loadString(flName);
        }
        return this.querySpecificsGoodsDetailI18n;
    }

    public final String lazyGetQuerySpecificsServiceDetailI18n() throws Exception {
        if (this.querySpecificsServiceDetailI18n == null) {
            String flName = "/webstore/serviceSpecificsDetailI18n.sql";
            this.querySpecificsServiceDetailI18n = this.loadString(flName);
        }
        return this.querySpecificsServiceDetailI18n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcItemPage.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcItemPage.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final void setQuerySpecificsServiceDetailI18n(String pQuerySpecificsServiceDetailI18n) {
        this.querySpecificsServiceDetailI18n = pQuerySpecificsServiceDetailI18n;
    }

    public final void setQuerySpecificsGoodsDetailI18n(String pQuerySpecificsGoodsDetailI18n) {
        this.querySpecificsGoodsDetailI18n = pQuerySpecificsGoodsDetailI18n;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }
}

