/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.beigesoft.model.IHasIdLongVersion;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.base.AItemSpecifics;
import org.beigesoft.webstore.persistable.base.AItemSpecificsId;

public class PrcItemSpecificsSave<RS, T extends IHasIdLongVersion, ID extends AItemSpecificsId<T>>
implements IEntityProcessor<AItemSpecifics<T, ID>, ID> {
    private ISrvOrm<RS> srvOrm;
    private String uploadDirectory;
    private String webAppPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AItemSpecifics<T, ID> process(Map<String, Object> pAddParam, AItemSpecifics<T, ID> pEntity, IRequestData pRequestData) throws Exception {
        pEntity.setSpecifics(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getSpecifics()));
        if (pEntity.getSpecifics().getChooseableSpecificsType() != null) {
            pEntity.setLongValue2(pEntity.getSpecifics().getChooseableSpecificsType().getItsId());
            pEntity.setStringValue2(pEntity.getSpecifics().getChooseableSpecificsType().getItsName());
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
        } else {
            String fileToUploadName = (String)pRequestData.getAttribute("fileToUploadName");
            if (fileToUploadName != null) {
                OutputStream outs = null;
                InputStream ins = null;
                try {
                    int count;
                    String fileToUploadUrl = this.uploadDirectory + File.separator + new Date().getTime() + fileToUploadName;
                    pEntity.setStringValue1(fileToUploadUrl);
                    String filePath = this.webAppPath + File.separator + fileToUploadUrl;
                    ins = (InputStream)pRequestData.getAttribute("fileToUploadInputStream");
                    outs = new BufferedOutputStream(new FileOutputStream(filePath));
                    byte[] data = new byte[1024];
                    while ((count = ins.read(data)) != -1) {
                        outs.write(data, 0, count);
                    }
                    outs.flush();
                    pEntity.setStringValue2(filePath);
                }
                finally {
                    if (ins != null) {
                        ins.close();
                    }
                    if (outs != null) {
                        outs.close();
                    }
                }
            }
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
        }
        return pEntity;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public final void setUploadDirectory(String pUploadDirectory) {
        this.uploadDirectory = pUploadDirectory;
    }

    public final String getWebAppPath() {
        return this.webAppPath;
    }

    public final void setWebAppPath(String pWebAppPath) {
        this.webAppPath = pWebAppPath;
    }
}

