/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.accounting.persistable.I18nInvItem;
import org.beigesoft.accounting.persistable.I18nServiceToSale;
import org.beigesoft.accounting.persistable.I18nUnitOfMeasure;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.persistable.UnitOfMeasure;
import org.beigesoft.comparator.CmprHasVersion;
import org.beigesoft.model.IHasIdLongVersionName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.AHasIdLong;
import org.beigesoft.persistable.AI18nName;
import org.beigesoft.persistable.LangPreferences;
import org.beigesoft.persistable.Languages;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.persistable.ChooseableSpecifics;
import org.beigesoft.webstore.persistable.GoodsInListLuv;
import org.beigesoft.webstore.persistable.GoodsPlace;
import org.beigesoft.webstore.persistable.GoodsSpecifics;
import org.beigesoft.webstore.persistable.HtmlTemplate;
import org.beigesoft.webstore.persistable.I18nChooseableSpecifics;
import org.beigesoft.webstore.persistable.I18nSpecificInList;
import org.beigesoft.webstore.persistable.I18nSpecificsOfItem;
import org.beigesoft.webstore.persistable.I18nSpecificsOfItemGroup;
import org.beigesoft.webstore.persistable.ItemInList;
import org.beigesoft.webstore.persistable.PriceGoods;
import org.beigesoft.webstore.persistable.ServicePlace;
import org.beigesoft.webstore.persistable.ServicePrice;
import org.beigesoft.webstore.persistable.ServiceSpecifics;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.persistable.SpecificsOfItem;
import org.beigesoft.webstore.persistable.SpecificsOfItemGroup;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.AItemPlace;
import org.beigesoft.webstore.persistable.base.AItemPrice;
import org.beigesoft.webstore.persistable.base.AItemSpecifics;

public class PrcRefreshItemsInList<RS>
implements IProcessor {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final void process(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        this.retrieveStartData(pReqVars);
        SettingsAdd settingsAdd = (SettingsAdd)pReqVars.get("settingsAdd");
        TradingSettings tradingSettings = (TradingSettings)pReqVars.get("tradingSettings");
        GoodsInListLuv goodsInListLuv = (GoodsInListLuv)pReqVars.get("goodsInListLuv");
        pReqVars.remove("goodsInListLuv");
        String refreshAll = pRequestData.getParameter("refreshAll");
        List<GoodsSpecifics> goodsSpecificsLst = refreshAll != null ? this.retrieveItemSpecificsLst(pReqVars, null, GoodsSpecifics.class) : this.retrieveItemSpecificsLst(pReqVars, goodsInListLuv.getGoodsSpecificLuv(), GoodsSpecifics.class);
        this.updateForItemSpecificsList(pReqVars, goodsSpecificsLst, settingsAdd, goodsInListLuv, tradingSettings, I18nInvItem.class, EShopItemType.GOODS);
        pRequestData.setAttribute("totalUpdatedGdSp", goodsSpecificsLst.size());
        goodsSpecificsLst = null;
        List<PriceGoods> goodsPriceLst = refreshAll != null ? this.retrieveItemPriceLst(pReqVars, null, PriceGoods.class) : this.retrieveItemPriceLst(pReqVars, goodsInListLuv.getGoodsPriceLuv(), PriceGoods.class);
        this.updateForItemPriceList(pReqVars, goodsPriceLst, settingsAdd, goodsInListLuv, EShopItemType.GOODS);
        pRequestData.setAttribute("totalUpdatedGdPr", goodsPriceLst.size());
        goodsPriceLst = null;
        List<GoodsPlace> goodsPlaceLst = refreshAll != null ? this.retrieveItemPlaceLst(pReqVars, null, GoodsPlace.class) : this.retrieveItemPlaceLst(pReqVars, goodsInListLuv.getGoodsAvailableLuv(), GoodsPlace.class);
        this.updateForItemPlaceList(pReqVars, goodsPlaceLst, settingsAdd, goodsInListLuv, EShopItemType.GOODS);
        pRequestData.setAttribute("totalUpdatedGdAv", goodsPlaceLst.size());
        goodsPlaceLst = null;
        List<ServiceSpecifics> serviceSpecificsLst = refreshAll != null ? this.retrieveItemSpecificsLst(pReqVars, null, ServiceSpecifics.class) : this.retrieveItemSpecificsLst(pReqVars, goodsInListLuv.getServiceSpecificLuv(), ServiceSpecifics.class);
        this.updateForItemSpecificsList(pReqVars, serviceSpecificsLst, settingsAdd, goodsInListLuv, tradingSettings, I18nServiceToSale.class, EShopItemType.SERVICE);
        pRequestData.setAttribute("totalUpdatedServSp", serviceSpecificsLst.size());
        serviceSpecificsLst = null;
        List<ServicePrice> servicePriceLst = refreshAll != null ? this.retrieveItemPriceLst(pReqVars, null, ServicePrice.class) : this.retrieveItemPriceLst(pReqVars, goodsInListLuv.getServicePriceLuv(), ServicePrice.class);
        this.updateForItemPriceList(pReqVars, servicePriceLst, settingsAdd, goodsInListLuv, EShopItemType.SERVICE);
        pRequestData.setAttribute("totalUpdatedServPr", servicePriceLst.size());
        servicePriceLst = null;
        List<ServicePlace> servicePlaceLst = refreshAll != null ? this.retrieveItemPlaceLst(pReqVars, null, ServicePlace.class) : this.retrieveItemPlaceLst(pReqVars, goodsInListLuv.getServicePlaceLuv(), ServicePlace.class);
        this.updateForItemPlaceList(pReqVars, servicePlaceLst, settingsAdd, goodsInListLuv, EShopItemType.SERVICE);
        pRequestData.setAttribute("totalUpdatedServAv", servicePlaceLst.size());
        servicePlaceLst = null;
        pReqVars.remove("langPreferences");
    }

    public final void retrieveStartData(Map<String, Object> pReqVars) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            GoodsInListLuv goodsInListLuv = this.getSrvOrm().retrieveEntityById(pReqVars, GoodsInListLuv.class, 1L);
            if (goodsInListLuv == null) {
                goodsInListLuv = new GoodsInListLuv();
                goodsInListLuv.setItsId(1L);
                this.getSrvOrm().insertEntity(pReqVars, goodsInListLuv);
            }
            pReqVars.put("goodsInListLuv", goodsInListLuv);
            List<LangPreferences> langPreferences = this.srvOrm.retrieveList(pReqVars, LangPreferences.class);
            pReqVars.put("langPreferences", langPreferences);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final <T extends AItemPlace<?, ?>> List<T> retrieveItemPlaceLst(Map<String, Object> pReqVars, Long pLuv, Class<T> pItemPlaceCl) throws Exception {
        List<T> result = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            String tblNm = pItemPlaceCl.getSimpleName().toUpperCase();
            String verCond = pLuv != null ? " where " + tblNm + ".ITSVERSION>" + pLuv.toString() : "";
            result = this.getSrvOrm().retrieveListWithConditions(pReqVars, pItemPlaceCl, verCond + " order by " + tblNm + ".ITSVERSION");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        return result;
    }

    public final <T extends AItemPlace<I, ?>, I extends IHasIdLongVersionName> void updateForItemPlace(Map<String, Object> pReqVars, T pItemPlace, EShopItemType pItemType) throws Exception {
        String whereStr = "where ITSTYPE=" + pItemType.ordinal() + " and ITEMID=" + ((IHasIdLongVersionName)pItemPlace.getItem()).getItsId();
        ItemInList itemInList = this.getSrvOrm().retrieveEntityWithConditions(pReqVars, ItemInList.class, whereStr);
        if (itemInList == null) {
            itemInList = this.createItemInList(pReqVars, (IHasIdLongVersionName)pItemPlace.getItem());
        }
        itemInList.setAvailableQuantity(pItemPlace.getItsQuantity());
        if (itemInList.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, itemInList);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, itemInList);
        }
    }

    public final <T extends AItemPlace<I, ?>, I extends IHasIdLongVersionName> void updateForItemPlaceList(Map<String, Object> pReqVars, List<T> pItemPlaceLst, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv, EShopItemType pItemType) throws Exception {
        if (pItemPlaceLst.size() == 0) {
            return;
        }
        int steps = pItemPlaceLst.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(pItemPlaceLst.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    AItemPlace itemPlace = (AItemPlace)pItemPlaceLst.get(i);
                    this.updateForItemPlace(pReqVars, itemPlace, pItemType);
                    lastUpdatedVersion = itemPlace.getItsVersion();
                }
                if (pItemType == EShopItemType.GOODS) {
                    pGoodsInListLuv.setGoodsAvailableLuv(lastUpdatedVersion);
                } else if (pItemType == EShopItemType.SERVICE) {
                    pGoodsInListLuv.setServicePlaceLuv(lastUpdatedVersion);
                } else {
                    throw new Exception("NEI for " + (Object)((Object)pItemType));
                }
                this.getSrvOrm().updateEntity(pReqVars, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    public final <T extends AItemPrice<?, ?>> List<T> retrieveItemPriceLst(Map<String, Object> pReqVars, Long pLuv, Class<T> pItemPriceCl) throws Exception {
        List<T> result = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            String tblNm = pItemPriceCl.getSimpleName().toUpperCase();
            String verCond = pLuv != null ? " where " + tblNm + ".ITSVERSION>" + pLuv.toString() : "";
            result = this.getSrvOrm().retrieveListWithConditions(pReqVars, pItemPriceCl, verCond + " order by " + tblNm + ".ITSVERSION");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        return result;
    }

    public final <T extends AItemPrice<I, ?>, I extends IHasIdLongVersionName> void updateForItemPrice(Map<String, Object> pReqVars, T pItemPrice, EShopItemType pItemType) throws Exception {
        String whereStr = "where ITSTYPE=" + pItemType.ordinal() + " and ITEMID=" + pItemPrice.getItem().getItsId();
        ItemInList itemInList = this.getSrvOrm().retrieveEntityWithConditions(pReqVars, ItemInList.class, whereStr);
        if (itemInList == null) {
            itemInList = this.createItemInList(pReqVars, pItemPrice.getItem());
        }
        itemInList.setItsPrice(pItemPrice.getItsPrice());
        itemInList.setPreviousPrice(pItemPrice.getPreviousPrice());
        itemInList.setUnitOfMeasure(pItemPrice.getUnitOfMeasure());
        if (itemInList.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, itemInList);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, itemInList);
        }
    }

    public final <T extends AItemPrice<I, ?>, I extends IHasIdLongVersionName> void updateForItemPriceList(Map<String, Object> pReqVars, List<T> pItemPriceList, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv, EShopItemType pItemType) throws Exception {
        if (pItemPriceList.size() == 0) {
            return;
        }
        int steps = pItemPriceList.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(pItemPriceList.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    AItemPrice itemPrice = (AItemPrice)pItemPriceList.get(i);
                    this.updateForItemPrice(pReqVars, itemPrice, pItemType);
                    lastUpdatedVersion = itemPrice.getItsVersion();
                }
                if (pItemType == EShopItemType.GOODS) {
                    pGoodsInListLuv.setGoodsPriceLuv(lastUpdatedVersion);
                } else if (pItemType == EShopItemType.SERVICE) {
                    pGoodsInListLuv.setServicePriceLuv(lastUpdatedVersion);
                } else {
                    throw new Exception("NEI for " + (Object)((Object)pItemType));
                }
                this.getSrvOrm().updateEntity(pReqVars, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    public final <T extends AItemSpecifics<I, ?>, I extends IHasIdLongVersionName> List<T> retrieveItemSpecificsLst(Map<String, Object> pReqVars, Long pLuv, Class<T> pItemSpecClass) throws Exception {
        String verCond;
        List<T> result = null;
        if (pLuv != null) {
            String tblNm = pItemSpecClass.getSimpleName().toUpperCase();
            verCond = " where " + tblNm + ".ITEM in  (select distinct  ITEM from " + tblNm + " join SPECIFICSOFITEM on " + tblNm + ".SPECIFICS=SPECIFICSOFITEM.ITSID where " + tblNm + ".ITSVERSION>" + pLuv.toString() + ")";
        } else {
            verCond = "";
        }
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            pReqVars.put(pItemSpecClass.getSimpleName() + "specificsdeepLevel", 2);
            pReqVars.put("SpecificsOfItemtempHtmldeepLevel", 1);
            HashSet<String> goodsFldNms = new HashSet<String>();
            goodsFldNms.add("itsId");
            goodsFldNms.add("itsName");
            pReqVars.put("InvItemneededFields", goodsFldNms);
            HashSet<String> soiFldNms = new HashSet<String>();
            soiFldNms.add("itsId");
            soiFldNms.add("itsName");
            soiFldNms.add("isShowInList");
            soiFldNms.add("itsType");
            soiFldNms.add("itsGroop");
            soiFldNms.add("tempHtml");
            pReqVars.put("SpecificsOfItemneededFields", soiFldNms);
            HashSet<String> soigFldNms = new HashSet<String>();
            soigFldNms.add("itsId");
            soigFldNms.add("itsName");
            soigFldNms.add("templateStart");
            soigFldNms.add("templateEnd");
            soigFldNms.add("templateDetail");
            pReqVars.put("SpecificsOfItemGroupneededFields", soigFldNms);
            result = this.getSrvOrm().retrieveListWithConditions(pReqVars, pItemSpecClass, verCond + " order by ITEM.ITSID, SPECIFICS.ITSINDEX");
            pReqVars.remove(pItemSpecClass.getSimpleName() + "specificsdeepLevel");
            pReqVars.remove("SpecificsOfItemtempHtmldeepLevel");
            pReqVars.remove("InvItemneededFields");
            pReqVars.remove("SpecificsOfItemneededFields");
            pReqVars.remove("SpecificsOfItemGroupneededFields");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        ArrayList<IHasIdLongVersionName> itemsForSpecifics = new ArrayList<IHasIdLongVersionName>();
        HashSet<Long> htmlTemplatesIds = new HashSet<Long>();
        IHasIdLongVersionName currItem = null;
        for (AItemSpecifics gs : result) {
            if (gs.getSpecifics().getTempHtml() != null) {
                htmlTemplatesIds.add(gs.getSpecifics().getTempHtml().getItsId());
            }
            if (gs.getSpecifics().getItsGroop() != null) {
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateStart().getItsId());
                }
                if (gs.getSpecifics().getItsGroop().getTemplateEnd() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateEnd().getItsId());
                }
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateDetail().getItsId());
                }
            }
            if (currItem == null || !((Long)((IHasIdLongVersionName)gs.getItem()).getItsId()).equals(currItem.getItsId())) {
                currItem = (IHasIdLongVersionName)gs.getItem();
                currItem.setItsVersion(gs.getItsVersion());
                itemsForSpecifics.add(currItem);
                continue;
            }
            if (currItem.getItsVersion() >= gs.getItsVersion()) continue;
            currItem.setItsVersion(gs.getItsVersion());
        }
        CmprHasVersion cmp = new CmprHasVersion();
        Collections.sort(itemsForSpecifics, cmp);
        pReqVars.put("itemsForSpecifics", itemsForSpecifics);
        pReqVars.put("htmlTemplatesIds", htmlTemplatesIds);
        return result;
    }

    public final <T extends AItemSpecifics<?, ?>> void updateGoodsSpecificsInList(Map<String, Object> pReqVars, SettingsAdd pSettingsAdd, T pOutdGdSp, ItemInList pItemInList, SpecificsOfItemGroup pSpecificsOfItemGroupWas, List<I18nSpecificInList> pI18nSpecInListLst, List<I18nSpecificsOfItem> pI18nSpecLst, List<I18nChooseableSpecifics> pI18nChSpecLst, List<I18nUnitOfMeasure> pI18nUomLst) throws Exception {
        String val1 = "";
        String val2 = "";
        List langPreferences = (List)pReqVars.get("langPreferences");
        LangPreferences currLp = (LangPreferences)langPreferences.get(0);
        for (LangPreferences lp : langPreferences) {
            if (!lp.getIsDefault().booleanValue()) continue;
            currLp = lp;
            break;
        }
        if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.TEXT)) {
            val1 = pOutdGdSp.getStringValue1();
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.BIGDECIMAL)) {
            val1 = this.srvNumberToString.print(pOutdGdSp.getNumericValue1().toString(), currLp.getDecimalSep().getItsId(), currLp.getDecimalGroupSep().getItsId(), pOutdGdSp.getLongValue1().intValue(), currLp.getDigitsInGroup());
            if (pOutdGdSp.getStringValue1() != null) {
                val2 = pOutdGdSp.getStringValue1();
            }
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.INTEGER)) {
            val1 = pOutdGdSp.getLongValue1().toString();
            if (pOutdGdSp.getStringValue1() != null) {
                val2 = pOutdGdSp.getStringValue1();
            }
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.CHOOSEABLE_SPECIFICS)) {
            val1 = pOutdGdSp.getStringValue1();
        } else {
            return;
        }
        String templateDetail = pOutdGdSp.getSpecifics().getTempHtml() != null ? pOutdGdSp.getSpecifics().getTempHtml().getHtmlTemplate() : (pOutdGdSp.getSpecifics().getItsGroop() != null && pOutdGdSp.getSpecifics().getItsGroop().getTemplateDetail() != null ? pOutdGdSp.getSpecifics().getItsGroop().getTemplateDetail().getHtmlTemplate() : " <b>:SPECNM:</b> :VAL1:VAL2");
        String spdet = templateDetail.replace(":SPECNM", pOutdGdSp.getSpecifics().getItsName());
        spdet = spdet.replace(":VAL1", val1);
        spdet = spdet.replace(":VAL2", val2);
        if (pOutdGdSp.getSpecifics().getItsGroop() != null && pSpecificsOfItemGroupWas != null && pOutdGdSp.getSpecifics().getItsGroop().getItsId().equals(pSpecificsOfItemGroupWas.getItsId())) {
            pItemInList.setSpecificInList(pItemInList.getSpecificInList() + pSettingsAdd.getSpecSeparator() + spdet);
        } else {
            pItemInList.setSpecificInList(pItemInList.getSpecificInList() + spdet);
        }
        if (pI18nSpecInListLst != null) {
            for (I18nSpecificInList i18nspl : pI18nSpecInListLst) {
                for (LangPreferences lp : langPreferences) {
                    if (!lp.getLang().getItsId().equals(i18nspl.getLang().getItsId())) continue;
                    currLp = lp;
                    break;
                }
                if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.BIGDECIMAL)) {
                    val1 = this.srvNumberToString.print(pOutdGdSp.getNumericValue1().toString(), currLp.getDecimalSep().getItsId(), currLp.getDecimalGroupSep().getItsId(), pOutdGdSp.getLongValue1().intValue(), currLp.getDigitsInGroup());
                }
                if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.BIGDECIMAL) || pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.INTEGER) && pOutdGdSp.getLongValue2() != null) {
                    UnitOfMeasure uom = new UnitOfMeasure();
                    uom.setItsName(pOutdGdSp.getStringValue1());
                    uom.setItsId(pOutdGdSp.getLongValue2());
                    val2 = this.findUomName(pI18nUomLst, uom, i18nspl.getLang());
                } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.CHOOSEABLE_SPECIFICS)) {
                    ChooseableSpecifics sp = new ChooseableSpecifics();
                    sp.setItsName(pOutdGdSp.getStringValue1());
                    sp.setItsId(pOutdGdSp.getLongValue1());
                    val1 = this.findChSpecName(pI18nChSpecLst, sp, i18nspl.getLang());
                }
                spdet = templateDetail.replace(":SPECNM", this.findSpecName(pI18nSpecLst, pOutdGdSp.getSpecifics(), i18nspl.getLang()));
                spdet = spdet.replace(":VAL1", val1);
                spdet = spdet.replace(":VAL2", val2);
                if (pOutdGdSp.getSpecifics().getItsGroop() != null && pSpecificsOfItemGroupWas != null && pOutdGdSp.getSpecifics().getItsGroop().getItsId().equals(pSpecificsOfItemGroupWas.getItsId())) {
                    i18nspl.setSpecificInList(i18nspl.getSpecificInList() + pSettingsAdd.getSpecSeparator() + spdet);
                    continue;
                }
                i18nspl.setSpecificInList(i18nspl.getSpecificInList() + spdet);
            }
        }
    }

    public final <T extends AI18nName<?, ?>> List<T> retrieveI18nItem(Map<String, Object> pReqVars, Class<T> pI18nItemClass, String pItemIdsIn) throws Exception {
        pReqVars.put(pI18nItemClass.getSimpleName() + "hasNamedeepLevel", 1);
        pReqVars.put(pI18nItemClass.getSimpleName() + "langdeepLevel", 1);
        List<T> i18nItemLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, pI18nItemClass, "where HASNAME in " + pItemIdsIn);
        pReqVars.remove(pI18nItemClass.getSimpleName() + "hasNamedeepLevel");
        pReqVars.remove(pI18nItemClass.getSimpleName() + "langdeepLevel");
        return i18nItemLst;
    }

    /*
     * WARNING - void declaration
     */
    public final <I extends AI18nName<?, ?>, T extends AItemSpecifics<?, ?>> void updateForItemSpecificsList(Map<String, Object> pReqVars, List<T> pOutdGdSpList, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv, TradingSettings pTradingSettings, Class<I> pI18nItemClass, EShopItemType pItemType) throws Exception {
        if (pOutdGdSpList.size() == 0) {
            return;
        }
        List itemsForSpecifics = (List)pReqVars.get("itemsForSpecifics");
        pReqVars.remove("itemsForSpecifics");
        Set htmlTemplatesIds = (Set)pReqVars.get("htmlTemplatesIds");
        pReqVars.remove("htmlTemplatesIds");
        List<HtmlTemplate> htmlTemplates = null;
        List<ItemInList> itemsInList = null;
        List<I18nChooseableSpecifics> i18nChooseableSpecificsLst = null;
        List<I18nSpecificsOfItemGroup> i18nSpecificsOfItemGroupLst = null;
        List<I18nSpecificsOfItem> i18nSpecificsOfItemLst = null;
        List<I> i18nItemLst = null;
        List<I18nSpecificInList> i18nSpecificInListLst = null;
        List<I18nUnitOfMeasure> i18nUomLst = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            StringBuffer itemsIdsIn = new StringBuffer("(");
            boolean isFirst = true;
            for (Object it : itemsForSpecifics) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    itemsIdsIn.append(", ");
                }
                itemsIdsIn.append(((Long)it.getItsId()).toString());
            }
            itemsIdsIn.append(")");
            itemsInList = this.getSrvOrm().retrieveListWithConditions(pReqVars, ItemInList.class, "where ITSTYPE=" + pItemType.ordinal() + " and ITEMID in " + itemsIdsIn.toString());
            if (htmlTemplatesIds.size() > 0) {
                StringBuffer whereStr = new StringBuffer("where ITSID in (");
                isFirst = true;
                for (Long id : htmlTemplatesIds) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        whereStr.append(", ");
                    }
                    whereStr.append(id.toString());
                }
                whereStr.append(")");
                htmlTemplates = this.getSrvOrm().retrieveListWithConditions(pReqVars, HtmlTemplate.class, whereStr.toString());
            }
            if (pTradingSettings.getUseAdvancedI18n().booleanValue() && (i18nItemLst = this.retrieveI18nItem(pReqVars, pI18nItemClass, itemsIdsIn.toString())).size() > 0) {
                i18nSpecificInListLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, I18nSpecificInList.class, "where ITSTYPE=" + pItemType.ordinal() + " and ITEMID in " + itemsIdsIn.toString());
                StringBuffer specGrIdIn = null;
                StringBuffer specChIdIn = null;
                StringBuffer specIdIn = new StringBuffer("(");
                isFirst = true;
                boolean isFirstGr = true;
                boolean isFirstCh = true;
                for (AItemSpecifics gs : pOutdGdSpList) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        specIdIn.append(", ");
                    }
                    specIdIn.append(gs.getSpecifics().getItsId().toString());
                    if (gs.getSpecifics().getItsGroop() != null) {
                        if (isFirstGr) {
                            specGrIdIn = new StringBuffer("(");
                            isFirstGr = false;
                        } else {
                            specGrIdIn.append(", ");
                        }
                        specGrIdIn.append(gs.getSpecifics().getItsGroop().getItsId().toString());
                    }
                    if (!gs.getSpecifics().getItsType().equals((Object)ESpecificsItemType.CHOOSEABLE_SPECIFICS)) continue;
                    if (isFirstCh) {
                        specChIdIn = new StringBuffer("(");
                        isFirstCh = false;
                    } else {
                        specChIdIn.append(", ");
                    }
                    specChIdIn.append(gs.getLongValue1().toString());
                }
                specIdIn.append(")");
                if (specGrIdIn != null) {
                    specGrIdIn.append(")");
                }
                if (specChIdIn != null) {
                    specChIdIn.append(")");
                }
                pReqVars.put("I18nSpecificsOfItemhasNamedeepLevel", 1);
                pReqVars.put("I18nSpecificsOfItemlangdeepLevel", 1);
                i18nSpecificsOfItemLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, I18nSpecificsOfItem.class, "where HASNAME in " + specIdIn.toString());
                pReqVars.remove("I18nSpecificsOfItemhasNamedeepLevel");
                pReqVars.remove("I18nSpecificsOfItemlangdeepLevel");
                pReqVars.put("I18nUnitOfMeasurehasNamedeepLevel", 1);
                pReqVars.put("I18nUnitOfMeasurelangdeepLevel", 1);
                i18nUomLst = this.getSrvOrm().retrieveList(pReqVars, I18nUnitOfMeasure.class);
                pReqVars.remove("I18nUnitOfMeasurehasNamedeepLevel");
                pReqVars.remove("I18nUnitOfMeasurelangdeepLevel");
                if (specGrIdIn != null) {
                    pReqVars.put("I18nSpecificsOfItemGrouphasNamedeepLevel", 1);
                    pReqVars.put("I18nSpecificsOfItemGrouplangdeepLevel", 1);
                    i18nSpecificsOfItemGroupLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, I18nSpecificsOfItemGroup.class, "where HASNAME in " + specGrIdIn.toString());
                    pReqVars.remove("I18nSpecificsOfItemGrouphasNamedeepLevel");
                    pReqVars.remove("I18nSpecificsOfItemGrouplangdeepLevel");
                }
                if (specChIdIn != null) {
                    pReqVars.put("I18nChooseableSpecificshasNamedeepLevel", 1);
                    pReqVars.put("I18nChooseableSpecificslangdeepLevel", 1);
                    i18nChooseableSpecificsLst = this.getSrvOrm().retrieveListWithConditions(pReqVars, I18nChooseableSpecifics.class, "where HASNAME in " + specChIdIn.toString());
                    pReqVars.remove("I18nChooseableSpecificshasNamedeepLevel");
                    pReqVars.remove("I18nChooseableSpecificslangdeepLevel");
                }
            }
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        if (htmlTemplates != null && htmlTemplates.size() > 0) {
            for (AItemSpecifics gs : pOutdGdSpList) {
                if (gs.getSpecifics().getTempHtml() != null) {
                    gs.getSpecifics().setTempHtml(this.findTemplate(htmlTemplates, gs.getSpecifics().getTempHtml().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop() == null) continue;
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    gs.getSpecifics().getItsGroop().setTemplateStart(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateStart().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop().getTemplateEnd() != null) {
                    gs.getSpecifics().getItsGroop().setTemplateEnd(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateEnd().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop().getTemplateStart() == null) continue;
                gs.getSpecifics().getItsGroop().setTemplateDetail(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateDetail().getItsId()));
            }
        }
        int steps = itemsForSpecifics.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(itemsForSpecifics.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    IHasIdLongVersionName item = (IHasIdLongVersionName)itemsForSpecifics.get(i);
                    ItemInList itemInList = this.findItemInListFor(itemsInList, (Long)item.getItsId(), pItemType);
                    if (itemInList == null) {
                        itemInList = this.createItemInList(pReqVars, item);
                    }
                    int j = this.findFirstIdxFor(pOutdGdSpList, item);
                    AHasIdLong specificsOfItemGroupWas = null;
                    itemInList.setItsName(item.getItsName());
                    itemInList.setDetailsMethod(null);
                    itemInList.setImageUrl(null);
                    ArrayList<I18nSpecificInList> i18nSpInLsLstFg = null;
                    if (i18nItemLst != null) {
                        for (AI18nName aI18nName : i18nItemLst) {
                            void var30_54;
                            if (i18nSpInLsLstFg == null) {
                                i18nSpInLsLstFg = new ArrayList<I18nSpecificInList>();
                            }
                            if (!((Long)aI18nName.getHasName().getItsId()).equals(item.getItsId())) continue;
                            I18nSpecificInList i18nSpecificInList = this.findI18nSpecificInListFor(i18nSpecificInListLst, item, pItemType, aI18nName.getLang());
                            if (i18nSpecificInList == null) {
                                I18nSpecificInList i18nSpecificInList2 = new I18nSpecificInList();
                                i18nSpecificInList2.setIsNew(true);
                                i18nSpecificInList2.setItsType(pItemType);
                                i18nSpecificInList2.setItemId((Long)item.getItsId());
                                i18nSpecificInList2.setLang(aI18nName.getLang());
                            }
                            var30_54.setItsName(aI18nName.getItsName());
                            i18nSpInLsLstFg.add((I18nSpecificInList)var30_54);
                        }
                    }
                    if (pSettingsAdd.getSpecHtmlStart() != null) {
                        itemInList.setSpecificInList(pSettingsAdd.getSpecHtmlStart());
                        if (i18nSpInLsLstFg != null) {
                            for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                                i18nSpecificInList.setSpecificInList(pSettingsAdd.getSpecHtmlStart());
                            }
                        }
                    } else {
                        itemInList.setSpecificInList("");
                        if (i18nSpInLsLstFg != null) {
                            for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                                i18nSpecificInList.setSpecificInList("");
                            }
                        }
                    }
                    boolean wasGrStart = false;
                    do {
                        if (((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getIsShowInList().booleanValue()) {
                            if (((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) {
                                itemInList.setImageUrl(((AItemSpecifics)pOutdGdSpList.get(j)).getStringValue1());
                                continue;
                            }
                            if (((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop() == null || specificsOfItemGroupWas == null || !((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop().getItsId().equals(specificsOfItemGroupWas.getItsId())) {
                                if (wasGrStart) {
                                    if (pSettingsAdd.getSpecGrSeparator() != null && pSettingsAdd.getSpecGrHtmlEnd() != null) {
                                        itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlEnd() + pSettingsAdd.getSpecGrSeparator());
                                    } else if (pSettingsAdd.getSpecGrHtmlEnd() != null) {
                                        itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlEnd());
                                    } else if (pSettingsAdd.getSpecGrSeparator() != null) {
                                        itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecGrSeparator());
                                    }
                                }
                                wasGrStart = true;
                                if (pSettingsAdd.getSpecGrHtmlStart() != null) {
                                    itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlStart());
                                    if (i18nSpInLsLstFg != null) {
                                        for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                                            i18nSpecificInList.setSpecificInList(i18nSpecificInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlStart());
                                        }
                                    }
                                }
                                if (((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop() != null && ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop().getTemplateStart() != null) {
                                    String string = ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop().getTemplateStart().getHtmlTemplate().replace(":SPECGRNM", ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop().getItsName());
                                    itemInList.setSpecificInList(itemInList.getSpecificInList() + string);
                                    if (i18nSpInLsLstFg != null) {
                                        for (I18nSpecificInList i18nspInLs3 : i18nSpInLsLstFg) {
                                            String gn = this.findI18nSpecGrName(i18nSpecificsOfItemGroupLst, ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop(), i18nspInLs3.getLang());
                                            String string2 = ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop().getTemplateStart().getHtmlTemplate().replace(":SPECGRNM", gn);
                                            i18nspInLs3.setSpecificInList(i18nspInLs3.getSpecificInList() + string2);
                                        }
                                    }
                                }
                            }
                            this.updateGoodsSpecificsInList(pReqVars, pSettingsAdd, (AItemSpecifics)pOutdGdSpList.get(j), itemInList, (SpecificsOfItemGroup)specificsOfItemGroupWas, i18nSpInLsLstFg, i18nSpecificsOfItemLst, i18nChooseableSpecificsLst, i18nUomLst);
                            specificsOfItemGroupWas = ((AItemSpecifics)pOutdGdSpList.get(j)).getSpecifics().getItsGroop();
                            continue;
                        }
                        itemInList.setDetailsMethod(1);
                    } while (++j < pOutdGdSpList.size() && ((Long)((AItemSpecifics)pOutdGdSpList.get(j)).getItem().getItsId()).equals(item.getItsId()));
                    if (pSettingsAdd.getSpecGrHtmlEnd() != null) {
                        itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlEnd());
                        if (i18nSpInLsLstFg != null) {
                            for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                                i18nSpecificInList.setSpecificInList(i18nSpecificInList.getSpecificInList() + pSettingsAdd.getSpecGrHtmlEnd());
                            }
                        }
                    }
                    if (pSettingsAdd.getSpecHtmlEnd() != null) {
                        itemInList.setSpecificInList(itemInList.getSpecificInList() + pSettingsAdd.getSpecHtmlEnd());
                        if (i18nSpInLsLstFg != null) {
                            for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                                i18nSpecificInList.setSpecificInList(i18nSpecificInList.getSpecificInList() + pSettingsAdd.getSpecHtmlEnd());
                            }
                        }
                    }
                    if (itemInList.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, itemInList);
                    } else {
                        this.getSrvOrm().updateEntity(pReqVars, itemInList);
                    }
                    if (i18nSpInLsLstFg != null) {
                        for (I18nSpecificInList i18nSpecificInList : i18nSpInLsLstFg) {
                            if (i18nSpecificInList.getIsNew().booleanValue()) {
                                this.getSrvOrm().insertEntity(pReqVars, i18nSpecificInList);
                                continue;
                            }
                            this.getSrvOrm().updateEntity(pReqVars, i18nSpecificInList);
                        }
                    }
                    lastUpdatedVersion = item.getItsVersion();
                }
                if (pItemType.equals((Object)EShopItemType.GOODS)) {
                    pGoodsInListLuv.setGoodsSpecificLuv(lastUpdatedVersion);
                } else if (pItemType.equals((Object)EShopItemType.SERVICE)) {
                    pGoodsInListLuv.setServiceSpecificLuv(lastUpdatedVersion);
                } else {
                    throw new Exception("NYI for " + (Object)((Object)pItemType));
                }
                this.getSrvOrm().updateEntity(pReqVars, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    protected final String findI18nSpecGrName(List<I18nSpecificsOfItemGroup> pSpecificsOfItemGroupLst, SpecificsOfItemGroup pSpecGr, Languages pLang) {
        if (pSpecificsOfItemGroupLst != null) {
            for (I18nSpecificsOfItemGroup i18nspg : pSpecificsOfItemGroupLst) {
                if (!i18nspg.getHasName().getItsId().equals(pSpecGr.getItsId()) || !i18nspg.getLang().getItsId().equals(pLang.getItsId())) continue;
                return i18nspg.getItsName();
            }
        }
        return pSpecGr.getItsName();
    }

    protected final String findUomName(List<I18nUnitOfMeasure> pI18nUomLst, UnitOfMeasure pUom, Languages pLang) {
        for (I18nUnitOfMeasure i18uom : pI18nUomLst) {
            if (!i18uom.getHasName().getItsId().equals(pUom.getItsId()) || !i18uom.getLang().getItsId().equals(pLang.getItsId())) continue;
            return i18uom.getItsName();
        }
        return pUom.getItsName();
    }

    protected final String findChSpecName(List<I18nChooseableSpecifics> pSpecificsOfItemLst, ChooseableSpecifics pSpec, Languages pLang) {
        if (pSpecificsOfItemLst != null) {
            for (I18nChooseableSpecifics i18nsp : pSpecificsOfItemLst) {
                if (!i18nsp.getHasName().getItsId().equals(pSpec.getItsId()) || !i18nsp.getLang().getItsId().equals(pLang.getItsId())) continue;
                return i18nsp.getItsName();
            }
        }
        return pSpec.getItsName();
    }

    protected final String findSpecName(List<I18nSpecificsOfItem> pSpecificsOfItemLst, SpecificsOfItem pSpec, Languages pLang) {
        for (I18nSpecificsOfItem i18nsp : pSpecificsOfItemLst) {
            if (!i18nsp.getHasName().getItsId().equals(pSpec.getItsId()) || !i18nsp.getLang().getItsId().equals(pLang.getItsId())) continue;
            return i18nsp.getItsName();
        }
        return pSpec.getItsName();
    }

    protected final I18nSpecificInList findI18nSpecificInListFor(List<I18nSpecificInList> pSpecificInListLst, IHasIdLongVersionName pItem, EShopItemType pItemType, Languages pLang) {
        for (int j = 0; j < pSpecificInListLst.size(); ++j) {
            if (!pSpecificInListLst.get(j).getItemId().equals(pItem.getItsId()) || !pSpecificInListLst.get(j).getItsType().equals((Object)pItemType) || !pSpecificInListLst.get(j).getLang().getItsId().equals(pLang.getItsId())) continue;
            return pSpecificInListLst.get(j);
        }
        return null;
    }

    protected final ItemInList findItemInListFor(List<ItemInList> pItemsList, Long pItemId, EShopItemType pItemType) {
        for (int j = 0; j < pItemsList.size(); ++j) {
            if (!pItemsList.get(j).getItsType().equals((Object)pItemType) || !pItemsList.get(j).getItemId().equals(pItemId)) continue;
            return pItemsList.get(j);
        }
        return null;
    }

    protected final <T extends AItemSpecifics<?, ?>> int findFirstIdxFor(List<T> pOutdGdSpList, IHasIdLongVersionName pItem) {
        int j = 0;
        while (!((Long)((AItemSpecifics)pOutdGdSpList.get(j)).getItem().getItsId()).equals(pItem.getItsId())) {
            ++j;
        }
        return j;
    }

    protected final HtmlTemplate findTemplate(List<HtmlTemplate> pHtmlTemplates, Long pId) throws Exception {
        for (HtmlTemplate tmpl : pHtmlTemplates) {
            if (!tmpl.getItsId().equals(pId)) continue;
            return tmpl;
        }
        throw new Exception("Algorithm error/or template deleted: template not found for ID" + pId);
    }

    protected final <I extends IHasIdLongVersionName> ItemInList createItemInList(Map<String, Object> pReqVars, I pItem) throws Exception {
        EShopItemType itemType;
        ItemInList itemInList = new ItemInList();
        itemInList.setIsNew(true);
        if (pItem.getClass() == InvItem.class) {
            itemType = EShopItemType.GOODS;
        } else if (pItem.getClass() == ServiceToSale.class) {
            itemType = EShopItemType.SERVICE;
        } else {
            throw new Exception("NYI for " + pItem.getClass());
        }
        itemInList.setItsType(itemType);
        itemInList.setItemId((Long)pItem.getItsId());
        itemInList.setItsName(pItem.getItsName());
        itemInList.setAvailableQuantity(BigDecimal.ZERO);
        return itemInList;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

