/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.handler.IHandlerRequestDch;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.I18nCatalogGs;
import org.beigesoft.webstore.persistable.I18nWebStore;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvSettingsAdd;
import org.beigesoft.webstore.service.ISrvTradingSettings;
import org.beigesoft.webstore.service.UtlTradeJsp;

public class HndlTradeVarsRequest<RS>
implements IHandlerRequestDch {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvTradingSettings srvTradingSettings;
    private ISrvSettingsAdd srvSettingsAdd;
    private UtlTradeJsp utlTradeJsp;
    private List<I18nWebStore> i18nWebStoreList;
    private List<I18nCatalogGs> i18nCatalogs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        TradingSettings ts = this.srvTradingSettings.lazyGetTradingSettings(pReqVars);
        pReqVars.put("tradingSettings", ts);
        pReqVars.put("settingsAdd", this.srvSettingsAdd.lazyGetSettingsAdd(pReqVars));
        pRequestData.setAttribute("utlTradeJsp", this.utlTradeJsp);
        if (ts.getUseAdvancedI18n().booleanValue()) {
            String lang = (String)pReqVars.get("lang");
            String langDef = (String)pReqVars.get("langDef");
            if (lang != null && langDef != null && !lang.equals(langDef)) {
                List<I18nCatalogGs> i18nCtTmp;
                List<I18nWebStore> i18nTrTmp;
                HndlTradeVarsRequest hndlTradeVarsRequest = this;
                synchronized (hndlTradeVarsRequest) {
                    if (this.i18nWebStoreList == null) {
                        try {
                            this.logger.info(null, HndlTradeVarsRequest.class, "Refreshing I18N data...");
                            this.srvDatabase.setIsAutocommit(false);
                            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                            this.srvDatabase.beginTransaction();
                            List<I18nWebStore> i18ntr = this.srvOrm.retrieveList(pReqVars, I18nWebStore.class);
                            List<I18nCatalogGs> i18nct = this.srvOrm.retrieveList(pReqVars, I18nCatalogGs.class);
                            this.srvDatabase.commitTransaction();
                            this.i18nWebStoreList = i18ntr;
                            this.i18nCatalogs = i18nct;
                        }
                        catch (Exception ex) {
                            if (!this.srvDatabase.getIsAutocommit()) {
                                this.srvDatabase.rollBackTransaction();
                            }
                            throw ex;
                        }
                        finally {
                            this.srvDatabase.releaseResources();
                        }
                    }
                    i18nTrTmp = this.i18nWebStoreList;
                    i18nCtTmp = this.i18nCatalogs;
                }
                pReqVars.put("i18nCatalogs", i18nCtTmp);
                pReqVars.put("i18nWebStoreList", i18nTrTmp);
            }
        }
    }

    @Override
    public final synchronized void handleDataChanged() throws Exception {
        this.i18nWebStoreList = null;
        this.i18nCatalogs = null;
        this.logger.info(null, HndlTradeVarsRequest.class, "I18N changes are handled.");
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }

    public final UtlTradeJsp getUtlTradeJsp() {
        return this.utlTradeJsp;
    }

    public final void setUtlTradeJsp(UtlTradeJsp pUtlTradeJsp) {
        this.utlTradeJsp = pUtlTradeJsp;
    }

    public final ISrvSettingsAdd getSrvSettingsAdd() {
        return this.srvSettingsAdd;
    }

    public final void setSrvSettingsAdd(ISrvSettingsAdd pSrvSettingsAdd) {
        this.srvSettingsAdd = pSrvSettingsAdd;
    }
}

