/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.TaxCategoryWr;
import org.beigesoft.accounting.model.TaxWr;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.comparator.CmprHasIdLong;
import org.beigesoft.model.Node;
import org.beigesoft.service.ICsvDataRetriever;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.ServicePrice;

public class ServicePriceListRetriever<RS>
implements ICsvDataRetriever {
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    @Override
    public final List<List<Object>> retrieveData(Map<String, Object> pReqVars) throws Exception {
        AccSettings as = this.srvAccSettings.lazyGetAccSettings(pReqVars);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        Long priceCategoryId = (Long)pReqVars.get("priceCategoryId");
        BigDecimal unavailablePrice = null;
        if (pReqVars.get("unavailablePrice") != null) {
            unavailablePrice = (BigDecimal)pReqVars.get("unavailablePrice");
        }
        HashSet<String> ndFlPg = new HashSet<String>();
        ndFlPg.add("service");
        ndFlPg.add("itsPrice");
        HashSet<String> ndFlIdNm = new HashSet<String>();
        ndFlIdNm.add("itsId");
        ndFlIdNm.add("itsName");
        pReqVars.put("ServicePriceitemdeepLevel", 3);
        pReqVars.put("ServicePriceneededFields", ndFlPg);
        pReqVars.put("ServiceToSaleCategoryneededFields", ndFlIdNm);
        List<ServicePrice> psl = this.getSrvOrm().retrieveListWithConditions(pReqVars, ServicePrice.class, "where PRICECATEGORY=" + priceCategoryId);
        pReqVars.remove("ServicePriceitemdeepLevel");
        pReqVars.remove("ServicePriceneededFields");
        pReqVars.remove("ServiceToSaleCategoryneededFields");
        pReqVars.remove("UnitOfMeasureneededFields");
        ndFlIdNm.add("itsPercentage");
        pReqVars.put("TaxneededFields", ndFlIdNm);
        List<InvItemTaxCategoryLine> allTaxCatsLns = this.getSrvOrm().retrieveList(pReqVars, InvItemTaxCategoryLine.class);
        pReqVars.remove("TaxneededFields");
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<InvItemTaxCategory> usedTaxCats = new ArrayList<InvItemTaxCategory>();
        for (InvItemTaxCategoryLine invItemTaxCategoryLine : allTaxCatsLns) {
            boolean txListed = false;
            for (Tax tax : usedTaxes) {
                if (!tax.getItsId().equals(invItemTaxCategoryLine.getTax().getItsId())) continue;
                txListed = true;
                break;
            }
            if (!txListed) {
                usedTaxes.add(invItemTaxCategoryLine.getTax());
                invItemTaxCategoryLine.getTax().setItsPercentage(invItemTaxCategoryLine.getItsPercentage());
            }
            int tci = -1;
            for (InvItemTaxCategory tc : usedTaxCats) {
                if (!tc.getItsId().equals(invItemTaxCategoryLine.getItsOwner().getItsId())) continue;
                tci = usedTaxCats.indexOf(tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(invItemTaxCategoryLine.getItsOwner());
                invItemTaxCategoryLine.getItsOwner().setTaxes(new ArrayList<InvItemTaxCategoryLine>());
                invItemTaxCategoryLine.getItsOwner().getTaxes().add(invItemTaxCategoryLine);
                continue;
            }
            ((InvItemTaxCategory)usedTaxCats.get(tci)).getTaxes().add(invItemTaxCategoryLine);
        }
        Collections.sort(usedTaxes, new CmprHasIdLong());
        Collections.sort(usedTaxCats, new CmprHasIdLong());
        boolean isOnlyTax = true;
        for (InvItemTaxCategory txc : usedTaxCats) {
            if (txc.getTaxes().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        BigDecimal bigDecimal = new BigDecimal("1.2");
        BigDecimal bd100 = new BigDecimal("100");
        for (ServicePrice servicePrice : psl) {
            Boolean isAvailable;
            BigDecimal quantity;
            ArrayList<Object> row = new ArrayList<Object>();
            result.add(row);
            row.add(servicePrice.getItem());
            row.add(servicePrice.getItsPrice());
            row.add(servicePrice.getItsPrice().divide(bigDecimal, 2, RoundingMode.HALF_UP));
            if (unavailablePrice != null && servicePrice.getItsPrice().compareTo(unavailablePrice) == 0) {
                quantity = BigDecimal.ZERO;
                isAvailable = Boolean.FALSE;
            } else {
                quantity = BigDecimal.ONE;
                isAvailable = Boolean.TRUE;
            }
            row.add(quantity);
            row.add(isAvailable);
            if (servicePrice.getItem().getTaxCategory() != null) {
                for (InvItemTaxCategory txc : usedTaxCats) {
                    if (!txc.getItsId().equals(servicePrice.getItem().getTaxCategory().getItsId())) continue;
                    servicePrice.getItem().setTaxCategory(txc);
                    break;
                }
            }
            if (isOnlyTax) {
                TaxWr onlyTax = new TaxWr();
                if (servicePrice.getItem().getTaxCategory() != null) {
                    onlyTax.setTax(servicePrice.getItem().getTaxCategory().getTaxes().get(0).getTax());
                    onlyTax.setIsUsed(true);
                    onlyTax.setRate(onlyTax.getTax().getItsPercentage().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                }
                row.add(onlyTax);
                continue;
            }
            TaxCategoryWr taxCat = new TaxCategoryWr();
            if (servicePrice.getItem().getTaxCategory() != null) {
                taxCat.setTaxCategory(servicePrice.getItem().getTaxCategory());
                taxCat.setIsUsed(true);
                for (InvItemTaxCategoryLine tl : taxCat.getTaxCategory().getTaxes()) {
                    taxCat.setAggrPercent(taxCat.getAggrPercent().add(tl.getItsPercentage()));
                }
                taxCat.setAggrRate(taxCat.getAggrPercent().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
            }
            row.add(taxCat);
            for (Tax tx : usedTaxes) {
                TaxWr txWr = new TaxWr();
                if (servicePrice.getItem().getTaxCategory() != null) {
                    for (InvItemTaxCategoryLine tl : servicePrice.getItem().getTaxCategory().getTaxes()) {
                        if (!tl.getTax().getItsId().equals(tx.getItsId())) continue;
                        txWr.setTax(tl.getTax());
                        txWr.setIsUsed(true);
                        txWr.setRate(txWr.getTax().getItsPercentage().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                        break;
                    }
                }
                row.add(txWr);
            }
            for (InvItemTaxCategory txc : usedTaxCats) {
                TaxCategoryWr txCtWr = new TaxCategoryWr();
                if (servicePrice.getItem().getTaxCategory() != null && txc.getItsId().equals(servicePrice.getItem().getTaxCategory().getItsId())) {
                    txCtWr.setTaxCategory(txc);
                    txCtWr.setIsUsed(true);
                    for (InvItemTaxCategoryLine tl : txCtWr.getTaxCategory().getTaxes()) {
                        txCtWr.setAggrPercent(txCtWr.getAggrPercent().add(tl.getItsPercentage()));
                    }
                    txCtWr.setAggrRate(txCtWr.getAggrPercent().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                }
                row.add(txCtWr);
            }
        }
        return result;
    }

    @Override
    public final List<Node<String>> getSampleDataRow(Map<String, Object> pReqVars) throws Exception {
        Iterator iterator;
        String lang = (String)pReqVars.get("lang");
        ArrayList<Node<String>> result = new ArrayList<Node<String>>();
        Integer idx = 1;
        Node nodeService = new Node();
        result.add(nodeService);
        nodeService.setItsName(this.getSrvI18n().getMsg("service", lang));
        nodeService.setItsNodes(new ArrayList());
        Node<String> nodeServiceName = new Node<String>();
        nodeService.getItsNodes().add(nodeServiceName);
        nodeServiceName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeServiceName.setItsValue(idx.toString() + ";itsName");
        Node<String> nodeServiceId = new Node<String>();
        nodeService.getItsNodes().add(nodeServiceId);
        nodeServiceId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeServiceId.setItsValue(idx.toString() + ";itsId");
        Node nodeServiceItsCategory = new Node();
        nodeService.getItsNodes().add(nodeServiceItsCategory);
        nodeServiceItsCategory.setItsName(this.getSrvI18n().getMsg("itsCategory", lang));
        nodeServiceItsCategory.setItsNodes(new ArrayList());
        Node<String> nodeServiceItsCategoryName = new Node<String>();
        nodeServiceItsCategory.getItsNodes().add(nodeServiceItsCategoryName);
        nodeServiceItsCategoryName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeServiceItsCategoryName.setItsValue(idx.toString() + ";itsCategory,itsName");
        Node<String> nodeServiceItsCategoryId = new Node<String>();
        nodeServiceItsCategory.getItsNodes().add(nodeServiceItsCategoryId);
        nodeServiceItsCategoryId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeServiceItsCategoryId.setItsValue(idx.toString() + ";itsCategory,itsId");
        Integer n = idx;
        Integer n2 = idx = Integer.valueOf(idx + 1);
        Node<String> nodePrice = new Node<String>();
        result.add(nodePrice);
        nodePrice.setItsName(this.getSrvI18n().getMsg("itsPrice", lang));
        nodePrice.setItsValue(idx.toString());
        n2 = idx;
        Integer n3 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeCost = new Node<String>();
        result.add(nodeCost);
        nodeCost.setItsName(this.getSrvI18n().getMsg("itsCost", lang));
        nodeCost.setItsValue(idx.toString());
        n3 = idx;
        Integer n4 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeQuantity = new Node<String>();
        result.add(nodeQuantity);
        nodeQuantity.setItsName(this.getSrvI18n().getMsg("itsQuantity", lang));
        nodeQuantity.setItsValue(idx.toString());
        n4 = idx;
        Integer n5 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeIsAvailable = new Node<String>();
        result.add(nodeIsAvailable);
        nodeIsAvailable.setItsName(this.getSrvI18n().getMsg("isAvailable", lang));
        nodeIsAvailable.setItsValue(idx.toString());
        HashSet<String> ndFlIdNm = new HashSet<String>();
        ndFlIdNm.add("itsId");
        ndFlIdNm.add("itsName");
        pReqVars.put("InvItemTaxCategoryneededFields", ndFlIdNm);
        pReqVars.put("TaxneededFields", ndFlIdNm);
        List<InvItemTaxCategoryLine> allTaxCatsLns = this.getSrvOrm().retrieveList(pReqVars, InvItemTaxCategoryLine.class);
        pReqVars.remove("InvItemTaxCategoryneededFields");
        pReqVars.remove("TaxneededFields");
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<InvItemTaxCategory> usedTaxCats = new ArrayList<InvItemTaxCategory>();
        for (InvItemTaxCategoryLine tcl : allTaxCatsLns) {
            boolean bl = false;
            for (Tax tx : usedTaxes) {
                if (!tx.getItsId().equals(tcl.getTax().getItsId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                usedTaxes.add(tcl.getTax());
            }
            int tci = -1;
            for (InvItemTaxCategory tc : usedTaxCats) {
                if (!tc.getItsId().equals(tcl.getItsOwner().getItsId())) continue;
                tci = usedTaxCats.indexOf(tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(tcl.getItsOwner());
                tcl.getItsOwner().setTaxes(new ArrayList<InvItemTaxCategoryLine>());
                tcl.getItsOwner().getTaxes().add(tcl);
                continue;
            }
            ((InvItemTaxCategory)usedTaxCats.get(tci)).getTaxes().add(tcl);
        }
        boolean isOnlyTax = true;
        for (InvItemTaxCategory invItemTaxCategory : usedTaxCats) {
            if (invItemTaxCategory.getTaxes().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        if (isOnlyTax) {
            iterator = idx;
            Integer n6 = idx = Integer.valueOf(idx + 1);
            this.addTaxWr(result, idx.toString(), this.getSrvI18n().getMsg("OnlyTax", lang), lang);
        } else {
            Object object;
            iterator = idx;
            Integer n7 = idx = Integer.valueOf(idx + 1);
            this.addTaxCatWr(result, idx.toString(), this.getSrvI18n().getMsg("taxCategory", lang), lang);
            Collections.sort(usedTaxes, new CmprHasIdLong());
            for (Tax tax : usedTaxes) {
                Integer n8 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxWr(result, idx.toString(), tax.getItsName(), lang);
            }
            Collections.sort(usedTaxCats, new CmprHasIdLong());
            for (InvItemTaxCategory invItemTaxCategory : usedTaxCats) {
                Integer n9 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxCatWr(result, idx.toString(), invItemTaxCategory.getItsName(), lang);
            }
        }
        return result;
    }

    public final void addTaxWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxWr = new Node();
        pTree.add(nodeTaxWr);
        nodeTaxWr.setItsName(pName);
        nodeTaxWr.setItsNodes(new ArrayList());
        Node<String> nodeTaxWrIsUsed = new Node<String>();
        nodeTaxWr.getItsNodes().add(nodeTaxWrIsUsed);
        nodeTaxWrIsUsed.setItsName(this.getSrvI18n().getMsg("isUsed", pLang));
        nodeTaxWrIsUsed.setItsValue(pIndex + ";isUsed");
        Node<String> nodeTaxWrRate = new Node<String>();
        nodeTaxWr.getItsNodes().add(nodeTaxWrRate);
        nodeTaxWrRate.setItsName(this.getSrvI18n().getMsg("rate", pLang));
        nodeTaxWrRate.setItsValue(pIndex + ";rate");
        Node nodeTaxWrTax = new Node();
        nodeTaxWr.getItsNodes().add(nodeTaxWrTax);
        nodeTaxWrTax.setItsName(this.getSrvI18n().getMsg("tax", pLang));
        nodeTaxWrTax.setItsNodes(new ArrayList());
        Node<String> nodeTaxWrTaxName = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxName);
        nodeTaxWrTaxName.setItsName(this.getSrvI18n().getMsg("itsName", pLang));
        nodeTaxWrTaxName.setItsValue(pIndex + ";tax,itsName");
        Node<String> nodeTaxWrTaxId = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxId);
        nodeTaxWrTaxId.setItsName(this.getSrvI18n().getMsg("itsId", pLang));
        nodeTaxWrTaxId.setItsValue(pIndex + ";tax,itsId");
        Node<String> nodeTaxWrTaxPercentage = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxPercentage);
        nodeTaxWrTaxPercentage.setItsName(this.getSrvI18n().getMsg("itsPercentage", pLang));
        nodeTaxWrTaxPercentage.setItsValue(pIndex + ";tax,itsPercentage");
    }

    public final void addTaxCatWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxCatWr = new Node();
        pTree.add(nodeTaxCatWr);
        nodeTaxCatWr.setItsName(pName);
        nodeTaxCatWr.setItsNodes(new ArrayList());
        Node<String> nodeTaxCatWrIsUsed = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrIsUsed);
        nodeTaxCatWrIsUsed.setItsName(this.getSrvI18n().getMsg("isUsed", pLang));
        nodeTaxCatWrIsUsed.setItsValue(pIndex + ";isUsed");
        Node<String> nodeTaxCatWrPercent = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrPercent);
        nodeTaxCatWrPercent.setItsName(this.getSrvI18n().getMsg("aggrPercent", pLang));
        nodeTaxCatWrPercent.setItsValue(pIndex + ";aggrPercent");
        Node<String> nodeTaxCatWrRate = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrRate);
        nodeTaxCatWrRate.setItsName(this.getSrvI18n().getMsg("aggrRate", pLang));
        nodeTaxCatWrRate.setItsValue(pIndex + ";aggrRate");
        Node nodeTaxCatWrTaxCat = new Node();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrTaxCat);
        nodeTaxCatWrTaxCat.setItsName(this.getSrvI18n().getMsg("taxCategory", pLang));
        nodeTaxCatWrTaxCat.setItsNodes(new ArrayList());
        Node<String> nodeTaxCatWrTaxCatName = new Node<String>();
        nodeTaxCatWrTaxCat.getItsNodes().add(nodeTaxCatWrTaxCatName);
        nodeTaxCatWrTaxCatName.setItsName(this.getSrvI18n().getMsg("itsName", pLang));
        nodeTaxCatWrTaxCatName.setItsValue(pIndex + ";taxCategory,itsName");
        Node<String> nodeTaxCatWrTaxCatId = new Node<String>();
        nodeTaxCatWrTaxCat.getItsNodes().add(nodeTaxCatWrTaxCatId);
        nodeTaxCatWrTaxCatId.setItsName(this.getSrvI18n().getMsg("itsId", pLang));
        nodeTaxCatWrTaxCatId.setItsValue(pIndex + ";taxCategory,itsId");
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

