/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.CartItem;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.ShoppingCart;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvShoppingCart;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class SrvShoppingCart<RS>
implements ISrvShoppingCart {
    private ISrvOrm<RS> srvOrm;
    private ISrvTradingSettings srvTradingSettings;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final ShoppingCart getShoppingCart(Map<String, Object> pAddParam, IRequestData pRequestData, boolean pIsNeedToCreate) throws Exception {
        ShoppingCart shoppingCart;
        OnlineBuyer onlineBuyer;
        Long buyerId = null;
        String buyerIdStr = pRequestData.getCookieValue("cBuyerId");
        if (buyerIdStr != null && buyerIdStr.length() > 0) {
            buyerId = Long.valueOf(buyerIdStr);
        }
        if (buyerId == null) {
            TradingSettings tradingSettings = this.srvTradingSettings.lazyGetTradingSettings(pAddParam);
            if (!pIsNeedToCreate && !tradingSettings.getIsCreateOnlineUserOnFirstVisit().booleanValue()) return null;
            onlineBuyer = this.createOnlineBuyer(pAddParam, pRequestData);
            pRequestData.setCookieValue("cBuyerId", onlineBuyer.getItsId().toString());
        } else {
            onlineBuyer = this.getSrvOrm().retrieveEntityById(pAddParam, OnlineBuyer.class, buyerId);
            if (onlineBuyer == null) {
                onlineBuyer = this.createOnlineBuyer(pAddParam, pRequestData);
                pRequestData.setCookieValue("cBuyerId", onlineBuyer.getItsId().toString());
            }
        }
        if ((shoppingCart = this.getSrvOrm().retrieveEntityById(pAddParam, ShoppingCart.class, onlineBuyer)) != null) {
            CartItem ci = new CartItem();
            ci.setItsOwner(shoppingCart);
            List<CartItem> cartItems = this.getSrvOrm().retrieveListForField(pAddParam, ci, "itsOwner");
            shoppingCart.setItsItems(cartItems);
            return shoppingCart;
        } else {
            if (!pIsNeedToCreate) return shoppingCart;
            shoppingCart = new ShoppingCart();
            shoppingCart.setItsId(onlineBuyer);
            shoppingCart.setBuyer(onlineBuyer);
            shoppingCart.setItsTotal(BigDecimal.ZERO);
            shoppingCart.setTotalItems(0);
            this.getSrvOrm().insertEntity(pAddParam, shoppingCart);
        }
        return shoppingCart;
    }

    public final OnlineBuyer createOnlineBuyer(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        OnlineBuyer onlineBuyer = new OnlineBuyer();
        onlineBuyer.setIsNew(true);
        onlineBuyer.setItsName("newbe" + new Date());
        this.getSrvOrm().insertEntity(pAddParam, onlineBuyer);
        return onlineBuyer;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }
}

