/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class SrvTradingSettings<RS>
implements ISrvTradingSettings {
    private TradingSettings tradingSettings;
    private ISrvOrm<RS> srvOrm;

    public SrvTradingSettings() {
    }

    public SrvTradingSettings(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    @Override
    public final synchronized TradingSettings lazyGetTradingSettings(Map<String, Object> pAddParam) throws Exception {
        if (this.tradingSettings == null) {
            this.tradingSettings = this.getSrvOrm().retrieveEntityById(pAddParam, TradingSettings.class, 1L);
            if (this.tradingSettings == null) {
                throw new ExceptionWithCode(1002, "There is no trading settings!!!");
            }
        }
        return this.tradingSettings;
    }

    @Override
    public final synchronized void clearTradingSettings(Map<String, Object> pAddParam) {
        this.tradingSettings = null;
    }

    @Override
    public final synchronized void saveTradingSettings(Map<String, Object> pAddParam, TradingSettings pEntity) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            throw new ExceptionWithCode(403, "insert_not_allowed::" + pAddParam.get("user"));
        }
        if (pEntity.getItsId() != 1L) {
            throw new ExceptionWithCode(403, "id_not_allowed::" + pAddParam.get("user"));
        }
        this.getSrvOrm().updateEntity(pAddParam, pEntity);
        this.tradingSettings = null;
        this.lazyGetTradingSettings(pAddParam);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

