/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.beigesoft.log.ILogger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class BeigeLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -1227274521526687937L;
    private ILogger logger;

    BeigeLoggerAdapter(String tag) {
        this.name = tag;
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public void trace(String msg) {
        if (this.logger.getIsShowDebugMessages()) {
            this.logger.debug(null, this.getClass(), msg);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg});
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg1, arg2});
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... argArray) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.getIsShowDebugMessages()) {
            this.logger.debug(null, this.getClass(), msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.getIsShowDebugMessages();
    }

    @Override
    public void debug(String msg) {
        if (this.logger.getIsShowDebugMessages()) {
            this.logger.debug(null, this.getClass(), msg);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg});
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg1, arg2});
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... argArray) {
        if (this.logger.getIsShowDebugMessages()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.debug(null, this.getClass(), ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.getIsShowDebugMessages()) {
            this.logger.debug(null, this.getClass(), msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.logger.info(null, this.getClass(), msg);
    }

    @Override
    public void info(String format, Object arg) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg});
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg1, arg2});
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void info(String format, Object ... argArray) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.warn(null, this.getClass(), msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(null, this.getClass(), msg);
    }

    @Override
    public void warn(String format, Object arg) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg});
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg1, arg2});
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void warn(String format, Object ... argArray) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
        this.logger.warn(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.warn(null, this.getClass(), msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String msg) {
        this.logger.error(null, this.getClass(), msg);
    }

    @Override
    public void error(String format, Object arg) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg});
        this.logger.error(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, new Object[]{arg1, arg2});
        this.logger.error(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void error(String format, Object ... argArray) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
        this.logger.error(null, this.getClass(), ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.error(null, this.getClass(), msg, t);
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

