/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import ajava.beans.IntrospectionException;
import ajava.beans.Introspector;
import ajava.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;

public abstract class SetSupport
extends BodyTagSupport {
    private String var;
    private String scope;

    protected SetSupport() {
    }

    @Override
    public void release() {
        this.var = null;
        this.scope = null;
        super.release();
    }

    @Override
    public int doEndTag() throws JspException {
        if (this.var != null) {
            this.exportToVariable(this.getResult());
        } else {
            Object target = this.evalTarget();
            if (target == null) {
                throw new JspTagException(Resources.getMessage("SET_INVALID_TARGET"));
            }
            String property = this.evalProperty();
            if (target instanceof Map) {
                this.exportToMapProperty(target, property, this.getResult());
            } else {
                this.exportToBeanProperty(target, property, this.getResult());
            }
        }
        return 6;
    }

    Object getResult() throws JspException {
        if (this.isValueSpecified()) {
            return this.evalValue();
        }
        if (this.bodyContent == null) {
            return "";
        }
        String content = this.bodyContent.getString();
        if (content == null) {
            return "";
        }
        return content.trim();
    }

    protected abstract boolean isValueSpecified();

    protected abstract Object evalValue() throws JspException;

    protected abstract Object evalTarget() throws JspException;

    protected abstract String evalProperty() throws JspException;

    void exportToVariable(Object result) throws JspTagException {
        int scopeValue = Util.getScope(this.scope);
        ELContext myELContext = this.pageContext.getELContext();
        VariableMapper vm = myELContext.getVariableMapper();
        if (result != null) {
            if (result instanceof ValueExpression) {
                if (scopeValue != 1) {
                    throw new JspTagException(Resources.getMessage("SET_BAD_DEFERRED_SCOPE", this.scope));
                }
                vm.setVariable(this.var, (ValueExpression)result);
            } else {
                if (scopeValue == 1 && vm.resolveVariable(this.var) != null) {
                    vm.setVariable(this.var, null);
                }
                this.pageContext.setAttribute(this.var, result, scopeValue);
            }
        } else {
            if (vm.resolveVariable(this.var) != null) {
                vm.setVariable(this.var, null);
            }
            if (this.scope != null) {
                this.pageContext.removeAttribute(this.var, Util.getScope(this.scope));
            } else {
                this.pageContext.removeAttribute(this.var);
            }
        }
    }

    void exportToMapProperty(Object target, String property, Object result) {
        Map map = (Map)target;
        if (result == null) {
            map.remove(property);
        } else {
            map.put(property, result);
        }
    }

    void exportToBeanProperty(Object target, String property, Object result) throws JspTagException {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(target.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            throw new JspTagException(ex);
        }
        for (PropertyDescriptor pd : descriptors) {
            if (!pd.getName().equals(property)) continue;
            Method m = pd.getWriteMethod();
            if (m == null) {
                throw new JspTagException(Resources.getMessage("SET_NO_SETTER_METHOD", property));
            }
            try {
                m.invoke(target, this.convertToExpectedType(result, m));
            }
            catch (ELException ex) {
                throw new JspTagException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new JspTagException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new JspTagException(ex);
            }
            return;
        }
        throw new JspTagException(Resources.getMessage("SET_INVALID_PROPERTY", property));
    }

    private Object convertToExpectedType(Object value, Method m) throws ELException {
        if (value == null) {
            return null;
        }
        Class<?> expectedType = m.getParameterTypes()[0];
        return this.getExpressionFactory().coerceToType(value, expectedType);
    }

    protected ExpressionFactory getExpressionFactory() {
        JspApplicationContext appContext = JspFactory.getDefaultFactory().getJspApplicationContext(this.pageContext.getServletContext());
        return appContext.getExpressionFactory();
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

