/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcPurRetTaxLnSave<RS>
implements IEntityProcessor<PurchaseReturnTaxLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;
    private UtlInvLine<RS, PurchaseReturn, ?, ?, ?> utlInvLine;

    @Override
    public final PurchaseReturnTaxLine process(Map<String, Object> pReqVars, PurchaseReturnTaxLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
        }
        pReqVars.put("PurchaseInvoicevendordeepLevel", 3);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        HashSet<String> ndFlInv = new HashSet<String>();
        ndFlInv.add("itsId");
        ndFlInv.add("vendor");
        ndFlInv.add("omitTaxes");
        ndFlInv.add("priceIncTax");
        ndFlInv.add("exchangeRate");
        ndFlInv.add("foreignCurrency");
        ndFlInv.add("hasMadeAccEntries");
        pReqVars.put("PurchaseInvoiceneededFields", ndFlInv);
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("PurchaseInvoiceneededFields");
        pReqVars.remove("PurchaseInvoicevendordeepLevel");
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromPurchase());
        if (txRules == null) {
            throw new ExceptionWithCode(1003, "non_taxable");
        }
        if (!txRules.getSalTaxIsInvoiceBase().booleanValue()) {
            throw new ExceptionWithCode(1003, "cant_edit_item_basis_tax");
        }
        PurchaseReturnTaxLine oldEntity = this.getSrvOrm().retrieveEntity(pReqVars, pEntity);
        pEntity.setTax(oldEntity.getTax());
        pEntity.setTaxableInvBas(oldEntity.getTaxableInvBas());
        pEntity.setTaxableInvBasFc(oldEntity.getTaxableInvBasFc());
        pEntity.setItsTotal(pEntity.getItsTotal().setScale((int)as.getPricePrecision(), txRules.getSalTaxRoundMode()));
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
            if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
            }
            pEntity.setForeignTotalTaxes(pEntity.getItsTotal().divide(exchRate, (int)as.getPricePrecision(), as.getRoundingMode()));
        }
        if (pEntity.getItsTotal().compareTo(oldEntity.getItsTotal()) != 0) {
            if (pEntity.getItsOwner().getDescription() == null) {
                pEntity.getItsOwner().setDescription(pEntity.getTax().getItsName() + ": " + oldEntity.getItsTotal() + "->" + pEntity.getItsTotal() + "!");
            } else {
                pEntity.getItsOwner().setDescription(pEntity.getItsOwner().getDescription() + " " + pEntity.getTax().getItsName() + ": " + oldEntity.getItsTotal() + "->" + pEntity.getItsTotal() + "!");
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, pEntity);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(pEntity.getItsOwner().getClass().getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlInvLine.adjInvLnsUpdTots(pReqVars, pEntity.getItsOwner(), as, txRules);
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", pEntity.getItsOwner().getClass().getSimpleName());
        return null;
    }

    public final UtlInvLine<RS, PurchaseReturn, ?, ?, ?> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, PurchaseReturn, ?, ?, ?> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

