/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseInvoiceLineSave<RS>
implements IEntityProcessor<PurchaseInvoiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceGoodsTaxLine> utlInvLine;
    private ISrvAccSettings srvAccSettings;

    @Override
    public final PurchaseInvoiceLine process(Map<String, Object> pReqVars, PurchaseInvoiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromPurchase());
            if (pEntity.getReversedId() != null) {
                PurchaseInvoiceLine reversed = this.getSrvOrm().retrieveEntityById(pReqVars, PurchaseInvoiceLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pReqVars.get("user"));
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source::" + pReqVars.get("user"));
                }
                pEntity.setTheRest(BigDecimal.ZERO);
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSite(reversed.getWarehouseSite());
                pEntity.setTaxCategory(reversed.getTaxCategory());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsCost(reversed.getItsCost());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                pEntity.setForeignPrice(reversed.getForeignPrice());
                pEntity.setForeignSubtotal(reversed.getForeignSubtotal().negate());
                pEntity.setForeignTotalTaxes(reversed.getForeignTotalTaxes().negate());
                pEntity.setForeignTotal(reversed.getForeignTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, reversed);
                this.getSrvOrm().deleteEntityWhere(pReqVars, PurchaseInvoiceGoodsTaxLine.class, "ITSOWNER=" + reversed.getItsId());
            } else {
                if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
                }
                if (pEntity.getItsCost().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pReqVars.get("user"));
                }
                pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getInvItem()));
                if (!InvItem.MATERIAL_ID.equals(pEntity.getInvItem().getItsType().getItsId()) && !InvItem.MERCHANDISE_ID.equals(pEntity.getInvItem().getItsType().getItsId())) {
                    throw new ExceptionWithCode(1003, "type_must_be_material_or_merchandise::" + pReqVars.get("user"));
                }
                pEntity.setTheRest(pEntity.getItsQuantity());
                BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
                if (exchRate != null && exchRate.compareTo(BigDecimal.ZERO) == -1) {
                    exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                }
                if (pEntity.getInvItem().getKnownCost() != null && pEntity.getInvItem().getKnownCost().compareTo(BigDecimal.ZERO) == 1) {
                    if (pEntity.getItsOwner().getForeignCurrency() != null) {
                        pEntity.setForeignPrice(pEntity.getInvItem().getKnownCost());
                        if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                            pEntity.setForeignTotal(pEntity.getItsQuantity().multiply(pEntity.getForeignPrice()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                        } else {
                            pEntity.setForeignSubtotal(pEntity.getItsQuantity().multiply(pEntity.getForeignPrice()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                        }
                        pEntity.setItsCost(pEntity.getForeignPrice().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setItsCost(pEntity.getInvItem().getKnownCost());
                    }
                    if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getItsQuantity().multiply(pEntity.getItsCost()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getItsCost()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    }
                } else if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    pEntity.setItsCost(pEntity.getForeignPrice().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getForeignTotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    }
                }
                this.utlInvLine.makeLine(pReqVars, pEntity, as, txRules);
            }
            this.srvWarehouseEntry.load(pReqVars, pEntity, pEntity.getWarehouseSite());
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.utlInvLine.makeTotals(pReqVars, pEntity, as, txRules);
            pReqVars.put("nextEntity", pEntity.getItsOwner());
            pReqVars.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pReqVars.get("user"));
    }

    public final UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceGoodsTaxLine> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceGoodsTaxLine> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }
}

