/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.PurchaseReturnLine;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseReturnLineSave<RS>
implements IEntityProcessor<PurchaseReturnLine, Long> {
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<UseMaterialEntry> srvUseMaterialEntry;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;
    private UtlInvLine<RS, PurchaseReturn, PurchaseReturnLine, PurchaseReturnTaxLine, PurchaseReturnGoodsTaxLine> utlInvLine;

    @Override
    public final PurchaseReturnLine process(Map<String, Object> pReqVars, PurchaseReturnLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("PurchaseInvoicevendordeepLevel", 3);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            HashSet<String> ndFlInv = new HashSet<String>();
            ndFlInv.add("itsId");
            ndFlInv.add("vendor");
            ndFlInv.add("omitTaxes");
            ndFlInv.add("priceIncTax");
            ndFlInv.add("exchangeRate");
            ndFlInv.add("foreignCurrency");
            ndFlInv.add("hasMadeAccEntries");
            pReqVars.put("PurchaseInvoiceneededFields", ndFlInv);
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("PurchaseInvoiceneededFields");
            pReqVars.remove("PurchaseInvoicevendordeepLevel");
            pReqVars.put("PurchaseInvoiceLineitsOwnerdeepLevel", 1);
            pEntity.setPurchaseInvoiceLine(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getPurchaseInvoiceLine()));
            pReqVars.remove("PurchaseInvoiceLineitsOwnerdeepLevel");
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner().getPurchaseInvoice(), as, as.getIsExtractSalesTaxFromPurchase());
            if (pEntity.getReversedId() != null) {
                PurchaseReturnLine reversed = this.getSrvOrm().retrieveEntityById(pReqVars, PurchaseReturnLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pReqVars.get("user"));
                }
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setPurchaseInvoiceLine(reversed.getPurchaseInvoiceLine());
                pEntity.setPurchInvLnAppearance(reversed.getPurchInvLnAppearance());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setForeignTotalTaxes(reversed.getForeignTotalTaxes().negate());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setForeignSubtotal(reversed.getForeignSubtotal().negate());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                pEntity.setForeignTotal(reversed.getForeignTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, reversed);
                PurchaseReturnGoodsTaxLine pigtlt = new PurchaseReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                List<PurchaseReturnGoodsTaxLine> tls = this.getSrvOrm().retrieveListForField(pReqVars, pigtlt, "itsOwner");
                for (PurchaseReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pReqVars, pigtl);
                }
                this.srvWarehouseEntry.reverseDraw(pReqVars, pEntity);
                this.srvUseMaterialEntry.reverseDraw(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                BigDecimal sourceCost;
                BigDecimal curCost;
                if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero");
                }
                if (pEntity.getPurchaseInvoiceLine() == null) {
                    throw new ExceptionWithCode(1003, "wrong_purchaseInvoiceLine");
                }
                String langDef = (String)pReqVars.get("langDef");
                pEntity.setPurchInvLnAppearance(this.getSrvI18n().getMsg(PurchaseInvoiceLine.class.getSimpleName() + "short", langDef) + " #" + pEntity.getPurchaseInvoiceLine().getIdDatabaseBirth() + "-" + pEntity.getPurchaseInvoiceLine().getItsId() + ", " + pEntity.getPurchaseInvoiceLine().getInvItem().getItsName() + ", " + pEntity.getPurchaseInvoiceLine().getUnitOfMeasure().getItsName() + ", " + this.getSrvI18n().getMsg("itsCost", langDef) + "=" + this.prnc(pReqVars, pEntity.getPurchaseInvoiceLine().getItsCost()) + ", " + this.getSrvI18n().getMsg("rest_was", langDef) + "=" + this.prnq(pReqVars, pEntity.getPurchaseInvoiceLine().getTheRest()));
                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
                    if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                        exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                    }
                    if (pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getForeignTotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                        curCost = pEntity.getForeignTotal().divide(pEntity.getItsQuantity(), (int)as.getCostPrecision(), as.getRoundingMode());
                    } else {
                        pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                        curCost = pEntity.getForeignSubtotal().divide(pEntity.getItsQuantity(), (int)as.getCostPrecision(), as.getRoundingMode());
                    }
                    sourceCost = pEntity.getForeignPrice();
                } else {
                    curCost = txRules == null || pEntity.getItsOwner().getPriceIncTax() != false ? pEntity.getItsTotal().divide(pEntity.getItsQuantity(), (int)as.getCostPrecision(), as.getRoundingMode()) : pEntity.getSubtotal().divide(pEntity.getItsQuantity(), (int)as.getCostPrecision(), as.getRoundingMode());
                    sourceCost = pEntity.getItsPrice();
                }
                if (sourceCost.compareTo(curCost) != 0) {
                    if (pEntity.getDescription() == null) {
                        pEntity.setDescription(curCost.toString() + "!=" + sourceCost + "!");
                    } else {
                        pEntity.setDescription(pEntity.getDescription() + " " + curCost + "!=" + sourceCost + "!");
                    }
                }
                this.utlInvLine.makeLine(pReqVars, pEntity, as, txRules);
                this.srvWarehouseEntry.withdrawal(pReqVars, pEntity, pEntity.getWarehouseSiteFo());
                this.srvUseMaterialEntry.withdrawalFrom(pReqVars, pEntity, pEntity.getPurchaseInvoiceLine(), pEntity.getItsQuantity());
            }
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.utlInvLine.makeTotals(pReqVars, pEntity, as, txRules);
            pReqVars.put("nextEntity", pEntity.getItsOwner());
            pReqVars.put("nameOwnerEntity", PurchaseReturn.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "Attempt to update purchase return line by " + pReqVars.get("user"));
    }

    public final String prnc(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("decSepv"), (String)pReqVars.get("decGrSepv"), (Integer)pReqVars.get("costDp"), (Integer)pReqVars.get("digInGr"));
    }

    public final String prnq(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("decSepv"), (String)pReqVars.get("decGrSepv"), (Integer)pReqVars.get("quantityDp"), (Integer)pReqVars.get("digInGr"));
    }

    public final UtlInvLine<RS, PurchaseReturn, PurchaseReturnLine, PurchaseReturnTaxLine, PurchaseReturnGoodsTaxLine> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, PurchaseReturn, PurchaseReturnLine, PurchaseReturnTaxLine, PurchaseReturnGoodsTaxLine> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<UseMaterialEntry> getSrvUseMaterialEntry() {
        return this.srvUseMaterialEntry;
    }

    public final void setSrvUseMaterialEntry(ISrvDrawItemEntry<UseMaterialEntry> pSrvUseMaterialEntry) {
        this.srvUseMaterialEntry = pSrvUseMaterialEntry;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

