/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ManufacturingProcess;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.persistable.UsedMaterialLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcUsedMaterialLineSave<RS>
implements IEntityProcessor<UsedMaterialLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<UseMaterialEntry> srvUseMaterialEntry;
    private ISrvAccSettings srvAccSettings;

    @Override
    public final UsedMaterialLine process(Map<String, Object> pAddParam, UsedMaterialLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() <= 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
            }
            pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getInvItem()));
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(ManufacturingProcess.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            if (pEntity.getItsOwner().getIsComplete().booleanValue()) {
                throw new ExceptionWithCode(403, "attempt_to_change_completed_manufacturing_process::" + pAddParam.get("user"));
            }
            pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getInvItem()));
            if (!InvItem.MATERIAL_ID.equals(pEntity.getInvItem().getItsType().getItsId())) {
                throw new ExceptionWithCode(1003, "type_must_be_material::" + pAddParam.get("user"));
            }
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsCost(pEntity.getItsCost().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsTotal(pEntity.getItsCost().multiply(pEntity.getItsQuantity()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
            pEntity.setItsOwner(pEntity.getItsOwner());
            if (pEntity.getReversedId() != null) {
                UsedMaterialLine reversed = this.getSrvOrm().retrieveEntityById(pAddParam, UsedMaterialLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pAddParam.get("user"));
                }
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, reversed);
                this.srvWarehouseEntry.reverseDraw(pAddParam, pEntity);
                this.srvUseMaterialEntry.reverseDraw(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                this.srvWarehouseEntry.withdrawal(pAddParam, pEntity, pEntity.getWarehouseSiteFo());
                this.srvUseMaterialEntry.withdrawal(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            }
            String query = "select sum(ITSTOTAL) as ITSTOTAL from USEMATERIALENTRY where DRAWINGID=" + pEntity.getItsId() + " and DRAWINGTYPE=" + pEntity.constTypeCode();
            Double total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
            pEntity.setItsTotal(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsCost(pEntity.getItsTotal().divide(pEntity.getItsQuantity(), (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
            query = "select sum(ITSTOTAL) as ITSTOTAL from USEDMATERIALLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
            total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
            pEntity.getItsOwner().setTotalMaterialsCost(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getTotalMaterialsCost().add(pEntity.getItsOwner().getTotalAdditionCost()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setItsCost(pEntity.getItsOwner().getItsTotal().divide(pEntity.getItsOwner().getItsQuantity(), (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().updateEntity(pAddParam, pEntity.getItsOwner());
            pAddParam.put("nextEntity", pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", ManufacturingProcess.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<UseMaterialEntry> getSrvUseMaterialEntry() {
        return this.srvUseMaterialEntry;
    }

    public final void setSrvUseMaterialEntry(ISrvDrawItemEntry<UseMaterialEntry> pSrvUseMaterialEntry) {
        this.srvUseMaterialEntry = pSrvUseMaterialEntry;
    }
}

