/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprInvLnTotal;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.model.CmprTaxRate;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.IInvoice;
import org.beigesoft.accounting.persistable.IInvoiceLine;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.persistable.base.ADestTaxItemLn;
import org.beigesoft.accounting.persistable.base.ADocTaxLine;
import org.beigesoft.accounting.persistable.base.ADocTaxLineFc;
import org.beigesoft.accounting.persistable.base.AInvTxLn;
import org.beigesoft.accounting.persistable.base.ALineTxLn;
import org.beigesoft.accounting.processor.DataTx;
import org.beigesoft.accounting.processor.IInvLnTxMeth;
import org.beigesoft.accounting.processor.IInvTxMeth;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.AEditable;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class UtlInvBase<RS> {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvNumberToString srvNumberToString;

    public final TaxDestination revealTaxRules(Map<String, Object> pReqVars, IInvoice pInv, AccSettings pAs, Boolean pIsExtrTx) throws Exception {
        TaxDestination txRules = null;
        if (pIsExtrTx.booleanValue() && !pInv.getOmitTaxes().booleanValue() && !pInv.getCustomer().getIsForeigner().booleanValue()) {
            if (pInv.getCustomer().getTaxDestination() != null) {
                txRules = pInv.getCustomer().getTaxDestination();
            } else {
                txRules = new TaxDestination();
                txRules.setSalTaxIsInvoiceBase(pAs.getSalTaxIsInvoiceBase());
                txRules.setSalTaxUseAggregItBas(pAs.getSalTaxUseAggregItBas());
                txRules.setSalTaxRoundMode(pAs.getSalTaxRoundMode());
            }
        }
        return txRules;
    }

    public final <T extends IInvoice, L extends IInvoiceLine<T>, TL extends AInvTxLn<T>> void makeTotals(Map<String, Object> pReqVars, L pLine, AccSettings pAs, TaxDestination pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        pReqVars.put(pInvTxMeth.getInvTxLnCl().getSimpleName() + "itsOwnerdeepLevel", 1);
        List<TL> invTxLns = this.getSrvOrm().retrieveListWithConditions(pReqVars, pInvTxMeth.getInvTxLnCl(), "where ITSOWNER=" + ((IInvoice)pLine.getItsOwner()).getItsId());
        pReqVars.remove(pInvTxMeth.getInvTxLnCl().getSimpleName() + "itsOwnerdeepLevel");
        for (AInvTxLn tl : invTxLns) {
            tl.setTax(null);
            tl.setTaxableInvBas(BigDecimal.ZERO);
            tl.setTaxableInvBasFc(BigDecimal.ZERO);
            tl.setItsTotal(BigDecimal.ZERO);
            tl.setForeignTotalTaxes(BigDecimal.ZERO);
        }
        if (pTxRules != null) {
            DataTx dtTx = this.retrieveDataTx(pReqVars, pLine, pAs, pTxRules, pInvTxMeth);
            if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && ((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue())) {
                for (int i = 0; i < dtTx.getTxs().size(); ++i) {
                    Double txTotd;
                    TL tl = this.findCreateTaxLine(pReqVars, (IInvoice)pLine.getItsOwner(), invTxLns, dtTx.getTxs().get(i), false, pInvTxMeth.getFctInvTxLn());
                    Double txTotdFc = 0.0;
                    if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                        txTotd = dtTx.getTxTotTaxb().get(i);
                        txTotdFc = dtTx.getTxTotTaxbFc().get(i);
                    } else {
                        txTotd = dtTx.getTxTotTaxb().get(i) * dtTx.getTxPerc().get(i) / 100.0;
                        ((AInvTxLn)tl).setTaxableInvBas(BigDecimal.valueOf(dtTx.getTxTotTaxb().get(i)));
                        if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                            txTotdFc = dtTx.getTxTotTaxbFc().get(i) * dtTx.getTxPerc().get(i) / 100.0;
                            ((AInvTxLn)tl).setTaxableInvBasFc(BigDecimal.valueOf(dtTx.getTxTotTaxbFc().get(i)));
                        }
                    }
                    ((ADocTaxLine)tl).setItsTotal(BigDecimal.valueOf(txTotd).setScale((int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                    ((ADocTaxLineFc)tl).setForeignTotalTaxes(BigDecimal.valueOf(txTotdFc).setScale((int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                    if (((AEditable)tl).getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, tl);
                        ((AEditable)tl).setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pReqVars, tl);
                }
            } else {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (SalesInvoiceServiceLine txdLn : dtTx.getTxdLns()) {
                    int ti = 0;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    BigDecimal taxAggegatedFc = BigDecimal.ZERO;
                    BigDecimal taxAggrAccumFc = BigDecimal.ZERO;
                    Collections.sort(txdLn.getTaxCategory().getTaxes(), cmpr);
                    for (InvItemTaxCategoryLine itcl : txdLn.getTaxCategory().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null) {
                            if (pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                                if (((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
                                    taxAggegated = txdLn.getItsTotal().subtract(txdLn.getItsTotal().divide(BigDecimal.ONE.add(txdLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                                    if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                        taxAggegatedFc = txdLn.getForeignTotal().subtract(txdLn.getForeignTotal().divide(BigDecimal.ONE.add(txdLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                                    }
                                } else {
                                    taxAggegated = txdLn.getSubtotal().multiply(txdLn.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                                    if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                        taxAggegatedFc = txdLn.getForeignSubtotal().multiply(txdLn.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                                    }
                                }
                            } else {
                                taxAggegated = txdLn.getTotalTaxes();
                                taxAggegatedFc = txdLn.getForeignTotalTaxes();
                            }
                        }
                        if (ti < txdLn.getTaxCategory().getTaxes().size()) {
                            txdLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(txdLn.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                            taxAggrAccum = taxAggrAccum.add(txdLn.getTotalTaxes());
                            if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                txdLn.setForeignTotalTaxes(taxAggegatedFc.multiply(itcl.getItsPercentage()).divide(txdLn.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                                taxAggrAccumFc = taxAggrAccumFc.add(txdLn.getForeignTotalTaxes());
                            }
                        } else {
                            txdLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                            if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                txdLn.setForeignTotalTaxes(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        }
                        TL tl = this.findCreateTaxLine(pReqVars, (IInvoice)pLine.getItsOwner(), invTxLns, itcl.getTax(), true, pInvTxMeth.getFctInvTxLn());
                        ((ADocTaxLine)tl).setItsTotal(((ADocTaxLine)tl).getItsTotal().add(txdLn.getTotalTaxes()));
                        if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                            ((ADocTaxLineFc)tl).setForeignTotalTaxes(((ADocTaxLineFc)tl).getForeignTotalTaxes().add(txdLn.getForeignTotalTaxes()));
                        }
                        if (pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                            if (ti == txdLn.getTaxCategory().getTaxes().size()) {
                                txdLn.setTotalTaxes(taxAggegated);
                                txdLn.setTotalTaxes(taxAggegatedFc);
                            }
                            if (!((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
                                ((AInvTxLn)tl).setTaxableInvBas(((AInvTxLn)tl).getTaxableInvBas().add(txdLn.getSubtotal()));
                                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                    ((AInvTxLn)tl).setTaxableInvBasFc(((AInvTxLn)tl).getTaxableInvBasFc().add(txdLn.getForeignSubtotal()));
                                }
                            } else {
                                ((AInvTxLn)tl).setTaxableInvBas(((AInvTxLn)tl).getTaxableInvBas().add(txdLn.getItsTotal()));
                                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                                    ((AInvTxLn)tl).setTaxableInvBasFc(((AInvTxLn)tl).getTaxableInvBasFc().add(txdLn.getForeignTotal()));
                                }
                            }
                        }
                        if (((AEditable)tl).getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pReqVars, tl);
                            ((AEditable)tl).setIsNew(false);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pReqVars, tl);
                    }
                }
            }
            if (pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                this.adjustInvoiceLns(pReqVars, (IInvoice)pLine.getItsOwner(), dtTx.getTxdLns(), pAs, pInvTxMeth);
            }
        }
        for (AInvTxLn tl : invTxLns) {
            if (tl.getTax() != null) continue;
            this.getSrvOrm().deleteEntity(pReqVars, tl);
        }
        if (pTxRules != null && !pTxRules.getSalTaxUseAggregItBas().booleanValue() && ((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
            String watr = "TTR without aggregate! ";
            if (((IInvoice)pLine.getItsOwner()).getDescription() == null) {
                ((IInvoice)pLine.getItsOwner()).setDescription(watr);
            } else if (!((IInvoice)pLine.getItsOwner()).getDescription().contains(watr)) {
                ((IInvoice)pLine.getItsOwner()).setDescription(watr + ((IInvoice)pLine.getItsOwner()).getDescription());
            }
        }
        this.updInvTots(pReqVars, (IInvoice)pLine.getItsOwner(), pAs, pInvTxMeth);
    }

    public final <T extends IInvoice> void updInvTots(Map<String, Object> pReqVars, T pInv, AccSettings pAs, IInvTxMeth<T, ?> pInvTxMeth) throws Exception {
        String query = pInvTxMeth.lazyGetQuTotals();
        query = query.replace(":ITSOWNER", ((Long)pInv.getItsId()).toString());
        if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSERVICELN", pInvTxMeth.getTblNmsTot()[1]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[2]);
        } else {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[1]);
        }
        String[] columns = new String[]{"SUBTOTAL", "ITSTOTAL", "TOTALTAXES", "FOREIGNSUBTOTAL", "FOREIGNTOTAL", "FOREIGNTOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        if (totals[2] == null) {
            totals[2] = 0.0;
        }
        if (totals[3] == null) {
            totals[3] = 0.0;
        }
        if (totals[4] == null) {
            totals[4] = 0.0;
        }
        if (totals[5] == null) {
            totals[5] = 0.0;
        }
        if (pInv.getPriceIncTax().booleanValue()) {
            pInv.setItsTotal(BigDecimal.valueOf(totals[1]).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode()));
            pInv.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)pAs.getPricePrecision(), pAs.getSalTaxRoundMode()));
            pInv.setSubtotal(pInv.getItsTotal().subtract(pInv.getTotalTaxes()));
            pInv.setForeignTotal(BigDecimal.valueOf(totals[4]).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode()));
            pInv.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)pAs.getPricePrecision(), pAs.getSalTaxRoundMode()));
            pInv.setForeignSubtotal(pInv.getForeignTotal().subtract(pInv.getForeignTotalTaxes()));
        } else {
            pInv.setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode()));
            pInv.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)pAs.getPricePrecision(), pAs.getSalTaxRoundMode()));
            pInv.setItsTotal(pInv.getSubtotal().add(pInv.getTotalTaxes()));
            pInv.setForeignSubtotal(BigDecimal.valueOf(totals[3]).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode()));
            pInv.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)pAs.getPricePrecision(), pAs.getSalTaxRoundMode()));
            pInv.setForeignTotal(pInv.getForeignSubtotal().add(pInv.getForeignTotalTaxes()));
        }
        this.getSrvOrm().updateEntity(pReqVars, pInv);
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends IInvoice, L extends IInvoiceLine<T>, TL extends AInvTxLn<T>> void adjustInvoiceLns(Map<String, Object> pReqVars, T pInv, List<SalesInvoiceServiceLine> pTxdLns, AccSettings pAs, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        String tbNm = pInvTxMeth.getGoodLnCl().getSimpleName();
        pReqVars.put(tbNm + "itsOwnerdeepLevel", 1);
        List<IInvoiceLine<T>> gls = this.getSrvOrm().retrieveListWithConditions(pReqVars, pInvTxMeth.getGoodLnCl(), pInvTxMeth.getStWhereAdjGdLnInvBas() + pInv.getItsId());
        pReqVars.remove(tbNm + "itsOwnerdeepLevel");
        List<IInvoiceLine<T>> sls = null;
        if (pInvTxMeth.getServiceLnCl() != null) {
            tbNm = pInvTxMeth.getServiceLnCl().getSimpleName();
            pReqVars.put(tbNm + "itsOwnerdeepLevel", 1);
            sls = this.getSrvOrm().retrieveListWithConditions(pReqVars, pInvTxMeth.getServiceLnCl(), pInvTxMeth.getStWhereAdjSrLnInvBas() + pInv.getItsId());
            pReqVars.remove(tbNm + "itsOwnerdeepLevel");
        }
        ArrayList<IInvoiceLine<T>> ilsm = new ArrayList<IInvoiceLine<T>>();
        Comparator cmpr = Collections.reverseOrder(new CmprInvLnTotal());
        for (SalesInvoiceServiceLine txdLn : pTxdLns) {
            for (IInvoiceLine<T> iInvoiceLine : gls) {
                if (!iInvoiceLine.getTaxCategory().getItsId().equals(txdLn.getTaxCategory().getItsId())) continue;
                ilsm.add(iInvoiceLine);
            }
            if (sls != null) {
                for (IInvoiceLine<Object> iInvoiceLine : sls) {
                    if (!iInvoiceLine.getTaxCategory().getItsId().equals(txdLn.getTaxCategory().getItsId())) continue;
                    ilsm.add(iInvoiceLine);
                }
            }
            Collections.sort(ilsm, cmpr);
            BigDecimal txRest = txdLn.getTotalTaxes();
            BigDecimal bigDecimal = txdLn.getForeignTotalTaxes();
            for (int i = 0; i < ilsm.size(); ++i) {
                void var14_14;
                if (i + 1 == ilsm.size()) {
                    if (pInv.getPriceIncTax().booleanValue()) {
                        ((IInvoiceLine)ilsm.get(i)).setSubtotal(((IInvoiceLine)ilsm.get(i)).getItsTotal().subtract(txRest));
                    } else {
                        ((IInvoiceLine)ilsm.get(i)).setItsTotal(((IInvoiceLine)ilsm.get(i)).getSubtotal().add(txRest));
                    }
                    ((IInvoiceLine)ilsm.get(i)).setTotalTaxes(txRest);
                    if (pInv.getForeignCurrency() != null) {
                        if (pInv.getPriceIncTax().booleanValue()) {
                            ((IInvoiceLine)ilsm.get(i)).setForeignSubtotal(((IInvoiceLine)ilsm.get(i)).getForeignTotal().subtract((BigDecimal)var14_14));
                        } else {
                            ((IInvoiceLine)ilsm.get(i)).setForeignTotal(((IInvoiceLine)ilsm.get(i)).getForeignSubtotal().add((BigDecimal)var14_14));
                        }
                        ((IInvoiceLine)ilsm.get(i)).setForeignTotalTaxes((BigDecimal)var14_14);
                    }
                } else {
                    BigDecimal taxTot;
                    if (pInv.getPriceIncTax().booleanValue()) {
                        taxTot = txdLn.getTotalTaxes().multiply(((IInvoiceLine)ilsm.get(i)).getItsTotal()).divide(txdLn.getItsTotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilsm.get(i)).setSubtotal(((IInvoiceLine)ilsm.get(i)).getItsTotal().subtract(taxTot));
                    } else {
                        taxTot = txdLn.getTotalTaxes().multiply(((IInvoiceLine)ilsm.get(i)).getSubtotal()).divide(txdLn.getSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilsm.get(i)).setItsTotal(((IInvoiceLine)ilsm.get(i)).getSubtotal().add(taxTot));
                    }
                    ((IInvoiceLine)ilsm.get(i)).setTotalTaxes(taxTot);
                    txRest = txRest.subtract(taxTot);
                    if (pInv.getForeignCurrency() != null) {
                        BigDecimal taxTotFc;
                        if (pInv.getPriceIncTax().booleanValue()) {
                            taxTotFc = txdLn.getForeignTotalTaxes().multiply(((IInvoiceLine)ilsm.get(i)).getForeignTotal()).divide(txdLn.getForeignTotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                            ((IInvoiceLine)ilsm.get(i)).setForeignSubtotal(((IInvoiceLine)ilsm.get(i)).getForeignTotal().subtract(taxTotFc));
                        } else {
                            taxTotFc = txdLn.getForeignTotalTaxes().multiply(((IInvoiceLine)ilsm.get(i)).getForeignSubtotal()).divide(txdLn.getForeignSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                            ((IInvoiceLine)ilsm.get(i)).setForeignTotal(((IInvoiceLine)ilsm.get(i)).getForeignSubtotal().add(taxTotFc));
                        }
                        ((IInvoiceLine)ilsm.get(i)).setForeignTotalTaxes(taxTotFc);
                        BigDecimal bigDecimal2 = var14_14.subtract(taxTotFc);
                    }
                }
                this.getSrvOrm().updateEntity(pReqVars, ilsm.get(i));
            }
            ilsm.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends IInvoice, L extends IInvoiceLine<T>, TL extends AInvTxLn<T>> ArrayList<SalesInvoiceServiceLine> retrTxdLnsAdjInv(Map<String, Object> pReqVars, T pInv, AccSettings pAs, TaxDestination pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        ArrayList<SalesInvoiceServiceLine> txdLns = new ArrayList<SalesInvoiceServiceLine>();
        HashMap<Long, Object> tcTxs = new HashMap<Long, Object>();
        ArrayList<Tax> txs = new ArrayList<Tax>();
        String query = pInvTxMeth.lazyGetQuTxInvAdj();
        if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSERVICELN", pInvTxMeth.getTblNmsTot()[1]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[2]);
        } else {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TTAXLN", pInvTxMeth.getTblNmsTot()[1]);
        }
        query = query.replace(":INVOICEID", ((Long)pInv.getItsId()).toString());
        BigDecimal bd100 = new BigDecimal("100.00");
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    BigDecimal txvf;
                    BigDecimal txv;
                    Long txId = recordSet.getLong("TAXID");
                    int li = txs.size() - 1;
                    if (li < 0 || !((Tax)txs.get(li)).getItsId().equals(txId)) {
                        Tax tax = new Tax();
                        tax.setItsId(txId);
                        Double txtot = recordSet.getDouble("TXTOT");
                        Double txtotfc = recordSet.getDouble("TXTOTFC");
                        tax.setItsPercentage(BigDecimal.valueOf(txtot));
                        tax.setPlusAmount(BigDecimal.valueOf(txtotfc));
                        txs.add(tax);
                    }
                    Double d = recordSet.getDouble("ITSPERCENTAGE");
                    Long tcId = recordSet.getLong("TAXCATID");
                    Object tctxs = null;
                    for (Map.Entry ent : tcTxs.entrySet()) {
                        if (!((Long)ent.getKey()).equals(tcId)) continue;
                        tctxs = (List)ent.getValue();
                        break;
                    }
                    if (tctxs == null) {
                        tctxs = new ArrayList();
                        tcTxs.put(tcId, tctxs);
                    }
                    Tax tctx = new Tax();
                    tctx.setItsId(txId);
                    tctxs.add(tctx);
                    BigDecimal prbd = BigDecimal.valueOf(d);
                    if (!pInv.getPriceIncTax().booleanValue()) {
                        Double su = recordSet.getDouble("SUBTOTAL");
                        Double suf = recordSet.getDouble("FOREIGNSUBTOTAL");
                        txv = BigDecimal.valueOf(su).multiply(prbd).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                        txvf = BigDecimal.valueOf(suf).multiply(prbd).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                    } else {
                        Double tot = recordSet.getDouble("ITSTOTAL");
                        Double totf = recordSet.getDouble("FOREIGNTOTAL");
                        BigDecimal totbd = BigDecimal.valueOf(tot);
                        BigDecimal totbdf = BigDecimal.valueOf(totf);
                        txv = totbd.subtract(totbd.divide(BigDecimal.ONE.add(prbd.divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                        txvf = totbdf.subtract(totbdf.divide(BigDecimal.ONE.add(prbd.divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                    }
                    tctx.setPlusAmount(txvf);
                    tctx.setItsPercentage(txv);
                } while (recordSet.moveToNext());
            }
        }
        CmprTaxRate cmpr = new CmprTaxRate();
        for (Tax tax : txs) {
            ArrayList<Tax> tlns = new ArrayList<Tax>();
            for (Map.Entry ent : tcTxs.entrySet()) {
                for (Tax tctx : (List)ent.getValue()) {
                    if (!tctx.getItsId().equals(tax.getItsId())) continue;
                    tlns.add(tctx);
                }
            }
            Collections.sort(tlns, cmpr);
            BigDecimal txRest = tax.getItsPercentage();
            BigDecimal txRestFc = tax.getPlusAmount();
            for (int i = 0; i < tlns.size(); ++i) {
                if (i + 1 == tlns.size()) {
                    ((Tax)tlns.get(i)).setItsPercentage(txRest);
                    ((Tax)tlns.get(i)).setPlusAmount(txRestFc);
                    continue;
                }
                txRest = txRest.subtract(((Tax)tlns.get(i)).getItsPercentage());
                txRestFc = txRestFc.subtract(((Tax)tlns.get(i)).getPlusAmount());
            }
        }
        for (Map.Entry entry : tcTxs.entrySet()) {
            SalesInvoiceServiceLine txdLn = new SalesInvoiceServiceLine();
            txdLn.setItsId((Long)entry.getKey());
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId((Long)entry.getKey());
            txdLn.setTaxCategory(tc);
            txdLns.add(txdLn);
            for (Tax tx : (List)entry.getValue()) {
                txdLn.setTotalTaxes(txdLn.getTotalTaxes().add(tx.getItsPercentage()));
                txdLn.setForeignTotalTaxes(txdLn.getForeignTotalTaxes().add(tx.getPlusAmount()));
            }
        }
        return txdLns;
    }

    public final <T extends IInvoice, L extends IInvoiceLine<T>, TL extends AInvTxLn<T>, LTL extends ALineTxLn<T, L>> void makeLine(Map<String, Object> pReqVars, L pLine, AccSettings pAs, TaxDestination pTxRules, IInvTxMeth<T, TL> pInvTxMeth, IInvLnTxMeth<T, L, LTL> pInvLnTxMeth) throws Exception {
        if (pInvLnTxMeth.getNeedMkTxCat().booleanValue()) {
            if (pTxRules != null) {
                pLine.setTaxCategory(pLine.getItem().getTaxCategory());
                if (((IInvoice)pLine.getItsOwner()).getCustomer().getTaxDestination() != null) {
                    pReqVars.put(pInvLnTxMeth.getDstTxItLnCl().getSimpleName() + "itsOwnerdeepLevel", 1);
                    List<ADestTaxItemLn<?>> dtls = this.getSrvOrm().retrieveListWithConditions(pReqVars, pInvLnTxMeth.getDstTxItLnCl(), "where ITSOWNER=" + pLine.getItem().getItsId());
                    pReqVars.remove(pInvLnTxMeth.getDstTxItLnCl().getSimpleName() + "itsOwnerdeepLevel");
                    for (ADestTaxItemLn<?> dtl : dtls) {
                        if (!dtl.getTaxDestination().getItsId().equals(((IInvoice)pLine.getItsOwner()).getCustomer().getTaxDestination().getItsId())) continue;
                        pLine.setTaxCategory(dtl.getTaxCategory());
                        break;
                    }
                }
            } else {
                pLine.setTaxCategory(null);
            }
        }
        List<LTL> itls = null;
        if (pLine.getTaxCategory() != null) {
            if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                if (!pTxRules.getSalTaxUseAggregItBas().booleanValue()) {
                    itls = this.mkLnTxItBasNonAggr(pReqVars, pLine, pAs, pTxRules, pInvTxMeth, pInvLnTxMeth);
                } else {
                    BigDecimal totTxs = BigDecimal.ZERO;
                    BigDecimal totTxsFc = BigDecimal.ZERO;
                    BigDecimal bd100 = new BigDecimal("100.00");
                    if (((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
                        totTxs = pLine.getItsTotal().subtract(pLine.getItsTotal().divide(BigDecimal.ONE.add(pLine.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                        if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                            totTxsFc = pLine.getForeignTotal().subtract(pLine.getForeignTotal().divide(BigDecimal.ONE.add(pLine.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                        }
                    } else {
                        totTxs = pLine.getSubtotal().multiply(pLine.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                        if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                            totTxsFc = pLine.getForeignSubtotal().multiply(pLine.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                        }
                    }
                    pLine.setTaxesDescription(pLine.getTaxCategory().getItsName());
                    this.mkLnFinal(pLine, totTxs, totTxsFc, pInvTxMeth.getIsTxByUser());
                }
            } else {
                pLine.setTaxesDescription(pLine.getTaxCategory().getItsName());
                pLine.setTotalTaxes(BigDecimal.ZERO);
                pLine.setForeignTotalTaxes(BigDecimal.ZERO);
            }
        } else {
            pLine.setTaxesDescription(null);
            pLine.setTotalTaxes(BigDecimal.ZERO);
            pLine.setForeignTotalTaxes(BigDecimal.ZERO);
        }
        if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() == null) {
            pLine.setForeignTotalTaxes(BigDecimal.ZERO);
            pLine.setForeignTotal(BigDecimal.ZERO);
            pLine.setForeignSubtotal(BigDecimal.ZERO);
        }
        if (pTxRules == null || !pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
            if (pTxRules == null || ((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
                pLine.setSubtotal(pLine.getItsTotal().subtract(pLine.getTotalTaxes()));
                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                    pLine.setForeignSubtotal(pLine.getForeignTotal().subtract(pLine.getForeignTotalTaxes()));
                }
            } else {
                pLine.setItsTotal(pLine.getSubtotal().add(pLine.getTotalTaxes()));
                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                    pLine.setForeignTotal(pLine.getForeignSubtotal().add(pLine.getForeignTotalTaxes()));
                }
            }
        }
        if (pLine.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, pLine);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, pLine);
        }
        if (itls != null) {
            int j;
            List<LTL> itlsr = null;
            if (pInvLnTxMeth.getIsMutable().booleanValue() && !pLine.getIsNew().booleanValue()) {
                pReqVars.put(pInvLnTxMeth.getLtlCl().getSimpleName() + "itsOwnerdeepLevel", 1);
                itlsr = this.getSrvOrm().retrieveListWithConditions(pReqVars, pInvLnTxMeth.getLtlCl(), "where ITSOWNER=" + pLine.getItsId());
                pReqVars.remove(pInvLnTxMeth.getLtlCl().getSimpleName() + "itsOwnerdeepLevel");
            }
            for (j = 0; j < itls.size(); ++j) {
                if (itlsr != null && j < itlsr.size()) {
                    ((ALineTxLn)itlsr.get(j)).setTax(((ALineTxLn)itls.get(j)).getTax());
                    ((ALineTxLn)itlsr.get(j)).setItsTotal(((ALineTxLn)itls.get(j)).getItsTotal());
                    ((ALineTxLn)itlsr.get(j)).setItsOwner(pLine);
                    this.getSrvOrm().updateEntity(pReqVars, itlsr.get(j));
                    continue;
                }
                ((ALineTxLn)itls.get(j)).setItsOwner(pLine);
                ((ALineTxLn)itls.get(j)).setInvoiceId((Long)((IInvoice)pLine.getItsOwner()).getItsId());
                this.getSrvOrm().insertEntity(pReqVars, itls.get(j));
                ((ALineTxLn)itls.get(j)).setIsNew(false);
            }
            if (itlsr != null) {
                for (j = itls.size(); j < itlsr.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pReqVars, itlsr.get(j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends IInvoice, L extends IInvoiceLine<T>, TL extends AInvTxLn<T>> DataTx retrieveDataTx(Map<String, Object> pReqVars, L pLine, AccSettings pAs, TaxDestination pTxRules, IInvTxMeth<T, TL> pInvTxMeth) throws Exception {
        String query;
        DataTx dtTx = new DataTx();
        if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && ((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue())) {
            dtTx.setTxs(new ArrayList<Tax>());
            dtTx.setTxTotTaxb(new ArrayList<Double>());
            dtTx.setTxTotTaxbFc(new ArrayList<Double>());
            if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                query = pInvTxMeth.lazyGetQuTxItBas();
            } else {
                dtTx.setTxPerc(new ArrayList<Double>());
                query = pInvTxMeth.lazyGetQuTxInvBas();
                dtTx.setTxdLns(new ArrayList<SalesInvoiceServiceLine>());
            }
        } else {
            dtTx.setTxdLns(new ArrayList<SalesInvoiceServiceLine>());
            query = pTxRules.getSalTaxIsInvoiceBase() == false ? pInvTxMeth.lazyGetQuTxItBasAggr() : pInvTxMeth.lazyGetQuTxInvBasAggr();
        }
        if (this.getLogger().getIsShowDebugMessagesFor(this.getClass()) && this.getLogger().getDetailLevel() > 40000) {
            this.getLogger().debug(pReqVars, UtlInvBase.class, "Tax rules: aggregate/invoice basis/zip/RM = " + pTxRules.getSalTaxUseAggregItBas() + "/" + pTxRules.getSalTaxIsInvoiceBase() + "/" + pTxRules.getRegZip() + "/" + (Object)((Object)pTxRules.getSalTaxRoundMode()));
            String txCat = pLine.getTaxCategory() != null ? pLine.getTaxCategory().getItsName() : "-";
            this.getLogger().debug(pReqVars, UtlInvBase.class, "Item: name/tax category = " + pLine.getItem().getItsName() + "/" + txCat);
            this.getLogger().debug(pReqVars, UtlInvBase.class, "Tax query: " + query);
        }
        if (!pTxRules.getSalTaxUseAggregItBas().booleanValue() && !pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
            if (pInvTxMeth.getTblNmsTot().length == 5) {
                query = query.replace(":TGOODTXLN", pInvTxMeth.getTblNmsTot()[3]);
                query = query.replace(":TSERVICETXLN", pInvTxMeth.getTblNmsTot()[4]);
            } else {
                query = query.replace(":TITEMTXLN", pInvTxMeth.getTblNmsTot()[2]);
            }
        } else if (pInvTxMeth.getTblNmsTot().length == 5) {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
            query = query.replace(":TSERVICELN", pInvTxMeth.getTblNmsTot()[1]);
        } else {
            query = query.replace(":TGOODLN", pInvTxMeth.getTblNmsTot()[0]);
        }
        query = query.replace(":INVOICEID", ((Long)((IInvoice)pLine.getItsOwner()).getItsId()).toString());
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    Long txId = recordSet.getLong("TAXID");
                    String txNm = recordSet.getString("TAXNAME");
                    Tax tax = new Tax();
                    tax.setItsId(txId);
                    tax.setItsName(txNm);
                    if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && ((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue())) {
                        if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                            dtTx.getTxs().add(tax);
                            dtTx.getTxTotTaxb().add(recordSet.getDouble("TOTALTAX"));
                            dtTx.getTxTotTaxbFc().add(recordSet.getDouble("FOREIGNTOTALTAXES"));
                            continue;
                        }
                        boolean isNew = true;
                        int li = dtTx.getTxTotTaxb().size() - 1;
                        if (li >= 0 && dtTx.getTxs().get(li).getItsId().equals(tax.getItsId())) {
                            isNew = false;
                        }
                        Double su = recordSet.getDouble("SUBTOTAL");
                        Double suf = recordSet.getDouble("FOREIGNSUBTOTAL");
                        Double pr = recordSet.getDouble("ITSPERCENTAGE");
                        if (isNew) {
                            dtTx.getTxs().add(tax);
                            dtTx.getTxTotTaxb().add(su);
                            dtTx.getTxTotTaxbFc().add(suf);
                            dtTx.getTxPerc().add(pr);
                        } else {
                            Double sut = su + dtTx.getTxTotTaxb().get(li);
                            dtTx.getTxTotTaxb().set(li, sut);
                            Double sutf = suf + dtTx.getTxTotTaxbFc().get(li);
                            dtTx.getTxTotTaxbFc().set(li, sutf);
                        }
                        Long tcId = recordSet.getLong("TAXCATID");
                        this.addInvBsTxExTxc(dtTx.getTxdLns(), tcId, su, suf, pr, pAs, pTxRules);
                        continue;
                    }
                    Double percent = recordSet.getDouble("ITSPERCENTAGE");
                    Long tcId = recordSet.getLong("TAXCATID");
                    if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                        Long clId = recordSet.getLong("ILID");
                        SalesInvoiceServiceLine txdLn = this.makeTxdLine(dtTx.getTxdLns(), clId, tcId, tax, percent, pAs);
                        txdLn.setTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                        txdLn.setForeignTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTALTAXES")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                        continue;
                    }
                    SalesInvoiceServiceLine txdLn = this.makeTxdLine(dtTx.getTxdLns(), tcId, tcId, tax, percent, pAs);
                    txdLn.setItsTotal(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                    txdLn.setSubtotal(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                    txdLn.setForeignTotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                    txdLn.setForeignSubtotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNSUBTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                } while (recordSet.moveToNext());
            }
        }
        return dtTx;
    }

    public final void addInvBsTxExTxc(List<SalesInvoiceServiceLine> pTxdLns, Long pCatId, Double pSubt, Double pSubtFc, Double pPercent, AccSettings pAs, TaxDestination pTxRules) {
        SalesInvoiceServiceLine txdLn = null;
        for (SalesInvoiceServiceLine tdl : pTxdLns) {
            if (!tdl.getItsId().equals(pCatId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new SalesInvoiceServiceLine();
            txdLn.setItsId(pCatId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            txdLn.setTaxCategory(tc);
            pTxdLns.add(txdLn);
        }
        BigDecimal bd100 = new BigDecimal("100.00");
        BigDecimal txv = BigDecimal.valueOf(pSubt).multiply(BigDecimal.valueOf(pPercent)).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
        txdLn.setTotalTaxes(txdLn.getTotalTaxes().add(txv));
        BigDecimal txvf = BigDecimal.valueOf(pSubtFc).multiply(BigDecimal.valueOf(pPercent)).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
        txdLn.setForeignTotalTaxes(txdLn.getForeignTotalTaxes().add(txvf));
    }

    public final SalesInvoiceServiceLine makeTxdLine(List<SalesInvoiceServiceLine> pTxdLns, Long pTdlId, Long pCatId, Tax pTax, Double pPercent, AccSettings pAs) {
        SalesInvoiceServiceLine txdLn = null;
        for (SalesInvoiceServiceLine tdl : pTxdLns) {
            if (!tdl.getItsId().equals(pTdlId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new SalesInvoiceServiceLine();
            txdLn.setItsId(pTdlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            txdLn.setTaxCategory(tc);
            pTxdLns.add(txdLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        itcl.setTax(pTax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        txdLn.getTaxCategory().getTaxes().add(itcl);
        txdLn.getTaxCategory().setAggrOnlyPercent(txdLn.getTaxCategory().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return txdLn;
    }

    public final <T extends IInvoice, L extends IInvoiceLine<T>, LTL extends ALineTxLn<T, L>> List<LTL> mkLnTxItBasNonAggr(Map<String, Object> pReqVars, L pLine, AccSettings pAs, TaxDestination pTxRules, IInvTxMeth<T, ?> pInvTxMeth, IInvLnTxMeth<T, L, LTL> pInvLnTxMeth) throws Exception {
        ArrayList<ALineTxLn> itls = new ArrayList<ALineTxLn>();
        BigDecimal totTxs = BigDecimal.ZERO;
        BigDecimal totTxsFc = BigDecimal.ZERO;
        BigDecimal bd100 = new BigDecimal("100.00");
        pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
        List<InvItemTaxCategoryLine> itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pLine.getTaxCategory().getItsId() + " order by INVITEMTAXCATEGORYLINE.ITSPERCENTAGE");
        pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
        BigDecimal taxTot = null;
        BigDecimal taxRest = null;
        BigDecimal taxTotFc = null;
        BigDecimal taxRestFc = null;
        if (((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
            taxRest = taxTot = pLine.getItsTotal().subtract(pLine.getItsTotal().divide(BigDecimal.ONE.add(pLine.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
            if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                taxRestFc = taxTotFc = pLine.getForeignTotal().subtract(pLine.getForeignTotal().divide(BigDecimal.ONE.add(pLine.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
            }
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (InvItemTaxCategoryLine itcl : itcls) {
            BigDecimal addTx;
            if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
            if (i++ > 0) {
                sb.append(", ");
            }
            ALineTxLn itl = (ALineTxLn)pInvLnTxMeth.getFctLineTxLn().create(pReqVars);
            itl.setIsNew(true);
            itl.setTax(itcl.getTax());
            itls.add(itl);
            BigDecimal addTxFc = null;
            if (((IInvoice)pLine.getItsOwner()).getPriceIncTax().booleanValue()) {
                if (i < itcls.size()) {
                    addTx = taxTot.multiply(itcl.getItsPercentage()).divide(pLine.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                    taxRest = taxRest.subtract(addTx);
                } else {
                    addTx = taxRest;
                }
                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                    if (i < itcls.size()) {
                        addTxFc = taxTotFc.multiply(itcl.getItsPercentage()).divide(pLine.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                        taxRestFc = taxRestFc.subtract(addTxFc);
                    } else {
                        addTxFc = taxRestFc;
                    }
                }
            } else {
                addTx = pLine.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                    addTxFc = pLine.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                }
            }
            totTxs = totTxs.add(addTx);
            itl.setItsTotal(addTx);
            if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() != null) {
                totTxsFc = totTxsFc.add(addTxFc);
                itl.setForeignTotalTaxes(addTxFc);
            }
            sb.append(itl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
        }
        pLine.setTaxesDescription(sb.toString());
        this.mkLnFinal(pLine, totTxs, totTxsFc, ((IInvoice)pLine.getItsOwner()).getPriceIncTax());
        return itls;
    }

    public final <T extends IInvoice, L extends IInvoiceLine<T>> void mkLnFinal(L pLine, BigDecimal pTotTxs, BigDecimal pTotTxsFc, Boolean pIsTxByUser) {
        if (pIsTxByUser.booleanValue()) {
            if (((IInvoice)pLine.getItsOwner()).getForeignCurrency() == null) {
                if (pLine.getTotalTaxes().compareTo(pTotTxs) != 0) {
                    if (pLine.getDescription() == null) {
                        pLine.setDescription(pLine.getTotalTaxes().toString() + "!=" + pTotTxs + "!");
                    } else {
                        pLine.setDescription(pLine.getDescription() + " " + pLine.getTotalTaxes().toString() + "!=" + pTotTxs + "!");
                    }
                }
            } else {
                pLine.setTotalTaxes(pTotTxs);
                if (pLine.getForeignTotalTaxes().compareTo(pTotTxsFc) != 0) {
                    if (pLine.getDescription() == null) {
                        pLine.setDescription(pLine.getForeignTotalTaxes().toString() + "!=" + pTotTxsFc + "!");
                    } else {
                        pLine.setDescription(pLine.getDescription() + " " + pLine.getForeignTotalTaxes().toString() + "!=" + pTotTxsFc + "!");
                    }
                }
            }
        } else {
            pLine.setTotalTaxes(pTotTxs);
            pLine.setForeignTotalTaxes(pTotTxsFc);
        }
    }

    public final <T extends IInvoice, TL extends AInvTxLn<T>> TL findCreateTaxLine(Map<String, Object> pReqVars, T pInv, List<TL> pInvTxLns, Tax pTax, boolean pNeedFind, IFactorySimple<TL> pFctInvTxLn) throws Exception {
        AInvTxLn itl = null;
        for (AInvTxLn tl : pInvTxLns) {
            if (tl.getTax() == null || !tl.getTax().getItsId().equals(pTax.getItsId())) continue;
            if (!pNeedFind) {
                throw new Exception("Algorithm error!!!");
            }
            itl = tl;
            break;
        }
        for (AInvTxLn tl : pInvTxLns) {
            if (tl.getTax() != null) continue;
            itl = tl;
            itl.setTax(pTax);
            break;
        }
        if (itl == null) {
            itl = (AInvTxLn)pFctInvTxLn.create(pReqVars);
            itl.setItsOwner(pInv);
            itl.setIsNew(true);
            itl.setTax(pTax);
            pInvTxLns.add(itl);
        }
        return (TL)itl;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("decSepv"), (String)pReqVars.get("decGrSepv"), (Integer)pReqVars.get("priceDp"), (Integer)pReqVars.get("digInGr"));
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

