/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.I18nAccounting;
import org.beigesoft.accounting.persistable.I18nCurrency;
import org.beigesoft.accounting.report.IBalanceSheetPdf;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;

public class BalanceSheetPdf<RS, WI>
implements IBalanceSheetPdf {
    private IPdfFactory<WI> pdfFactory;
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;
    private ISrvNumberToString srvNumberToString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void makeReport(Map<String, Object> pAddParam, BalanceSheet pBalance, OutputStream pOus) throws Exception {
        String curSign;
        boolean isPrnCurLf;
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pAddParam);
        String lang = (String)pAddParam.get("lang");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(lang));
        I18nCurrency i18nCurrency = (I18nCurrency)pAddParam.get("i18nCurrency");
        if (i18nCurrency != null) {
            isPrnCurLf = i18nCurrency.getPrintCurrencyLeft();
            curSign = i18nCurrency.getUseCurrencySign().booleanValue() ? i18nCurrency.getHasName().getItsSign() : " " + i18nCurrency.getItsName() + " ";
        } else {
            curSign = (String)pAddParam.get("curSign");
            isPrnCurLf = accSet.getPrintCurrencyLeft();
        }
        Document<WI> doc = this.pdfFactory.lazyGetFctDocument().createDoc(accSet.getPageSize(), accSet.getPageOrientation());
        doc.setFontSize(accSet.getFontSize());
        doc.getPages().get(0).setMarginBottom(accSet.getMarginBottom());
        doc.getPages().get(0).setMarginTop(accSet.getMarginTop());
        doc.getPages().get(0).setMarginLeft(accSet.getMarginLeft());
        doc.getPages().get(0).setMarginRight(accSet.getMarginRight());
        PdfDocument<WI> docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker<WI> docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker<WI> pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, accSet.getTtfFileName());
        if (accSet.getTtfBoldFileName() != null) {
            pdfMaker.addFontTtf(docPdf, accSet.getTtfBoldFileName());
        }
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContainerMarginBottom(this.mmToDocUom(3.5, doc.getUnitOfMeasure()));
        doc.setContentPaddingBottom(this.mmToDocUom(0.5, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.CENTER);
        DocTable<WI> tblTitle = docMaker.addDocTableNoBorder(doc, 1, 3);
        I18nAccounting i18nAccounting = (I18nAccounting)pAddParam.get("i18nAccounting");
        if (i18nAccounting != null) {
            tblTitle.getItsCells().get(0).setItsContent(i18nAccounting.getOrganizationName());
        } else {
            tblTitle.getItsCells().get(0).setItsContent(accSet.getOrganization());
        }
        tblTitle.getItsCells().get(1).setItsContent(this.srvI18n.getMsg("balance_sheet", lang));
        tblTitle.getItsCells().get(2).setItsContent(dateFormat.format(pBalance.getItsDate()));
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        docMaker.makeDocTableWrapping(tblTitle);
        doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.LEFT);
        DocTable<WI> tblBal = docMaker.addDocTable(doc, 4, pBalance.getDetailRowsCount() + 2);
        tblBal.getItsColumns().get(0).setIsWidthFixed(true);
        tblBal.getItsColumns().get(0).setWidthInPercentage(30.0);
        tblBal.getItsColumns().get(1).setIsWidthFixed(true);
        tblBal.getItsColumns().get(1).setWidthInPercentage(20.0);
        tblBal.getItsColumns().get(2).setIsWidthFixed(true);
        tblBal.getItsColumns().get(2).setWidthInPercentage(30.0);
        tblBal.getItsColumns().get(3).setIsWidthFixed(true);
        tblBal.getItsColumns().get(3).setWidthInPercentage(20.0);
        tblBal.getItsCells().get(0).setItsContent(this.srvI18n.getMsg("AssetsTitle", lang));
        tblBal.getItsCells().get(0).setMergedCell(tblBal.getItsCells().get(1));
        tblBal.getItsCells().get(2).setItsContent(this.srvI18n.getMsg("LiabilitiesTitle", lang));
        tblBal.getItsCells().get(2).setMergedCell(tblBal.getItsCells().get(3));
        int row = 1;
        for (int i = 0; i < pBalance.getTotalLinesAssets(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getDebit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) + ")";
            tblBal.getItsCells().get(row * 4).setItsContent(pBalance.getItsLines().get(i).getAccName());
            tblBal.getItsCells().get(row * 4).setFontNumber(1);
            tblBal.getItsCells().get(row * 4 + 1).setItsContent(cnt);
            tblBal.getItsCells().get(row * 4 + 1).setAlignHorizontal(EAlignHorizontal.RIGHT);
            tblBal.getItsCells().get(row * 4 + 1).setFontNumber(1);
            ++row;
        }
        int totLeabOwnEq = pBalance.getTotalLinesLiabilities() + pBalance.getTotalLinesOwnersEquity();
        int lastRowIdx = Math.max(pBalance.getTotalLinesAssets() + 1, totLeabOwnEq + 4);
        tblBal.getItsCells().get(lastRowIdx * 4).setItsContent(this.srvI18n.getMsg("total_assets", lang));
        tblBal.getItsCells().get(lastRowIdx * 4 + 1).setAlignHorizontal(EAlignHorizontal.RIGHT);
        String cntc = isPrnCurLf ? curSign + this.prn(pAddParam, pBalance.getTotalAssets()) : this.prn(pAddParam, pBalance.getTotalAssets()) + curSign;
        tblBal.getItsCells().get(lastRowIdx * 4 + 1).setItsContent(cntc);
        row = 1;
        int totAssLeab = pBalance.getTotalLinesAssets() + pBalance.getTotalLinesLiabilities();
        for (int i = pBalance.getTotalLinesAssets().intValue(); i < totAssLeab; ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) + ")";
            tblBal.getItsCells().get(row * 4 + 2).setItsContent(pBalance.getItsLines().get(i).getAccName());
            tblBal.getItsCells().get(row * 4 + 2).setFontNumber(1);
            tblBal.getItsCells().get(row * 4 + 3).setItsContent(cnt);
            tblBal.getItsCells().get(row * 4 + 3).setAlignHorizontal(EAlignHorizontal.RIGHT);
            tblBal.getItsCells().get(row * 4 + 3).setFontNumber(1);
            ++row;
        }
        tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 6).setItsContent(this.srvI18n.getMsg("total_l", lang));
        tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7).setAlignHorizontal(EAlignHorizontal.RIGHT);
        tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7).setItsContent(this.prn(pAddParam, pBalance.getTotalLiabilities()));
        int oetIdx = pBalance.getTotalLinesLiabilities() * 4 + 10;
        tblBal.getItsCells().get(oetIdx).setItsContent(this.srvI18n.getMsg("OwnersEquityTitle", lang));
        tblBal.getItsCells().get(oetIdx).setMergedCell(tblBal.getItsCells().get(oetIdx + 1));
        row = 1 + pBalance.getTotalLinesLiabilities() + 2;
        for (int i = totAssLeab; i < totAssLeab + pBalance.getTotalLinesOwnersEquity(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) + ")";
            tblBal.getItsCells().get(row * 4 + 2).setItsContent(pBalance.getItsLines().get(i).getAccName());
            tblBal.getItsCells().get(row * 4 + 2).setFontNumber(1);
            tblBal.getItsCells().get(row * 4 + 3).setItsContent(cnt);
            tblBal.getItsCells().get(row * 4 + 3).setAlignHorizontal(EAlignHorizontal.RIGHT);
            tblBal.getItsCells().get(row * 4 + 3).setFontNumber(1);
            ++row;
        }
        tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 2).setItsContent(this.srvI18n.getMsg("total_oe", lang));
        tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3).setAlignHorizontal(EAlignHorizontal.RIGHT);
        tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3).setItsContent(this.prn(pAddParam, pBalance.getTotalOwnersEquity()));
        tblBal.getItsCells().get(lastRowIdx * 4 + 2).setItsContent(this.srvI18n.getMsg("total_l_oe", lang));
        tblBal.getItsCells().get(lastRowIdx * 4 + 3).setAlignHorizontal(EAlignHorizontal.RIGHT);
        cntc = isPrnCurLf ? curSign + this.prn(pAddParam, pBalance.getTotalOwnersEquity().add(pBalance.getTotalLiabilities())) : this.prn(pAddParam, pBalance.getTotalOwnersEquity().add(pBalance.getTotalLiabilities())) + curSign;
        tblBal.getItsCells().get(lastRowIdx * 4 + 3).setItsContent(cntc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        try {
            this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
        }
        finally {
            pOus.close();
        }
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("decSepv"), (String)pAddParam.get("decGrSepv"), (Integer)pAddParam.get("reportDp"), (Integer)pAddParam.get("digInGr"));
    }

    public final double mmToDocUom(double pValue, EUnitOfMeasure pUom) {
        if (pUom.equals((Object)EUnitOfMeasure.INCH)) {
            return pValue / 25.4;
        }
        return pValue;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

