/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.TrialBalanceLine;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.persistable.BalanceAt;
import org.beigesoft.accounting.persistable.BalanceAtAllDirtyCheck;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.EPeriod;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class SrvBalanceStd<RS>
implements ISrvBalance {
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private BalanceAtAllDirtyCheck balanceAtAllDirtyCheck;
    private String queryBalance;
    private final long initDateLong = 157766400000L;
    private final Date initDate = new Date(this.initDateLong);

    public SrvBalanceStd() {
    }

    public SrvBalanceStd(ISrvOrm<RS> pSrvOrm, ISrvDatabase<RS> pSrvDatabase, ISrvAccSettings pSrvAccSettings, ILogger pLogger) {
        this.logger = pLogger;
        this.srvDatabase = pSrvDatabase;
        this.srvOrm = pSrvOrm;
        this.srvAccSettings = pSrvAccSettings;
    }

    @Override
    public final synchronized void changeBalanceStorePeriod(Map<String, Object> pAddParam, EPeriod pPeriod) throws Exception {
        if (pPeriod == null) {
            throw new ExceptionWithCode(1003, "null_not_accepted");
        }
        if (!this.lazyGetBalanceAtAllDirtyCheck(pAddParam).getBalanceStorePeriod().equals((Object)pPeriod)) {
            this.getLogger().info(null, SrvBalanceStd.class, "changing period from " + (Object)((Object)this.balanceAtAllDirtyCheck.getBalanceStorePeriod()) + " to " + (Object)((Object)pPeriod));
            this.balanceAtAllDirtyCheck.setBalanceStorePeriod(pPeriod);
            if (!this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalanceStorePeriod().equals((Object)pPeriod)) {
                this.getSrvAccSettings().lazyGetAccSettings(pAddParam).setBalanceStorePeriod(pPeriod);
                this.getSrvAccSettings().saveAccSettings(pAddParam, this.getSrvAccSettings().lazyGetAccSettings(pAddParam));
            }
            this.balanceAtAllDirtyCheck.setCurrentBalanceDate(this.initDate);
            this.balanceAtAllDirtyCheck.setIsPeriodChanged(true);
            this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        }
    }

    @Override
    public final synchronized EPeriod evalBalanceStorePeriod(Map<String, Object> pAddParam) throws Exception {
        if (!this.lazyGetBalanceAtAllDirtyCheck(pAddParam).getBalanceStorePeriod().equals((Object)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalanceStorePeriod())) {
            this.getLogger().info(null, SrvBalanceStd.class, "changing period from " + (Object)((Object)this.balanceAtAllDirtyCheck.getBalanceStorePeriod()) + " to " + (Object)((Object)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalanceStorePeriod()));
            this.balanceAtAllDirtyCheck.setBalanceStorePeriod(this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalanceStorePeriod());
            this.balanceAtAllDirtyCheck.setIsPeriodChanged(true);
            this.balanceAtAllDirtyCheck.setCurrentBalanceDate(this.initDate);
            this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        }
        return this.balanceAtAllDirtyCheck.getBalanceStorePeriod();
    }

    @Override
    public final synchronized BalanceAt evalBalanceAt(Map<String, Object> pAddParam, Account pAcc, Long pSubaccId, Date pDateFor) throws Exception {
        return null;
    }

    @Override
    public final synchronized void handleNewAccountEntry(Map<String, Object> pAddParam, Account pAcc, Long pSubaccId, Date pDateAt) throws Exception {
        if (this.lazyGetBalanceAtAllDirtyCheck(pAddParam).getLeastAccountingEntryDate().getTime() > pDateAt.getTime()) {
            if (this.getLogger().getIsShowDebugMessagesFor(this.getClass())) {
                this.getLogger().debug(null, SrvBalanceStd.class, "changing least last entry date from " + this.balanceAtAllDirtyCheck.getLeastAccountingEntryDate() + " to " + pDateAt);
            }
            this.balanceAtAllDirtyCheck.setLeastAccountingEntryDate(pDateAt);
            this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        }
    }

    @Override
    public final synchronized void recalculateAllIfNeed(Map<String, Object> pAddParam, Date pDateFor) throws Exception {
        this.evalBalanceStorePeriod(pAddParam);
        this.evalDateBalanceStoreStart(pAddParam);
        Date datePeriodStartFor = this.evalDatePeriodStartFor(pAddParam, pDateFor);
        Calendar calCurrYear = Calendar.getInstance(new Locale("en", "US"));
        calCurrYear.setTime(this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCurrentAccYear());
        calCurrYear.set(2, 0);
        calCurrYear.set(5, 1);
        calCurrYear.set(11, 0);
        calCurrYear.set(12, 0);
        calCurrYear.set(13, 0);
        calCurrYear.set(14, 0);
        Calendar calStBl = Calendar.getInstance(new Locale("en", "US"));
        calStBl.setTime(this.balanceAtAllDirtyCheck.getDateBalanceStoreStart());
        calStBl.set(2, 0);
        calStBl.set(5, 1);
        calStBl.set(11, 0);
        calStBl.set(12, 0);
        calStBl.set(13, 0);
        calStBl.set(14, 0);
        if (calCurrYear.getTime().getTime() < calStBl.getTime().getTime() || this.balanceAtAllDirtyCheck.getLeastAccountingEntryDate().getTime() < this.balanceAtAllDirtyCheck.getDateBalanceStoreStart().getTime()) {
            this.balanceAtAllDirtyCheck.setCurrentBalanceDate(this.initDate);
            this.balanceAtAllDirtyCheck.setDateBalanceStoreStart(this.initDate);
            this.evalDateBalanceStoreStart(pAddParam);
            this.recalculateAll(pAddParam, pDateFor, false);
        } else if (datePeriodStartFor.getTime() > this.balanceAtAllDirtyCheck.getCurrentBalanceDate().getTime() || this.balanceAtAllDirtyCheck.getLeastAccountingEntryDate().getTime() < this.balanceAtAllDirtyCheck.getCurrentBalanceDate().getTime()) {
            this.recalculateAll(pAddParam, pDateFor, false);
        }
    }

    @Override
    public final synchronized void recalculateFor(Map<String, Object> pAddParam, Account pAcc, Long pSubaccId, Date pDateFor) throws Exception {
    }

    @Override
    public final synchronized void recalculateAll(Map<String, Object> pAddParam, Date pDateFor, boolean pIsPrepareNeed) throws Exception {
        Date date;
        this.getLogger().info(null, SrvBalanceStd.class, "recalculation start BalanceAtAllDirtyCheck was " + this.lazyGetBalanceAtAllDirtyCheck(pAddParam));
        if (pIsPrepareNeed) {
            this.evalBalanceStorePeriod(pAddParam);
            this.evalDateBalanceStoreStart(pAddParam);
        }
        if (this.balanceAtAllDirtyCheck.getIsPeriodChanged().booleanValue()) {
            this.getLogger().info(null, SrvBalanceStd.class, "deleting all stored balances cause period has changed");
            this.getSrvDatabase().executeDelete(BalanceAt.class.getSimpleName().toUpperCase(), null);
            this.balanceAtAllDirtyCheck.setIsPeriodChanged(false);
        }
        if (this.balanceAtAllDirtyCheck.getLeastAccountingEntryDate().getTime() < this.balanceAtAllDirtyCheck.getCurrentBalanceDate().getTime()) {
            date = this.evalDateNextPeriodStart(pAddParam, this.balanceAtAllDirtyCheck.getDateBalanceStoreStart());
            this.getLogger().info(null, SrvBalanceStd.class, "recalculating balances from start " + date + " <- " + this.balanceAtAllDirtyCheck.getDateBalanceStoreStart());
        } else {
            date = this.evalDateNextPeriodStart(pAddParam, this.balanceAtAllDirtyCheck.getCurrentBalanceDate());
            this.getLogger().info(null, SrvBalanceStd.class, "recalculating balances from current end " + date + " <- " + this.balanceAtAllDirtyCheck.getCurrentBalanceDate());
        }
        Date lastBalanceStoredDate = date;
        do {
            String query = this.evalQueryBalance(pAddParam, new Date(date.getTime() - 1L));
            List<TrialBalanceLine> tbls = this.retrieveBalanceLinesForStore(query);
            for (TrialBalanceLine tbl : tbls) {
                lastBalanceStoredDate = date;
                String subAccWhereStr = tbl.getSubaccId() == null ? " and SUBACCID is null and BALANCEAT.SUBACCTYPE is null" : " and SUBACCID=" + tbl.getSubaccId() + " and BALANCEAT.SUBACCTYPE=" + tbl.getSubaccType();
                BalanceAt balanceAt = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, BalanceAt.class, "where ITSACCOUNT='" + tbl.getAccId() + "' and ITSDATE=" + date.getTime() + subAccWhereStr);
                if (balanceAt == null) {
                    balanceAt = new BalanceAt();
                    balanceAt.setIsNew(true);
                }
                balanceAt.setItsDate(date);
                Account acc = new Account();
                acc.setItsId(tbl.getAccId());
                balanceAt.setItsAccount(acc);
                if (tbl.getDebit().doubleValue() != 0.0) {
                    balanceAt.setItsBalance(tbl.getDebit());
                } else {
                    balanceAt.setItsBalance(tbl.getCredit());
                }
                balanceAt.setSubaccType(tbl.getSubaccType());
                balanceAt.setSubaccId(tbl.getSubaccId());
                balanceAt.setSubaccount(tbl.getSubaccName());
                if (balanceAt.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pAddParam, balanceAt);
                    balanceAt.setIsNew(false);
                    continue;
                }
                this.getSrvOrm().updateEntity(pAddParam, balanceAt);
            }
        } while ((date = this.evalDateNextPeriodStart(pAddParam, date)).getTime() <= pDateFor.getTime());
        this.getLogger().info(null, SrvBalanceStd.class, "last stored balance date " + lastBalanceStoredDate + ", date for " + pDateFor);
        if (lastBalanceStoredDate.getTime() > pDateFor.getTime()) {
            this.balanceAtAllDirtyCheck.setCurrentBalanceDate(lastBalanceStoredDate);
        } else {
            this.balanceAtAllDirtyCheck.setCurrentBalanceDate(pDateFor);
        }
        this.balanceAtAllDirtyCheck.setLeastAccountingEntryDate(this.balanceAtAllDirtyCheck.getCurrentBalanceDate());
        this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        this.getLogger().info(null, SrvBalanceStd.class, "recalculation end BalanceAtAllDirtyCheck is " + this.balanceAtAllDirtyCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized List<TrialBalanceLine> retrieveTrialBalance(Map<String, Object> pAddParam, Date pDate) throws Exception {
        this.recalculateAllIfNeed(pAddParam, pDate);
        ArrayList<TrialBalanceLine> result = new ArrayList<TrialBalanceLine>();
        String query = this.evalQueryBalance(pAddParam, pDate);
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    String accName = recordSet.getString("ITSNAME");
                    String accNumber = recordSet.getString("ITSNUMBER");
                    String subaccName = recordSet.getString("SUBACC");
                    Double debit = recordSet.getDouble("DEBIT");
                    Double credit = recordSet.getDouble("CREDIT");
                    if (debit == 0.0 && credit == 0.0) continue;
                    TrialBalanceLine tbl = new TrialBalanceLine();
                    tbl.setAccName(accName);
                    tbl.setAccNumber(accNumber);
                    tbl.setSubaccName(subaccName);
                    tbl.setDebit(BigDecimal.valueOf(debit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalancePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    tbl.setCredit(BigDecimal.valueOf(credit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalancePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (tbl.getDebit().doubleValue() == 0.0 && tbl.getCredit().doubleValue() == 0.0) continue;
                    result.add(tbl);
                } while (recordSet.moveToNext());
            }
        }
        BigDecimal debitAcc = BigDecimal.ZERO;
        BigDecimal creditAcc = BigDecimal.ZERO;
        String accCurr = null;
        int lineCurr = 0;
        int lineStartAcc = 0;
        for (TrialBalanceLine tbl : result) {
            if (!tbl.getAccNumber().equals(accCurr)) {
                if (accCurr != null) {
                    for (int j = lineStartAcc; j < lineCurr; ++j) {
                        ((TrialBalanceLine)result.get(j)).setDebitAcc(debitAcc);
                        ((TrialBalanceLine)result.get(j)).setCreditAcc(creditAcc);
                    }
                }
                lineStartAcc = lineCurr;
                accCurr = tbl.getAccNumber();
            }
            debitAcc = debitAcc.add(tbl.getDebit());
            creditAcc = creditAcc.add(tbl.getCredit());
            ++lineCurr;
        }
        return result;
    }

    @Override
    public final synchronized Date evalDatePeriodStartFor(Map<String, Object> pAddParam, Date pDateFor) throws Exception {
        EPeriod period = this.evalBalanceStorePeriod(pAddParam);
        if (!(period.equals((Object)EPeriod.MONTHLY) || period.equals((Object)EPeriod.WEEKLY) || period.equals((Object)EPeriod.DAILY))) {
            throw new ExceptionWithCode(1003, "stored_balance_period_must_be_dwm");
        }
        Calendar cal = Calendar.getInstance(new Locale("en", "US"));
        cal.setTime(pDateFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (period.equals((Object)EPeriod.MONTHLY)) {
            cal.set(5, 1);
        } else if (period.equals((Object)EPeriod.WEEKLY)) {
            cal.set(7, 1);
        }
        return cal.getTime();
    }

    public final synchronized Date evalDateBalanceStoreStart(Map<String, Object> pAddParam) throws Exception {
        Date dateBalanceStoreStart = this.lazyGetBalanceAtAllDirtyCheck(pAddParam).getDateBalanceStoreStart();
        Date leastAccountingEntryDate = this.balanceAtAllDirtyCheck.getLeastAccountingEntryDate();
        if (dateBalanceStoreStart.getTime() == this.initDateLong && leastAccountingEntryDate.getTime() == this.initDateLong) {
            Calendar cal = Calendar.getInstance(new Locale("en", "US"));
            cal.setTime(this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCurrentAccYear());
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.balanceAtAllDirtyCheck.setDateBalanceStoreStart(cal.getTime());
            this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        } else if (dateBalanceStoreStart.getTime() == this.initDateLong && leastAccountingEntryDate.getTime() > this.initDateLong) {
            Long dateFirstEntryLong = this.srvDatabase.evalLongResult("select min(ITSDATE) as MINIMUMDATE from ACCOUNTINGENTRY where REVERSEDID is null;", "MINIMUMDATE");
            if (dateFirstEntryLong == null) {
                this.getLogger().info(null, SrvBalanceStd.class, "There is no single acc entry, so use current acc year for start balance!");
                Calendar cal = Calendar.getInstance(new Locale("en", "US"));
                cal.setTime(this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCurrentAccYear());
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                this.balanceAtAllDirtyCheck.setDateBalanceStoreStart(cal.getTime());
            } else {
                this.balanceAtAllDirtyCheck.setDateBalanceStoreStart(this.evalDatePeriodStartFor(pAddParam, new Date(dateFirstEntryLong)));
            }
            this.getSrvOrm().updateEntity(pAddParam, this.balanceAtAllDirtyCheck);
        }
        return this.balanceAtAllDirtyCheck.getDateBalanceStoreStart();
    }

    public final synchronized String evalQueryBalance(Map<String, Object> pAddParam, Date pDate) throws Exception {
        if (this.queryBalance == null) {
            String flName = "/accounting/balance/queryBalanceSl.sql";
            this.queryBalance = this.loadString(flName);
        }
        String query = this.queryBalance.replace(":DATE1", String.valueOf(this.evalDatePeriodStartFor(pAddParam, pDate).getTime()));
        query = query.replace(":DATE2", String.valueOf(pDate.getTime()));
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List<TrialBalanceLine> retrieveBalanceLines(Map<String, Object> pAddParam, String pQuery) throws Exception {
        ArrayList<TrialBalanceLine> result = new ArrayList<TrialBalanceLine>();
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                do {
                    String accName = recordSet.getString("ITSNAME");
                    String accId = recordSet.getString("ACCID");
                    Long subaccId = recordSet.getLong("SUBACCID");
                    Integer subaccType = recordSet.getInteger("SUBACCTYPE");
                    String accNumber = recordSet.getString("ITSNUMBER");
                    String subaccName = recordSet.getString("SUBACC");
                    Double debit = recordSet.getDouble("DEBIT");
                    Double credit = recordSet.getDouble("CREDIT");
                    if (debit == 0.0 && credit == 0.0) continue;
                    TrialBalanceLine tbl = new TrialBalanceLine();
                    tbl.setAccId(accId);
                    tbl.setSubaccId(subaccId);
                    tbl.setSubaccType(subaccType);
                    tbl.setAccName(accName);
                    tbl.setAccNumber(accNumber);
                    tbl.setSubaccName(subaccName);
                    tbl.setDebit(BigDecimal.valueOf(debit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    tbl.setCredit(BigDecimal.valueOf(credit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (tbl.getDebit().doubleValue() == 0.0 && tbl.getCredit().doubleValue() == 0.0) continue;
                    result.add(tbl);
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List<TrialBalanceLine> retrieveBalanceLinesForStore(String pQuery) throws Exception {
        ArrayList<TrialBalanceLine> result = new ArrayList<TrialBalanceLine>();
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                do {
                    String accName = recordSet.getString("ITSNAME");
                    String accId = recordSet.getString("ACCID");
                    Long subaccId = recordSet.getLong("SUBACCID");
                    Integer subaccType = recordSet.getInteger("SUBACCTYPE");
                    String accNumber = recordSet.getString("ITSNUMBER");
                    String subaccName = recordSet.getString("SUBACC");
                    Double debit = recordSet.getDouble("DEBIT");
                    Double credit = recordSet.getDouble("CREDIT");
                    TrialBalanceLine tbl = new TrialBalanceLine();
                    tbl.setAccId(accId);
                    tbl.setSubaccId(subaccId);
                    tbl.setSubaccType(subaccType);
                    tbl.setAccName(accName);
                    tbl.setAccNumber(accNumber);
                    tbl.setSubaccName(subaccName);
                    tbl.setDebit(BigDecimal.valueOf(debit));
                    tbl.setCredit(BigDecimal.valueOf(credit));
                    result.add(tbl);
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadString(String pFileName) throws IOException {
        URL urlFile = SrvBalanceStd.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvBalanceStd.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final synchronized BalanceAtAllDirtyCheck lazyGetBalanceAtAllDirtyCheck(Map<String, Object> pAddParam) throws Exception {
        if (this.balanceAtAllDirtyCheck == null) {
            BalanceAtAllDirtyCheck balLoc = new BalanceAtAllDirtyCheck();
            balLoc.setItsId(1L);
            this.balanceAtAllDirtyCheck = this.getSrvOrm().retrieveEntity(pAddParam, balLoc);
            if (this.balanceAtAllDirtyCheck == null) {
                this.getSrvOrm().insertEntity(pAddParam, balLoc);
                balLoc.setIsNew(false);
                this.balanceAtAllDirtyCheck = this.getSrvOrm().retrieveEntity(pAddParam, balLoc);
            }
        }
        return this.balanceAtAllDirtyCheck;
    }

    public final synchronized Date evalDateNextPeriodStart(Map<String, Object> pAddParam, Date pDateFor) throws Exception {
        EPeriod period = this.evalBalanceStorePeriod(pAddParam);
        if (!(period.equals((Object)EPeriod.MONTHLY) || period.equals((Object)EPeriod.WEEKLY) || period.equals((Object)EPeriod.DAILY))) {
            throw new ExceptionWithCode(1003, "stored_balance_period_must_be_dwm");
        }
        Calendar cal = Calendar.getInstance(new Locale("en", "US"));
        cal.setTime(pDateFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (period.equals((Object)EPeriod.DAILY)) {
            cal.add(5, 1);
        } else if (period.equals((Object)EPeriod.MONTHLY)) {
            cal.add(2, 1);
            cal.set(5, 1);
        } else if (period.equals((Object)EPeriod.WEEKLY)) {
            cal.add(6, 7);
            cal.set(7, 1);
        }
        return cal.getTime();
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final synchronized void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final synchronized String getQueryBalance() {
        return this.queryBalance;
    }

    public final synchronized void setQueryBalance(String pQueryBalance) {
        this.queryBalance = pQueryBalance;
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

