/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.EmployeeYearWage;
import org.beigesoft.accounting.persistable.Wage;
import org.beigesoft.accounting.persistable.WageLine;
import org.beigesoft.accounting.persistable.WageTaxLine;
import org.beigesoft.accounting.persistable.WageTaxTable;
import org.beigesoft.accounting.persistable.WageTaxTableEmployee;
import org.beigesoft.accounting.persistable.WageTaxTableLine;
import org.beigesoft.accounting.persistable.WageTaxTableType;
import org.beigesoft.accounting.persistable.WageType;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvFillWageLines;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class SrvWageTaxPercentageTable<RS>
implements ISrvFillWageLines {
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;

    public SrvWageTaxPercentageTable() {
    }

    public SrvWageTaxPercentageTable(ISrvOrm<RS> pSrvOrm, ISrvDatabase<RS> pSrvDatabase, ISrvAccSettings pSrvAccSettings) {
        this.srvDatabase = pSrvDatabase;
        this.srvOrm = pSrvOrm;
        this.srvAccSettings = pSrvAccSettings;
    }

    @Override
    public final void fillWageLines(Map<String, Object> pAddParam, Wage pWage) throws Exception {
        List<WageTaxTableEmployee> wttel = this.getSrvOrm().retrieveListWithConditions(pAddParam, WageTaxTableEmployee.class, "where EMPLOYEE=" + pWage.getEmployee().getItsId());
        if (wttel != null && wttel.size() > 0) {
            String queryTotalWageYear = "select sum(TOTALWAGEYEAR) as TOTALWAGEYEAR from " + EmployeeYearWage.class.getSimpleName().toUpperCase() + " where ITSOWNER=" + pWage.getEmployee().getItsId();
            Double totalWageYearDbl = this.getSrvDatabase().evalDoubleResult(queryTotalWageYear, "TOTALWAGEYEAR");
            if (totalWageYearDbl == null) {
                totalWageYearDbl = 0.0;
            }
            BigDecimal totalWageYear = BigDecimal.valueOf(totalWageYearDbl);
            this.getSrvOrm().deleteEntityWhere(pAddParam, WageTaxLine.class, "ITSOWNER=" + pWage.getItsId());
            BigDecimal bigDecimal100 = new BigDecimal("100.00");
            BigDecimal totalTaxesEmployee = BigDecimal.ZERO;
            BigDecimal totalTaxesEmployer = BigDecimal.ZERO;
            WageLine wlfr = new WageLine();
            wlfr.setItsOwner(pWage);
            String ownerFldName = "itsOwner";
            pWage.setItsLines(this.getSrvOrm().retrieveListForField(pAddParam, wlfr, ownerFldName));
            HashMap<WageType, BigDecimal> empleeTotTaxLnMap = new HashMap<WageType, BigDecimal>();
            for (WageLine wl : pWage.getItsLines()) {
                empleeTotTaxLnMap.put(wl.getWageType(), BigDecimal.ZERO);
            }
            for (WageTaxTableEmployee wtte : wttel) {
                wtte.getItsOwner().setTax(this.getSrvOrm().retrieveEntity(pAddParam, wtte.getItsOwner().getTax()));
                WageTaxTableLine wttlfr = new WageTaxTableLine();
                wttlfr.setItsOwner(wtte.getItsOwner());
                wtte.getItsOwner().setItsLines(this.getSrvOrm().retrieveListForField(pAddParam, wttlfr, ownerFldName));
                WageTaxTableType wttt = new WageTaxTableType();
                wttt.setItsOwner(wtte.getItsOwner());
                wtte.getItsOwner().setWageTypes(this.getSrvOrm().retrieveListForField(pAddParam, wttt, ownerFldName));
                BigDecimal totalTaxableForTax = BigDecimal.ZERO;
                for (WageLine wl : pWage.getItsLines()) {
                    if (!this.isWageApplied(wl.getWageType(), wtte.getItsOwner())) continue;
                    totalTaxableForTax = totalTaxableForTax.add(wl.getGrossWage());
                }
                if (!(totalTaxableForTax.doubleValue() > 0.0)) continue;
                BigDecimal wageMinusAllowance = totalTaxableForTax.subtract(wtte.getAllowance());
                boolean isFilled = false;
                for (WageTaxTableLine wttl : wtte.getItsOwner().getItsLines()) {
                    if (wageMinusAllowance.compareTo(wttl.getWageFrom()) < 0 || wageMinusAllowance.compareTo(wttl.getWageTo()) >= 0 || totalWageYear.compareTo(wttl.getYearWageFrom()) < 0 || totalWageYear.compareTo(wttl.getYearWageTo()) >= 0) continue;
                    WageTaxLine wtl = new WageTaxLine();
                    wtl.setIsNew(true);
                    wtl.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    wtl.setItsOwner(pWage);
                    wtl.setAllowance(wtte.getAllowance());
                    wtl.setPlusAmount(wttl.getPlusAmount());
                    wtl.setTax(wtte.getItsOwner().getTax());
                    wtl.setItsPercentage(wttl.getItsPercentage());
                    wtl.setItsTotal(wageMinusAllowance.subtract(wttl.getAllowance()).multiply(wttl.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()).add(wttl.getPlusAmount()));
                    wtl.setDescription("TableID/Name/taxable: " + wtte.getItsOwner().getItsId() + "/" + wtte.getItsOwner().getItsName() + "/" + totalTaxableForTax);
                    this.getSrvOrm().insertEntity(pAddParam, wtl);
                    wtl.setIsNew(false);
                    if (wtl.getTax().getItsType().equals((Object)ETaxType.EMPLOYMENT_TAX_EMPLOYEE)) {
                        totalTaxesEmployee = totalTaxesEmployee.add(wtl.getItsTotal());
                        for (WageLine wl : pWage.getItsLines()) {
                            BigDecimal newTotalTaxEmpleeLn = ((BigDecimal)empleeTotTaxLnMap.get(wl.getWageType())).add(wl.getGrossWage().multiply(wtl.getItsTotal()).divide(totalTaxableForTax, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                            empleeTotTaxLnMap.put(wl.getWageType(), newTotalTaxEmpleeLn);
                        }
                    } else if (wtl.getTax().getItsType().equals((Object)ETaxType.EMPLOYMENT_TAX_EMPLOYER)) {
                        totalTaxesEmployer = totalTaxesEmployer.add(wtl.getItsTotal());
                    }
                    isFilled = true;
                    break;
                }
                if (isFilled) continue;
                throw new ExceptionWithCode(1003, "where_is_no_suitable_tax_percent_entry_for::" + wtte.getItsOwner().getTax().getItsName());
            }
            for (WageLine wl : pWage.getItsLines()) {
                wl.setTaxesEmployee((BigDecimal)empleeTotTaxLnMap.get(wl.getWageType()));
                this.getSrvOrm().updateEntity(pAddParam, wl);
            }
            pWage.setTotalTaxesEmployee(totalTaxesEmployee);
            pWage.setTotalTaxesEmployer(totalTaxesEmployer);
            pWage.setNetWage(pWage.getItsTotal().subtract(pWage.getTotalTaxesEmployee()));
            this.getSrvOrm().updateEntity(pAddParam, pWage);
        }
    }

    public final boolean isWageApplied(WageType pWageType, WageTaxTable pWageTaxTable) {
        for (WageTaxTableType wttt : pWageTaxTable.getWageTypes()) {
            if (!wttt.getWageType().getItsId().equals(pWageType.getItsId())) continue;
            return true;
        }
        return false;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

