/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.IDocWarehouse;
import org.beigesoft.accounting.persistable.IMakingWarehouseEntry;
import org.beigesoft.accounting.persistable.WarehouseEntry;
import org.beigesoft.accounting.persistable.WarehouseRest;
import org.beigesoft.accounting.persistable.WarehouseSite;
import org.beigesoft.accounting.service.ISrvTypeCode;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public class SrvWarehouseEntry<RS>
implements ISrvWarehouseEntry {
    private ISrvTypeCode srvTypeCodeDocuments;
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDb;
    private boolean fastLoc = true;

    public SrvWarehouseEntry() {
    }

    public SrvWarehouseEntry(ISrvOrm<RS> pSrvOrm, ISrvTypeCode pSrvTypeCodeDocuments, ISrvI18n pSrvI18n) {
        this.srvOrm = pSrvOrm;
        this.srvTypeCodeDocuments = pSrvTypeCodeDocuments;
        this.srvI18n = pSrvI18n;
    }

    @Override
    public final void load(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, WarehouseSite pWhSiteTo) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_ws_entry_for_foreign_src");
        }
        WarehouseEntry wms = null;
        if (pEntity.getReversedId() != null) {
            String tblNm = WarehouseEntry.class.getSimpleName().toUpperCase();
            wms = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, WarehouseEntry.class, " where SOURCETYPE=" + pEntity.constTypeCode() + " and SOURCEID=" + pEntity.getReversedId() + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and WAREHOUSESITETO=" + pWhSiteTo.getItsId() + " and INVITEM=" + pEntity.getInvItem().getItsId());
            if (wms == null) {
                throw new ExceptionWithCode(1003, "cant_find_reverced_source");
            }
        }
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        WarehouseEntry wm = new WarehouseEntry();
        wm.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
        wm.setSourceId((Long)pEntity.getItsId());
        wm.setSourceType(pEntity.constTypeCode());
        wm.setWarehouseSiteTo(pWhSiteTo);
        wm.setInvItem(pEntity.getInvItem());
        wm.setUnitOfMeasure(pEntity.getUnitOfMeasure());
        wm.setItsQuantity(pEntity.getItsQuantity());
        wm.setSourceOwnerId(pEntity.getOwnerId());
        wm.setSourceOwnerType(pEntity.getOwnerType());
        if (wms != null) {
            wm.setReversedId(wms.getItsId());
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat) + " " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wms.getItsId());
        } else {
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat));
        }
        this.getSrvOrm().insertEntity(pAddParam, wm);
        wm.setIsNew(false);
        this.makeWarehouseRest(pAddParam, pEntity, pWhSiteTo, pEntity.getItsQuantity());
        if (wms != null) {
            wms.setReversedId(wm.getItsId());
            wms.setDescription(wms.getDescription() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wm.getItsId());
            this.getSrvOrm().updateEntity(pAddParam, wms);
        }
    }

    @Override
    public final void move(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, WarehouseSite pWhSiteFrom, WarehouseSite pWhSiteTo) throws Exception {
        WarehouseEntry wms = null;
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_ws_entry_for_foreign_src");
        }
        if (pEntity.getReversedId() != null) {
            String tblNm = WarehouseEntry.class.getSimpleName().toUpperCase();
            wms = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, WarehouseEntry.class, " where SOURCETYPE=" + pEntity.constTypeCode() + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and SOURCEID=" + pEntity.getReversedId());
            if (wms == null) {
                throw new ExceptionWithCode(1003, "cant_find_reverced_source");
            }
        }
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        WarehouseEntry wm = new WarehouseEntry();
        wm.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
        wm.setSourceId((Long)pEntity.getItsId());
        wm.setSourceType(pEntity.constTypeCode());
        wm.setWarehouseSiteFrom(pWhSiteFrom);
        wm.setWarehouseSiteTo(pWhSiteTo);
        wm.setInvItem(pEntity.getInvItem());
        wm.setUnitOfMeasure(pEntity.getUnitOfMeasure());
        wm.setItsQuantity(pEntity.getItsQuantity());
        wm.setSourceOwnerId(pEntity.getOwnerId());
        wm.setSourceOwnerType(pEntity.getOwnerType());
        if (wms != null) {
            wm.setReversedId(wms.getItsId());
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat) + " " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wms.getItsId());
        } else {
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat));
        }
        this.getSrvOrm().insertEntity(pAddParam, wm);
        wm.setIsNew(false);
        this.makeWarehouseRest(pAddParam, pEntity, pWhSiteFrom, pEntity.getItsQuantity().negate());
        this.makeWarehouseRest(pAddParam, pEntity, pWhSiteTo, pEntity.getItsQuantity());
        if (wms != null) {
            wms.setReversedId(wm.getItsId());
            wms.setDescription(wms.getDescription() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wm.getItsId());
            this.getSrvOrm().updateEntity(pAddParam, wms);
        }
    }

    @Override
    public final void makeWarehouseRest(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, WarehouseSite pWhSite, BigDecimal pQuantity) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_ws_entry_for_foreign_src");
        }
        WarehouseRest wr = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, WarehouseRest.class, "where WAREHOUSESITE=" + pWhSite.getItsId() + " and INVITEM=" + pEntity.getInvItem().getItsId() + " and UNITOFMEASURE=" + pEntity.getUnitOfMeasure().getItsId());
        if (wr == null) {
            if (pQuantity.doubleValue() < 0.0) {
                throw new ExceptionWithCode(403, "attempt_reverse_non_existent_good_in_warehouse");
            }
            wr = new WarehouseRest();
            wr.setIsNew(true);
            wr.setWarehouseSite(pWhSite);
            wr.setUnitOfMeasure(pEntity.getUnitOfMeasure());
            wr.setInvItem(pEntity.getInvItem());
        }
        wr.setTheRest(wr.getTheRest().add(pQuantity));
        if (wr.getTheRest().doubleValue() < 0.0) {
            throw new ExceptionWithCode(1301, "there_is_no_goods_in_stock");
        }
        if (wr.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, wr);
            wr.setIsNew(false);
        } else if (this.fastLoc) {
            ColumnsValues cvs = new ColumnsValues();
            cvs.getFormula().add("itsVersion");
            cvs.getFormula().add("theRest");
            cvs.put("itsVersion", "ITSVERSION+1");
            if (pQuantity.compareTo(BigDecimal.ZERO) == -1) {
                cvs.put("theRest", "THEREST" + pQuantity);
            } else {
                cvs.put("theRest", "THEREST+" + pQuantity);
            }
            this.srvDb.executeUpdate("WAREHOUSEREST", cvs, "WAREHOUSESITE=" + wr.getWarehouseSite().getItsId() + " and INVITEM=" + wr.getInvItem().getItsId() + " and UNITOFMEASURE=" + wr.getUnitOfMeasure().getItsId());
        } else {
            this.getSrvOrm().updateEntity(pAddParam, wr);
        }
    }

    @Override
    public final void withdrawal(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, WarehouseSite pWhSiteFrom) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_ws_entry_for_foreign_src");
        }
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        ColumnsValues cvs = null;
        if (this.fastLoc) {
            cvs = new ColumnsValues();
            cvs.getFormula().add("itsVersion");
            cvs.getFormula().add("theRest");
            cvs.put("itsVersion", "ITSVERSION+1");
        }
        if (pWhSiteFrom != null) {
            WarehouseRest wr = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, WarehouseRest.class, "where THEREST>0 and INVITEM=" + pEntity.getInvItem().getItsId() + " and UNITOFMEASURE=" + pEntity.getUnitOfMeasure().getItsId() + " and WAREHOUSESITE=" + pWhSiteFrom.getItsId());
            if (wr == null || wr.getTheRest().compareTo(pEntity.getItsQuantity()) < 0) {
                throw new ExceptionWithCode(1301, "There is no goods in stock, Item ID/UOM ID/ WS ID/ quantity" + pEntity.getInvItem().getItsId() + "/" + pEntity.getUnitOfMeasure().getItsId() + "/" + pEntity.getItsQuantity());
            }
            if (this.fastLoc) {
                cvs.put("theRest", "THEREST-" + pEntity.getItsQuantity());
                this.srvDb.executeUpdate("WAREHOUSEREST", cvs, "WAREHOUSESITE=" + wr.getWarehouseSite().getItsId() + " and INVITEM=" + wr.getInvItem().getItsId() + " and UNITOFMEASURE=" + wr.getUnitOfMeasure().getItsId());
            } else {
                wr.setTheRest(wr.getTheRest().subtract(pEntity.getItsQuantity()));
                this.getSrvOrm().updateEntity(pAddParam, wr);
            }
            WarehouseEntry wm = new WarehouseEntry();
            wm.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            wm.setSourceId((Long)pEntity.getItsId());
            wm.setSourceType(pEntity.constTypeCode());
            wm.setWarehouseSiteFrom(wr.getWarehouseSite());
            wm.setUnitOfMeasure(wr.getUnitOfMeasure());
            wm.setInvItem(wr.getInvItem());
            wm.setItsQuantity(pEntity.getItsQuantity());
            wm.setSourceOwnerId(pEntity.getOwnerId());
            wm.setSourceOwnerType(pEntity.getOwnerType());
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat));
            this.getSrvOrm().insertEntity(pAddParam, wm);
            wm.setIsNew(false);
        } else {
            WarehouseRest wr;
            List<WarehouseRest> wrl = this.getSrvOrm().retrieveListWithConditions(pAddParam, WarehouseRest.class, "where THEREST>0 and INVITEM=" + pEntity.getInvItem().getItsId() + " and UNITOFMEASURE=" + pEntity.getUnitOfMeasure().getItsId());
            BigDecimal theRest = BigDecimal.ZERO;
            Iterator<WarehouseRest> iterator = wrl.iterator();
            while (iterator.hasNext() && (theRest = theRest.add((wr = iterator.next()).getTheRest())).compareTo(pEntity.getItsQuantity()) < 0) {
            }
            if (theRest.compareTo(pEntity.getItsQuantity()) < 0) {
                throw new ExceptionWithCode(1301, "there_is_no_goods_in_stock");
            }
            BigDecimal quantityToLeaveRest = pEntity.getItsQuantity();
            for (WarehouseRest wr2 : wrl) {
                if (quantityToLeaveRest.doubleValue() == 0.0) break;
                BigDecimal quantityToLeave = wr2.getTheRest().compareTo(quantityToLeaveRest) <= 0 ? wr2.getTheRest() : quantityToLeaveRest;
                if (this.fastLoc) {
                    cvs.put("theRest", "THEREST-" + quantityToLeave);
                    this.srvDb.executeUpdate("WAREHOUSEREST", cvs, "WAREHOUSESITE=" + wr2.getWarehouseSite().getItsId() + " and INVITEM=" + wr2.getInvItem().getItsId() + " and UNITOFMEASURE=" + wr2.getUnitOfMeasure().getItsId());
                } else {
                    wr2.setTheRest(wr2.getTheRest().subtract(quantityToLeave));
                    this.getSrvOrm().updateEntity(pAddParam, wr2);
                }
                WarehouseEntry wm = new WarehouseEntry();
                wm.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                wm.setSourceId((Long)pEntity.getItsId());
                wm.setSourceType(pEntity.constTypeCode());
                wm.setWarehouseSiteFrom(wr2.getWarehouseSite());
                wm.setUnitOfMeasure(wr2.getUnitOfMeasure());
                wm.setInvItem(wr2.getInvItem());
                wm.setItsQuantity(quantityToLeave);
                wm.setSourceOwnerId(pEntity.getOwnerId());
                wm.setSourceOwnerType(pEntity.getOwnerType());
                wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat));
                this.getSrvOrm().insertEntity(pAddParam, wm);
                wm.setIsNew(false);
                quantityToLeaveRest = quantityToLeaveRest.subtract(quantityToLeave);
            }
        }
    }

    @Override
    public final void reverseDraw(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_ws_entry_for_foreign_src");
        }
        if (pEntity.getItsQuantity().doubleValue() > 0.0) {
            throw new ExceptionWithCode(1001, "reversing_source_must_has_negative_quantity");
        }
        String tblNm = WarehouseEntry.class.getSimpleName().toUpperCase();
        List<WarehouseEntry> wml = this.getSrvOrm().retrieveListWithConditions(pAddParam, WarehouseEntry.class, "where SOURCETYPE=" + pEntity.constTypeCode() + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and SOURCEID=" + pEntity.getReversedId() + " and INVITEM=" + pEntity.getInvItem().getItsId() + " and WAREHOUSESITEFROM is not null");
        BigDecimal quantityToLeaveRst = pEntity.getItsQuantity();
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        for (WarehouseEntry wms : wml) {
            if (wms.getItsQuantity().doubleValue() < 0.0) {
                throw new ExceptionWithCode(1003, "attempt_to_reverse_reversed");
            }
            WarehouseEntry wm = new WarehouseEntry();
            wm.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            wm.setSourceId((Long)pEntity.getItsId());
            wm.setSourceType(pEntity.constTypeCode());
            wm.setWarehouseSiteFrom(wms.getWarehouseSiteFrom());
            wm.setUnitOfMeasure(wms.getUnitOfMeasure());
            wm.setInvItem(wms.getInvItem());
            wm.setItsQuantity(wms.getItsQuantity().negate());
            quantityToLeaveRst = quantityToLeaveRst.add(wms.getItsQuantity());
            if (quantityToLeaveRst.doubleValue() > 0.0) {
                throw new ExceptionWithCode(1001, "reversing_source_has_different_quantity_against_movement_entries");
            }
            wm.setSourceOwnerId(pEntity.getOwnerId());
            wm.setSourceOwnerType(pEntity.getOwnerType());
            wm.setReversedId(wms.getItsId());
            wm.setDescription(this.makeDescription(pEntity, langDef, dateFormat) + " " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wms.getItsId());
            this.getSrvOrm().insertEntity(pAddParam, wm);
            wm.setIsNew(false);
            this.makeWarehouseRest(pAddParam, pEntity, wm.getWarehouseSiteFrom(), wms.getItsQuantity());
            wms.setReversedId(wm.getItsId());
            wms.setDescription(wms.getDescription() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + wm.getItsId());
            this.getSrvOrm().updateEntity(pAddParam, wms);
        }
        if (quantityToLeaveRst.doubleValue() != 0.0) {
            throw new ExceptionWithCode(1001, "reversing_source_has_different_quantity_against_movement_entries");
        }
    }

    @Override
    public final List<WarehouseEntry> retrieveEntriesFor(Map<String, Object> pAddParam, IDocWarehouse pEntity) throws Exception {
        String tblNm = WarehouseEntry.class.getSimpleName().toUpperCase();
        List<WarehouseEntry> result = null;
        if (pEntity instanceof IMakingWarehouseEntry) {
            String where = " where SOURCETYPE=" + pEntity.constTypeCode() + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and SOURCEID=" + pEntity.getItsId();
            result = this.getSrvOrm().retrieveListWithConditions(pAddParam, WarehouseEntry.class, where);
        }
        if (pEntity.getLinesWarehouseType() != null) {
            if (result == null) {
                result = this.retrieveEntriesForOwner(pAddParam, pEntity.constTypeCode(), (Long)pEntity.getItsId());
            } else {
                result.addAll(this.retrieveEntriesForOwner(pAddParam, pEntity.constTypeCode(), (Long)pEntity.getItsId()));
            }
        }
        return result;
    }

    @Override
    public final List<WarehouseEntry> retrieveEntriesForOwner(Map<String, Object> pAddParam, Integer pOwnerTypeCode, Long pOwnerId) throws Exception {
        String tblNm = WarehouseEntry.class.getSimpleName().toUpperCase();
        String where = " where SOURCEOWNERTYPE=" + pOwnerTypeCode + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and SOURCEOWNERID=" + pOwnerId;
        return this.getSrvOrm().retrieveListWithConditions(pAddParam, WarehouseEntry.class, where);
    }

    public final String makeDescription(IMakingWarehouseEntry pEntity, String pLangDef, DateFormat pDateFormat) {
        String strWho = this.getSrvI18n().getMsg(pEntity.getClass().getSimpleName() + "short", pLangDef) + " #" + this.getSrvOrm().getIdDatabase() + "-" + pEntity.getItsId();
        strWho = pEntity.getOwnerId() == null ? strWho + ", " + pDateFormat.format(pEntity.getDocumentDate()) : strWho + " " + this.getSrvI18n().getMsg("in", pLangDef) + " " + this.getSrvI18n().getMsg(this.getSrvTypeCodeDocuments().getTypeCodeMap().get(pEntity.getOwnerType()).getSimpleName() + "short", pLangDef) + " #" + this.getSrvOrm().getIdDatabase() + "-" + pEntity.getOwnerId() + ", " + pDateFormat.format(pEntity.getDocumentDate());
        return this.getSrvI18n().getMsg("made_at", pLangDef) + " " + pDateFormat.format(new Date()) + " " + this.getSrvI18n().getMsg("by", pLangDef) + " " + strWho;
    }

    public final ISrvTypeCode getSrvTypeCodeDocuments() {
        return this.srvTypeCodeDocuments;
    }

    public final void setSrvTypeCodeDocuments(ISrvTypeCode pSrvTypeCodeDocuments) {
        this.srvTypeCodeDocuments = pSrvTypeCodeDocuments;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvDatabase<RS> getSrvDb() {
        return this.srvDb;
    }

    public final void setSrvDb(ISrvDatabase<RS> pSrvDb) {
        this.srvDb = pSrvDb;
    }

    public final boolean getFastLoc() {
        return this.fastLoc;
    }

    public final void setFastLoc(boolean pFastLoc) {
        this.fastLoc = pFastLoc;
    }
}

