/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.Console;
import java.util.Date;
import org.beigesoft.ajetty.BootStrapEmbeddedMain;
import org.beigesoft.ajetty.ExceptionStart;
import org.beigesoft.ajetty.IBootStrapIFace;

public class BootStrapCli
implements IBootStrapIFace {
    private BootStrapEmbeddedMain mainBootStrap;
    private boolean isExit = false;

    @Override
    public final void showError(String pError) {
        Date dt = new Date();
        System.console().printf(dt.toString() + " " + this.mainBootStrap.getMsg("error") + ": " + pError + "\n", new Object[0]);
    }

    @Override
    public final void refreshUi() {
        Date dt = new Date();
        if (this.mainBootStrap.getIsActionPerforming()) {
            System.console().printf(dt.toString() + " " + this.mainBootStrap.getMsg("wait") + "\n", new Object[0]);
        } else if (this.mainBootStrap.getBootStrapEmbeddedHttps().getIsStarted()) {
            System.console().printf(dt.toString() + " " + this.mainBootStrap.getMsg("started") + " https://localhost:" + this.mainBootStrap.getPort() + "/bsa" + this.mainBootStrap.getPort() + " on A-Jetty #" + this.mainBootStrap.getAjettyIn() + "\n", new Object[0]);
        } else {
            System.console().printf(dt.toString() + " " + this.mainBootStrap.getMsg("stopped") + " on A-Jetty #" + this.mainBootStrap.getAjettyIn() + "\n", new Object[0]);
        }
    }

    public final void startInterface() throws ExceptionStart {
        Console con = System.console();
        if (con == null) {
            throw new ExceptionStart("There is no console!!!");
        }
        CliThread ct = new CliThread();
        ct.start();
    }

    public final void doWork() {
        long currDate;
        if (this.mainBootStrap.getIsActionPerforming() && (currDate = new Date().getTime()) - this.mainBootStrap.getLastActionStartDate() > 120000L) {
            this.mainBootStrap.setIsActionPerforming(false);
            this.mainBootStrap.getLogger().error(null, BootStrapCli.class, "Frozen!!!");
        }
        if (!this.mainBootStrap.getIsActionPerforming()) {
            if (!this.mainBootStrap.getBootStrapEmbeddedHttps().getIsStarted()) {
                this.enterAjettyNumIfNeed();
                if (this.isExit) {
                    return;
                }
                if (!this.mainBootStrap.getIsKeystoreCreated()) {
                    this.enterKsPasswd();
                    if (this.isExit) {
                        return;
                    }
                    this.enterKsPasswdConf();
                } else if (this.mainBootStrap.getKsPassword() == null || this.mainBootStrap.getIsLastStartFail()) {
                    this.enterKsPasswd();
                }
                if (this.isExit) {
                    return;
                }
                this.enterPort();
                this.enterStartOrQuit();
            } else {
                this.enterStopOrQuit();
            }
        }
    }

    public final void enterStartOrQuit() {
        int attempts = 0;
        Console con = System.console();
        while (attempts++ < 10) {
            try {
                String wrd = con.readLine(this.mainBootStrap.getMsg("enter_ajetty_start"), new Object[0]);
                if ("q".equals(wrd)) {
                    this.isExit = true;
                    return;
                }
                if (!"g".equals(wrd)) continue;
                this.mainBootStrap.setIsActionPerforming(true);
                this.mainBootStrap.startAjetty();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void enterStopOrQuit() {
        int attempts = 0;
        Console con = System.console();
        while (attempts++ < 10) {
            try {
                String wrd = con.readLine(this.mainBootStrap.getMsg("enter_ajetty_stop"), new Object[0]);
                if ("q".equals(wrd)) {
                    this.isExit = true;
                    this.mainBootStrap.setIsActionPerforming(true);
                    this.mainBootStrap.stopAjetty();
                    return;
                }
                if (!"s".equals(wrd)) continue;
                this.mainBootStrap.setIsActionPerforming(true);
                this.mainBootStrap.stopAjetty();
                return;
            }
            catch (ExceptionStart e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterAjettyNumIfNeed() {
        int attempts = 0;
        Console con = System.console();
        while (!this.isExit && this.mainBootStrap.getAjettyIn() == null) {
            try {
                String wrd = con.readLine(this.mainBootStrap.getMsg("enter_ajetty_sn"), new Object[0]);
                if ("q".equals(wrd)) {
                    this.isExit = true;
                    return;
                }
                this.mainBootStrap.setAjettyIn(Integer.parseInt(wrd));
            }
            finally {
                if (attempts++ <= 10) continue;
                this.isExit = true;
            }
        }
    }

    public final void enterPort() {
        Console con = System.console();
        try {
            String port = con.readLine(this.mainBootStrap.getMsg("enter_ajetty_port"), new Object[0]);
            if (port == null || port.length() == 0) {
                return;
            }
            this.mainBootStrap.setPort(Integer.parseInt(port));
        }
        catch (Exception e) {
            con.printf(this.mainBootStrap.getMsg("ajetty_port_def") + "\n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterKsPasswd() {
        int attempts = 0;
        this.mainBootStrap.setKsPassword(null);
        Console con = System.console();
        while (!this.isExit && this.mainBootStrap.getKsPassword() == null) {
            try {
                char[] passwd = con.readPassword(this.mainBootStrap.getMsg("enter_ajetty_passwd"), new Object[0]);
                if (passwd != null && passwd.length == 1 && passwd[0] == 'q') {
                    this.isExit = true;
                    return;
                }
                if (passwd == null) continue;
                this.mainBootStrap.setKsPassword(passwd);
            }
            finally {
                if (attempts++ <= 10) continue;
                this.isExit = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterKsPasswdConf() {
        int attempts = 0;
        this.mainBootStrap.setKsPasswordConf(null);
        Console con = System.console();
        while (!this.isExit && this.mainBootStrap.getKsPasswordConf() == null) {
            try {
                char[] passwd = con.readPassword(this.mainBootStrap.getMsg("enter_ajetty_passwd_conf"), new Object[0]);
                if (passwd != null && passwd.length == 1 && passwd[0] == 'q') {
                    this.isExit = true;
                    return;
                }
                if (passwd == null) continue;
                this.mainBootStrap.setKsPasswordConf(passwd);
            }
            finally {
                if (attempts++ <= 10) continue;
                this.isExit = true;
            }
        }
    }

    public final BootStrapEmbeddedMain getMainBootStrap() {
        return this.mainBootStrap;
    }

    public final void setMainBootStrap(BootStrapEmbeddedMain pMainBootStrap) {
        this.mainBootStrap = pMainBootStrap;
    }

    private class CliThread
    extends Thread {
        private CliThread() {
        }

        @Override
        public void run() {
            while (!BootStrapCli.this.isExit) {
                BootStrapCli.this.doWork();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

