/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.beigesoft.ajetty.ICryptoHelper;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.web.factory.AFactoryAppBeans;
import org.beigesoft.web.service.IMngDatabaseExt;

public class MngDatabaseSqliteEncrypted<RS>
implements IMngDatabaseExt {
    private File logDir;
    private String databaseDir;
    private String backupDir;
    private AFactoryAppBeans<RS> factoryAppBeans;
    private ICryptoHelper cryptoHelper;
    private String databasePrefix = "";

    @Override
    public final List<String> retrieveList() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        File dbDir = new File(this.databaseDir);
        if (dbDir.exists() && dbDir.isDirectory()) {
            String[] files = dbDir.list();
            if (files != null) {
                for (String flNm : files) {
                    if (!flNm.endsWith(".sqlite")) continue;
                    result.add(flNm.replace(".sqlite", ""));
                }
            }
        } else {
            throw new ExceptionWithCode(1002, "DB directory not found: " + this.databaseDir);
        }
        return result;
    }

    @Override
    public final List<String> retrieveBackupList() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        File dbDir = new File(this.backupDir);
        if (dbDir.exists() && dbDir.isDirectory()) {
            String[] files = dbDir.list();
            if (files != null) {
                for (String flNm : files) {
                    if (!flNm.endsWith(".sqlten")) continue;
                    result.add(flNm.replace(".sqlten", ""));
                }
            }
        } else {
            throw new ExceptionWithCode(1002, "Backup directory not found: " + this.backupDir);
        }
        return result;
    }

    @Override
    public final String retrieveCurrentDbName() throws Exception {
        return this.factoryAppBeans.getDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createDatabase(String pDbName, int pDbId) throws Exception {
        String dbNm = this.databasePrefix + pDbName + ".sqlite";
        AFactoryAppBeans<RS> aFactoryAppBeans = this.factoryAppBeans;
        synchronized (aFactoryAppBeans) {
            if (!this.factoryAppBeans.getDatabaseName().equals(dbNm)) {
                this.factoryAppBeans.setDatabaseName(dbNm);
                this.factoryAppBeans.setNewDatabaseId(pDbId);
                this.factoryAppBeans.handleDatabaseChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void changeDatabase(String pDbName) throws Exception {
        String dbNm = this.databasePrefix + pDbName + ".sqlite";
        AFactoryAppBeans<RS> aFactoryAppBeans = this.factoryAppBeans;
        synchronized (aFactoryAppBeans) {
            if (!this.factoryAppBeans.getDatabaseName().equals(dbNm)) {
                this.factoryAppBeans.setDatabaseName(dbNm);
                this.factoryAppBeans.handleDatabaseChanged();
            }
        }
    }

    @Override
    public final void deleteDatabase(String pDbName) throws Exception {
        File dbFile;
        String dbNm = this.databasePrefix + pDbName + ".sqlite";
        if (!dbNm.equals(this.factoryAppBeans.getDatabaseName()) && (dbFile = new File(this.databaseDir + File.separator + dbNm)).exists() && !dbFile.delete()) {
            throw new ExceptionWithCode(1001, "Can't delete file: " + dbFile);
        }
    }

    @Override
    public final void backupDatabase(String pDbName) throws Exception {
        String dbPath = this.databaseDir + File.separator + pDbName + ".sqlite";
        File dbFile = new File(dbPath);
        if (dbFile.exists()) {
            String encPath = this.backupDir + File.separator + pDbName + ".sqlten";
            File dbBkFile = new File(encPath);
            if (dbBkFile.exists()) {
                Long time = new Date().getTime();
                encPath = this.backupDir + File.separator + pDbName + time + ".sqlten";
            }
            this.cryptoHelper.encryptFile(dbPath, encPath);
        }
    }

    @Override
    public final void restoreDatabase(String pDbName) throws Exception {
        String encPath = this.backupDir + File.separator + pDbName + ".sqlten";
        File dbBkFile = new File(encPath);
        if (dbBkFile.exists()) {
            this.cryptoHelper.decryptFile(encPath, this.databaseDir + File.separator + pDbName + ".sqlite");
        }
    }

    @Override
    public final void encryptLogs() throws Exception {
        File[] files;
        if (this.logDir != null && this.logDir.exists() && !this.logDir.isFile() && (files = this.logDir.listFiles()) != null) {
            for (File fl : files) {
                if (!fl.getName().endsWith(".log")) continue;
                this.cryptoHelper.encryptFile(fl.getPath(), this.backupDir + File.separator + fl.getName() + "en");
            }
        }
    }

    @Override
    public final void decryptLogs() throws Exception {
        File[] files;
        File bkDir = new File(this.backupDir);
        if (bkDir.exists() && !bkDir.isFile() && (files = bkDir.listFiles()) != null) {
            for (File fl : files) {
                if (!fl.getName().endsWith(".logen")) continue;
                this.cryptoHelper.decryptFile(fl.getPath(), this.backupDir + File.separator + fl.getName().replace(".logen", ".log"));
            }
        }
    }

    @Override
    public final String getBackupDir() {
        return this.backupDir;
    }

    @Override
    public final void setBackupDir(String pBackupDir) {
        this.backupDir = pBackupDir;
    }

    public final File getLogDir() {
        return this.logDir;
    }

    public final void setLogDir(File pLogDir) {
        this.logDir = pLogDir;
    }

    public final String getDatabaseDir() {
        return this.databaseDir;
    }

    public final void setDatabaseDir(String pDatabaseDir) {
        this.databaseDir = pDatabaseDir;
    }

    public final AFactoryAppBeans<RS> getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(AFactoryAppBeans<RS> pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final ICryptoHelper getCryptoHelper() {
        return this.cryptoHelper;
    }

    public final void setCryptoHelper(ICryptoHelper pCryptoHelper) {
        this.cryptoHelper = pCryptoHelper;
    }

    public final String getDatabasePrefix() {
        return this.databasePrefix;
    }

    public final void setDatabasePrefix(String pDatabasePrefix) {
        this.databasePrefix = pDatabasePrefix;
    }
}

