/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.ajetty.ICryptoHelper;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.model.HttpRequestData;
import org.beigesoft.web.service.IMngDatabaseExt;
import org.beigesoft.web.service.UtlJsp;

public class WMngDatabaseExt
extends HttpServlet {
    private final String[] ecncodingLetters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        IFactoryAppBeans factoryAppBeans = null;
        try {
            factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            IMngDatabaseExt mngDatabase = (IMngDatabaseExt)factoryAppBeans.lazyGet("IMngDatabaseExt");
            ICryptoHelper ch = (ICryptoHelper)factoryAppBeans.lazyGet("ICryptoHelper");
            String nameAction = pReq.getParameter("nameAction");
            String nameDatabase = pReq.getParameter("nameDatabase");
            if (nameDatabase != null && nameDatabase.length() > 2) {
                if ("change".equals(nameAction)) {
                    mngDatabase.changeDatabase(nameDatabase);
                    pReq.getSession().invalidate();
                } else if ("delete".equals(nameAction)) {
                    mngDatabase.deleteDatabase(nameDatabase);
                } else if ("backup".equals(nameAction)) {
                    mngDatabase.backupDatabase(nameDatabase);
                } else if ("restore".equals(nameAction)) {
                    mngDatabase.restoreDatabase(nameDatabase);
                }
            } else if ("encryptLogs".equals(nameAction)) {
                mngDatabase.encryptLogs();
            } else if ("decryptLogs".equals(nameAction)) {
                mngDatabase.decryptLogs();
            }
            if (ch.lazyGetOurPublicKey() != null) {
                byte[] ourPublicKey = ch.lazyGetOurPublicKey().getEncoded();
                byte[] ourPkSha1 = ch.calculateSha1(ourPublicKey);
                String ourPublicKeyStr = this.toHexString(ourPkSha1);
                pReq.setAttribute("ourPublicKeyStr", ourPublicKeyStr);
            }
            if (ch.lazyGetPublicKeyAnotherAjetty() != null) {
                byte[] foreignPublicKey = ch.lazyGetPublicKeyAnotherAjetty().getEncoded();
                byte[] forPkSha1 = ch.calculateSha1(foreignPublicKey);
                String foreignPublicKeyStr = this.toHexString(forPkSha1);
                pReq.setAttribute("foreignPublicKeyStr", foreignPublicKeyStr);
            }
            List<String> databases = mngDatabase.retrieveList();
            List<String> bkDatabases = mngDatabase.retrieveBackupList();
            ISrvI18n srvI18n = (ISrvI18n)factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)factoryAppBeans.lazyGet("UtlJsp");
            pReq.setAttribute("databases", databases);
            pReq.setAttribute("bkDatabases", bkDatabases);
            pReq.setAttribute("backupDir", mngDatabase.getBackupDir());
            pReq.setAttribute("currDb", mngDatabase.retrieveCurrentDbName());
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        IFactoryAppBeans factoryAppBeans = null;
        try {
            factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            IMngDatabaseExt mngDatabase = (IMngDatabaseExt)factoryAppBeans.lazyGet("IMngDatabaseExt");
            String nameAction = pReq.getParameter("nameAction");
            String nameDatabase = pReq.getParameter("nameDatabase");
            if (nameDatabase != null && nameDatabase.length() > 2) {
                if ("create".equals(nameAction)) {
                    String idDatabaseStr = pReq.getParameter("idDatabase");
                    int idDatabase = Integer.parseInt(idDatabaseStr);
                    mngDatabase.createDatabase(nameDatabase, idDatabase);
                } else if ("change".equals(nameAction)) {
                    mngDatabase.changeDatabase(nameDatabase);
                    pReq.getSession().invalidate();
                }
            }
            List<String> databases = mngDatabase.retrieveList();
            List<String> bkDatabases = mngDatabase.retrieveBackupList();
            ISrvI18n srvI18n = (ISrvI18n)factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)factoryAppBeans.lazyGet("UtlJsp");
            pReq.setAttribute("databases", databases);
            pReq.setAttribute("bkDatabases", bkDatabases);
            pReq.setAttribute("backupDir", mngDatabase.getBackupDir());
            pReq.setAttribute("currDb", mngDatabase.retrieveCurrentDbName());
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final String toHexString(byte[] pSource) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = pSource;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int bi = b = byArray[i];
            sb.append(this.ecncodingLetters[(bi &= 0xFF) >> 4 & 0xF]);
            sb.append(this.ecncodingLetters[bi & 0xF]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

