/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.doc.service;

import java.util.ArrayList;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EPageOrientation;
import org.beigesoft.doc.model.EPageSize;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.model.IDerivingElements;
import org.beigesoft.doc.model.IFont;
import org.beigesoft.doc.service.IFctDocument;

public class FctDocument<WI>
implements IFctDocument<WI> {
    @Override
    public final Document<WI> createDoc(EPageSize pPageSize, EPageOrientation pPageOrientation) throws Exception {
        if (pPageSize.equals((Object)EPageSize.LETTER)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                return this.createDoc(EUnitOfMeasure.INCH, 8.5, 11.0);
            }
            return this.createDoc(EUnitOfMeasure.INCH, 11.0, 8.5);
        }
        if (pPageSize.equals((Object)EPageSize.A5)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                return this.createDoc(EUnitOfMeasure.MILLIMETRE, 148.0, 210.0);
            }
            return this.createDoc(EUnitOfMeasure.MILLIMETRE, 210.0, 148.0);
        }
        if (pPageSize.equals((Object)EPageSize.A4)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                return this.createDoc(EUnitOfMeasure.MILLIMETRE, 210.0, 297.0);
            }
            return this.createDoc(EUnitOfMeasure.MILLIMETRE, 297.0, 210.0);
        }
        if (pPageSize.equals((Object)EPageSize.A3)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                return this.createDoc(EUnitOfMeasure.MILLIMETRE, 297.0, 420.0);
            }
            return this.createDoc(EUnitOfMeasure.MILLIMETRE, 420.0, 297.0);
        }
        if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
            return this.createDoc(EUnitOfMeasure.MILLIMETRE, 420.0, 594.0);
        }
        return this.createDoc(EUnitOfMeasure.MILLIMETRE, 594.0, 420.0);
    }

    @Override
    public final Document<WI> createDoc(EUnitOfMeasure pUom, double pWidth, double pHeight) throws Exception {
        Document doc = new Document();
        doc.setUnitOfMeasure(pUom);
        doc.setPages(new ArrayList());
        doc.setFonts(new ArrayList<IFont>());
        doc.setDerivingElementsList(new ArrayList<IDerivingElements>());
        DocPage pg1 = new DocPage();
        pg1.setElements(new ArrayList());
        pg1.setWidth(pWidth);
        pg1.setHeight(pHeight);
        if (EUnitOfMeasure.INCH.equals((Object)pUom)) {
            pg1.setMarginBottom(0.79);
            pg1.setMarginTop(0.79);
            pg1.setMarginLeft(0.79);
            pg1.setMarginRight(0.79);
        } else if (EUnitOfMeasure.MILLIMETRE.equals((Object)pUom)) {
            pg1.setMarginBottom(20.0);
            pg1.setMarginTop(20.0);
            pg1.setMarginLeft(30.0);
            pg1.setMarginRight(15.0);
            doc.setContainerMarginBottom(3.5);
            doc.setContentPadding(1.0);
            doc.setBorder(0.33);
            doc.setFontSize(3.5);
        }
        doc.getPages().add(pg1);
        doc.setPageNumber(1);
        return doc;
    }
}

