/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.Map;
import org.beigesoft.delegate.IDelegate;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IHasId;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.IFillerObjectsFrom;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class HandlerEntityRequest<RS>
implements IHandlerRequest {
    private ILogger logger;
    private ILogger secureLogger;
    private ISrvDatabase<RS> srvDatabase;
    private IFillerObjectsFrom<IRequestData> fillEntityFromReq;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;
    private IFactoryAppBeansByName<IEntityProcessor> entitiesProcessorsFactory;
    private IHolderForClassByName<String> entitiesProcessorsNamesHolder;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;
    private IHolderForClassByName<String> processorsNamesHolder;
    private Map<String, Class<?>> entitiesMap;
    private Integer writeTi = ISrvDatabase.TRANSACTION_READ_UNCOMMITTED;
    private Integer readTi = ISrvDatabase.TRANSACTION_READ_UNCOMMITTED;
    private Integer writeReTi = ISrvDatabase.TRANSACTION_READ_UNCOMMITTED;
    private Boolean wrReSpTr = Boolean.FALSE;
    private IDelegate<IRequestData> delegateSt;

    @Override
    public final void handle(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        String[] actionsArr;
        String nmEnt = pRqDt.getParameter("nmEnt");
        if (nmEnt == null) {
            return;
        }
        Class<?> entityClass = this.entitiesMap.get(nmEnt);
        if (entityClass == null) {
            this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/host/addr/port/user: " + nmEnt + "/" + pRqDt.getRemoteHost() + "/" + pRqDt.getRemoteAddr() + "/" + pRqDt.getRemotePort() + "/" + pRqDt.getUserName());
            throw new ExceptionWithCode(403, "Forbidden!");
        }
        if (this.delegateSt != null) {
            this.delegateSt.makeWith(pRqVs, pRqDt);
        }
        int detLev = this.logger.getDetailLevel();
        boolean isShowDebMsg = this.logger.getIsShowDebugMessages() && this.logger.getIsShowDebugMessagesFor(this.getClass());
        for (String actionNm : actionsArr = pRqDt.getParameter("nmsAct").split(",")) {
            if (!isShowDebMsg || detLev <= 100) continue;
            this.logger.debug(pRqVs, HandlerEntityRequest.class, "Action: " + actionNm);
        }
        if (this.wrReSpTr.booleanValue() && ("entityFolSave".equals(actionsArr[0]) || "entitySave".equals(actionsArr[0]) || "entityDelete".equals(actionsArr[0]) || "entityFolDelete".equals(actionsArr[0]))) {
            IHasId entity = null;
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(this.writeTi);
                this.srvDatabase.beginTransaction();
                IFactorySimple<?> entFac = this.entitiesFactoriesFatory.lazyGet(pRqVs, entityClass);
                entity = (IHasId)entFac.create(pRqVs);
                this.fillEntityFromReq.fill(pRqVs, entity, pRqDt);
                String entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionsArr[0]);
                if (entProcNm == null) {
                    this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/action/user: " + nmEnt + "/" + actionsArr[0] + "/" + pRqDt.getUserName());
                    throw new ExceptionWithCode(403, "Forbidden!");
                }
                IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pRqVs, entProcNm);
                if (isShowDebMsg && detLev > 100) {
                    this.logger.debug(pRqVs, HandlerEntityRequest.class, "CHANGING transaction use entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                }
                entity = ep.process(pRqVs, entity, pRqDt);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                this.srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
            if (actionsArr.length > 1) {
                try {
                    this.srvDatabase.setIsAutocommit(false);
                    this.srvDatabase.setTransactionIsolation(this.readTi);
                    this.srvDatabase.beginTransaction();
                    for (int i = 1; i < actionsArr.length; ++i) {
                        String actionNm = actionsArr[i];
                        if (actionNm.startsWith("entity")) {
                            String entProcNm;
                            if (entity == null) {
                                entity = (IHasId)pRqVs.get("nextEntity");
                                if (entity == null) {
                                    throw new ExceptionWithCode(1003, "wrong_request_entity_not_filled");
                                }
                                entityClass = entity.getClass();
                            }
                            if ((entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionNm)) == null) {
                                this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/action/user: " + nmEnt + "/" + actionNm + "/" + pRqDt.getUserName());
                                throw new ExceptionWithCode(403, "Forbidden!");
                            }
                            IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pRqVs, entProcNm);
                            if (isShowDebMsg && detLev > 100) {
                                this.logger.debug(pRqVs, HandlerEntityRequest.class, "It's used entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                            }
                            entity = ep.process(pRqVs, entity, pRqDt);
                            continue;
                        }
                        String procNm = this.processorsNamesHolder.getFor(entityClass, actionNm);
                        if (procNm == null) {
                            this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/action/user: " + nmEnt + "/" + actionNm + "/" + pRqDt.getUserName());
                            throw new ExceptionWithCode(403, "Forbidden!");
                        }
                        IProcessor proc = this.processorsFactory.lazyGet(pRqVs, procNm);
                        if (isShowDebMsg && detLev > 100) {
                            this.logger.debug(pRqVs, HandlerEntityRequest.class, "It's used procNm/IProcessor: " + procNm + "/" + proc.getClass());
                        }
                        proc.process(pRqVs, pRqDt);
                    }
                    this.srvDatabase.commitTransaction();
                }
                catch (Exception ex) {
                    this.srvDatabase.rollBackTransaction();
                    throw ex;
                }
                finally {
                    this.srvDatabase.releaseResources();
                }
            }
        } else {
            this.handleNoChangeIsolation(pRqVs, pRqDt, entityClass, actionsArr, isShowDebMsg, detLev, nmEnt);
        }
    }

    public final void handleNoChangeIsolation(Map<String, Object> pRqVs, IRequestData pRqDt, Class<?> pEntityClass, String[] pActionsArr, boolean pIsShowDebMsg, int pDetLev, String pNmEnt) throws Exception {
        Class<?> entityClass = pEntityClass;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(this.writeReTi);
            this.srvDatabase.beginTransaction();
            IHasId entity = null;
            if (pActionsArr[0].startsWith("entity")) {
                IFactorySimple<?> entFac = this.entitiesFactoriesFatory.lazyGet(pRqVs, entityClass);
                entity = (IHasId)entFac.create(pRqVs);
                this.fillEntityFromReq.fill(pRqVs, entity, pRqDt);
            }
            for (String actionNm : pActionsArr) {
                if (actionNm.startsWith("entity")) {
                    String entProcNm;
                    if (entity == null) {
                        entity = (IHasId)pRqVs.get("nextEntity");
                        if (entity == null) {
                            throw new ExceptionWithCode(1003, "wrong_request_entity_not_filled");
                        }
                        entityClass = entity.getClass();
                    }
                    if ((entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionNm)) == null) {
                        this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/action/user: " + pNmEnt + "/" + actionNm + "/" + pRqDt.getUserName());
                        throw new ExceptionWithCode(403, "Forbidden!");
                    }
                    IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pRqVs, entProcNm);
                    if (pIsShowDebMsg && pDetLev > 100) {
                        this.logger.debug(pRqVs, HandlerEntityRequest.class, "It's used entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                    }
                    entity = ep.process(pRqVs, entity, pRqDt);
                    continue;
                }
                String procNm = this.processorsNamesHolder.getFor(entityClass, actionNm);
                if (procNm == null) {
                    this.secureLogger.error(null, HandlerEntityRequest.class, "Trying to work with forbidden entity/action/user: " + pNmEnt + "/" + actionNm + "/" + pRqDt.getUserName());
                    throw new ExceptionWithCode(403, "Forbidden!");
                }
                IProcessor proc = this.processorsFactory.lazyGet(pRqVs, procNm);
                if (pIsShowDebMsg && pDetLev > 100) {
                    this.logger.debug(pRqVs, HandlerEntityRequest.class, "It's used procNm/IProcessor: " + procNm + "/" + proc.getClass());
                }
                proc.process(pRqVs, pRqDt);
            }
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IFillerObjectsFrom<IRequestData> getFillEntityFromReq() {
        return this.fillEntityFromReq;
    }

    public final void setFillEntityFromReq(IFillerObjectsFrom<IRequestData> pFillEntityFromReq) {
        this.fillEntityFromReq = pFillEntityFromReq;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }

    public final IFactoryAppBeansByName<IEntityProcessor> getEntitiesProcessorsFactory() {
        return this.entitiesProcessorsFactory;
    }

    public final void setEntitiesProcessorsFactory(IFactoryAppBeansByName<IEntityProcessor> pEntitiesProcessorsFactory) {
        this.entitiesProcessorsFactory = pEntitiesProcessorsFactory;
    }

    public final IHolderForClassByName<String> getEntitiesProcessorsNamesHolder() {
        return this.entitiesProcessorsNamesHolder;
    }

    public final void setEntitiesProcessorsNamesHolder(IHolderForClassByName<String> pEntitiesProcessorsNamesHolder) {
        this.entitiesProcessorsNamesHolder = pEntitiesProcessorsNamesHolder;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }

    public final IHolderForClassByName<String> getProcessorsNamesHolder() {
        return this.processorsNamesHolder;
    }

    public final void setProcessorsNamesHolder(IHolderForClassByName<String> pProcessorsNamesHolder) {
        this.processorsNamesHolder = pProcessorsNamesHolder;
    }

    public final Map<String, Class<?>> getEntitiesMap() {
        return this.entitiesMap;
    }

    public final void setEntitiesMap(Map<String, Class<?>> pEntitiesMap) {
        this.entitiesMap = pEntitiesMap;
    }

    public final Integer getWriteTi() {
        return this.writeTi;
    }

    public final void setWriteTi(Integer pWriteTi) {
        this.writeTi = pWriteTi;
    }

    public final ILogger getSecureLogger() {
        return this.secureLogger;
    }

    public final void setSecureLogger(ILogger pSecureLogger) {
        this.secureLogger = pSecureLogger;
    }

    public final Integer getReadTi() {
        return this.readTi;
    }

    public final void setReadTi(Integer pReadTi) {
        this.readTi = pReadTi;
    }

    public final Integer getWriteReTi() {
        return this.writeReTi;
    }

    public final void setWriteReTi(Integer pWriteReTi) {
        this.writeReTi = pWriteReTi;
    }

    public final Boolean getWrReSpTr() {
        return this.wrReSpTr;
    }

    public final void setWrReSpTr(Boolean pWrReSpTr) {
        this.wrReSpTr = pWrReSpTr;
    }

    public final IDelegate<IRequestData> getDelegateSt() {
        return this.delegateSt;
    }

    public final void setDelegateSt(IDelegate<IRequestData> pDelegateSt) {
        this.delegateSt = pDelegateSt;
    }
}

