/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.handler.IHandlerRequestDch;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.DecimalGroupSeparator;
import org.beigesoft.persistable.DecimalSeparator;
import org.beigesoft.persistable.LangPreferences;
import org.beigesoft.persistable.Languages;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class HndlI18nRequest<RS>
implements IHandlerRequestDch {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private List<LangPreferences> langPreferences;
    private List<Languages> languages;
    private List<DecimalSeparator> decSeps;
    private List<DecimalGroupSeparator> decGrSeps;
    private IHandlerRequestDch additionalI18nReqHndl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        List<DecimalGroupSeparator> dgssTmp;
        List<DecimalSeparator> dssTmp;
        List<Languages> lgsTmp;
        List<LangPreferences> lpfsTmp;
        boolean isFirstReq = false;
        HndlI18nRequest hndlI18nRequest = this;
        synchronized (hndlI18nRequest) {
            if (this.langPreferences == null) {
                try {
                    isFirstReq = true;
                    this.logger.info(null, HndlI18nRequest.class, "Refreshing I18N data...");
                    this.srvDatabase.setIsAutocommit(false);
                    this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                    this.srvDatabase.beginTransaction();
                    List<LangPreferences> lpfs = this.srvOrm.retrieveList(pReqVars, LangPreferences.class);
                    List<Languages> lgs = this.srvOrm.retrieveList(pReqVars, Languages.class);
                    List<DecimalSeparator> dss = this.srvOrm.retrieveList(pReqVars, DecimalSeparator.class);
                    List<DecimalGroupSeparator> dgss = this.srvOrm.retrieveList(pReqVars, DecimalGroupSeparator.class);
                    this.srvDatabase.commitTransaction();
                    this.decGrSeps = dgss;
                    this.decSeps = dss;
                    this.languages = lgs;
                    this.langPreferences = lpfs;
                }
                catch (Exception ex) {
                    if (!this.srvDatabase.getIsAutocommit()) {
                        this.srvDatabase.rollBackTransaction();
                    }
                    throw ex;
                }
                finally {
                    this.srvDatabase.releaseResources();
                }
            }
            lpfsTmp = this.langPreferences;
            lgsTmp = this.languages;
            dssTmp = this.decSeps;
            dgssTmp = this.decGrSeps;
        }
        LangPreferences lpf = this.revealLangPreferences(pRequestData, lgsTmp, dssTmp, dgssTmp, lpfsTmp, isFirstReq);
        String langDef = null;
        for (LangPreferences lpft : lpfsTmp) {
            if (!lpft.getIsDefault().booleanValue()) continue;
            langDef = lpft.getLang().getItsId();
            break;
        }
        if (lpfsTmp.size() == 0 || langDef == null) {
            this.logger.error(null, HndlI18nRequest.class, "There is no default languages preferences!");
            pReqVars.put("lang", "en");
            pReqVars.put("langDef", "en");
            pReqVars.put("localeCurr", new Locale("en", "US"));
            pReqVars.put("decSep", ".");
            pReqVars.put("decGrSep", ",");
            pReqVars.put("digInGr", 3);
            return;
        }
        pReqVars.put("lang", lpf.getLang().getItsId());
        pReqVars.put("langDef", langDef);
        Locale locCurr = pRequestData.getLocale().getLanguage().equals(lpf.getLang().getItsId()) ? pRequestData.getLocale() : new Locale(lpf.getLang().getItsId());
        pReqVars.put("localeCurr", locCurr);
        pReqVars.put("decSep", lpf.getDecimalSep().getItsId());
        pReqVars.put("digInGr", lpf.getDigitsInGroup());
        String decSepv = lpf.getDecimalSep().getItsId();
        if ("space".equals(decSepv)) {
            decSepv = "\u00a0";
        }
        pReqVars.put("decSepv", decSepv);
        pReqVars.put("decGrSep", lpf.getDecimalGroupSep().getItsId());
        String decGrSepv = lpf.getDecimalGroupSep().getItsId();
        if ("space".equals(decGrSepv)) {
            decGrSepv = "\u00a0";
        }
        pReqVars.put("decGrSepv", decGrSepv);
        pReqVars.put("languages", lgsTmp);
        pReqVars.put("decSeps", dssTmp);
        pReqVars.put("decGrSeps", dgssTmp);
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handle(pReqVars, pRequestData);
        } else {
            pReqVars.put("quantityDp", 2);
            pReqVars.put("priceDp", 2);
            pReqVars.put("costDp", 2);
        }
    }

    public final LangPreferences revealLangPreferences(IRequestData pRequestData, List<Languages> pLangs, List<DecimalSeparator> pDecSeps, List<DecimalGroupSeparator> pDecGrSeps, List<LangPreferences> pLangPrefs, boolean pIsFirstReq) throws Exception {
        int detLev = this.logger.getDetailLevel();
        boolean isShowDebMsg = this.logger.getIsShowDebugMessages() && this.logger.getIsShowDebugMessagesFor(this.getClass());
        LangPreferences lpf = null;
        boolean needSetCookie = false;
        String lang = pRequestData.getParameter("lang");
        String decSep = pRequestData.getParameter("decSep");
        String decGrSep = pRequestData.getParameter("decGrSep");
        String digInGr = pRequestData.getParameter("digInGr");
        if (pIsFirstReq || isShowDebMsg && detLev > 60000) {
            this.logger.debug(null, HndlI18nRequest.class, "Request's lang/decSep/decGrSep/digInGr: " + lang + "/" + decSep + "/" + decGrSep + "/" + digInGr);
        }
        if (lang == null || lang.length() == 0 || decSep == null || decSep.length() == 0 || decGrSep == null || decGrSep.length() == 0 || digInGr == null || digInGr.length() == 0) {
            lang = null;
            decSep = null;
            decGrSep = null;
            digInGr = null;
        } else {
            needSetCookie = true;
        }
        if (decGrSep == null && decSep == null && lang == null) {
            lang = pRequestData.getCookieValue("lang");
            decSep = pRequestData.getCookieValue("decSep");
            decGrSep = pRequestData.getCookieValue("decGrSep");
            digInGr = pRequestData.getCookieValue("digInGr");
            if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                this.logger.debug(null, HndlI18nRequest.class, "Client's cookie lang/decSep/decGrSep/digInGr: " + lang + "/" + decSep + "/" + decGrSep + "/" + digInGr);
            }
        }
        if (decGrSep != null && decSep != null && lang != null && digInGr != null) {
            if (decGrSep.equals(decSep)) {
                if (pIsFirstReq || isShowDebMsg) {
                    this.logger.debug(null, HndlI18nRequest.class, "Separators are same!! decSep/decGrSep: " + decSep);
                }
            } else {
                lpf = new LangPreferences();
                lpf.setDigitsInGroup(Integer.parseInt(digInGr));
                for (Languages ln : pLangs) {
                    if (!ln.getItsId().equals(lang)) continue;
                    lpf.setLang(ln);
                    break;
                }
                if (lpf.getLang() == null) {
                    lpf = null;
                } else {
                    for (DecimalSeparator ds : pDecSeps) {
                        if (!ds.getItsId().equals(decSep)) continue;
                        lpf.setDecimalSep(ds);
                        break;
                    }
                    if (lpf.getDecimalSep() == null) {
                        lpf = null;
                    } else {
                        for (DecimalGroupSeparator dgs : pDecGrSeps) {
                            if (!dgs.getItsId().equals(decGrSep)) continue;
                            lpf.setDecimalGroupSep(dgs);
                            break;
                        }
                        if (lpf.getDecimalGroupSep() == null) {
                            lpf = null;
                        }
                    }
                }
            }
        }
        if (lpf == null) {
            String ccountry = null;
            String clang = null;
            if (pRequestData.getLocale() != null) {
                ccountry = pRequestData.getLocale().getCountry();
                clang = pRequestData.getLocale().getLanguage();
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Client prefers lang/country: " + clang + "/" + ccountry);
                }
            }
            LangPreferences lpfMf = null;
            LangPreferences lpfMl = null;
            LangPreferences lpfDef = null;
            for (LangPreferences lpft : pLangPrefs) {
                if (lpft.getCountry().getItsId().equals(ccountry) && lpft.getLang().getItsId().equals(clang)) {
                    lpfMf = lpft;
                    break;
                }
                if (lpft.getLang().getItsId().equals(clang)) {
                    lpfMl = lpft;
                }
                if (lpft.getIsDefault().booleanValue()) {
                    lpfDef = lpft;
                    continue;
                }
                if (lpfDef != null) continue;
                lpfDef = lpft;
            }
            if (lpfMf != null) {
                lpf = lpfMf;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Full match lang/decSep/decGrSep/digInGr: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            } else if (lpfMl != null) {
                lpf = lpfMl;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Lang match lang/decSep/decGrSep/digInGr: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            } else {
                lpf = lpfDef;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "No match, default lang/decSep/decGrSep/digInGr: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            }
            needSetCookie = true;
        }
        if (needSetCookie) {
            pRequestData.setCookieValue("digInGr", lpf.getDigitsInGroup().toString());
            pRequestData.setCookieValue("lang", lpf.getLang().getItsId());
            pRequestData.setCookieValue("decSep", lpf.getDecimalSep().getItsId());
            pRequestData.setCookieValue("decGrSep", lpf.getDecimalGroupSep().getItsId());
            if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                this.logger.debug(null, HndlI18nRequest.class, "Cookie is set lang/decSep/decGrSep: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId());
            }
        }
        return lpf;
    }

    @Override
    public final synchronized void handleDataChanged() throws Exception {
        this.langPreferences = null;
        this.languages = null;
        this.decSeps = null;
        this.decGrSeps = null;
        this.logger.info(null, HndlI18nRequest.class, "I18N changes are handled.");
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handleDataChanged();
        }
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IHandlerRequestDch getAdditionalI18nReqHndl() {
        return this.additionalI18nReqHndl;
    }

    public final void setAdditionalI18nReqHndl(IHandlerRequestDch pAdditionalI18nReqHndl) {
        this.additionalI18nReqHndl = pAdditionalI18nReqHndl;
    }
}

