/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.Map;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class TransactionalRequestHandler<RS>
implements IHandlerRequest {
    private ISrvDatabase<RS> srvDatabase;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;
    private Integer writeReTi = ISrvDatabase.TRANSACTION_READ_UNCOMMITTED;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        String processorName = pRequestData.getParameter("nmPrc");
        if (processorName == null) {
            return;
        }
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(this.writeReTi);
            this.srvDatabase.beginTransaction();
            IProcessor proc = this.processorsFactory.lazyGet(pReqVars, processorName);
            proc.process(pReqVars, pRequestData);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }

    public final Integer getWriteReTi() {
        return this.writeReTi;
    }

    public final void setWriteReTi(Integer pWriteReTi) {
        this.writeReTi = pWriteReTi;
    }
}

