/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.log;

import org.beigesoft.log.IDebugPrinter;

public abstract class ADebugPrinter
implements IDebugPrinter {
    private String lineSeparator = System.getProperty("line.separator");

    public final void exceptionToString(StringBuffer pBuffer, Throwable pThrown) {
        if (pThrown == null) {
            pBuffer.append(" ex-null");
        } else {
            pBuffer.append(pThrown.toString());
            StackTraceElement[] elements = pThrown.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                pBuffer.append(this.lineSeparator + "\tat ");
                pBuffer.append(elements[i].toString());
            }
            for (Throwable suppressed : pThrown.getSuppressed()) {
                pBuffer.append(this.lineSeparator + "Suppressed: ");
                pBuffer.append(suppressed.toString() + "\t|");
            }
            Throwable cause = pThrown.getCause();
            if (cause != null && cause != pThrown) {
                pBuffer.append(this.lineSeparator).append("Caused by: ");
                pBuffer.append(cause);
            }
        }
        pBuffer.append(this.lineSeparator);
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final void setLineSeparator(String pLineSeparator) {
        this.lineSeparator = pLineSeparator;
    }
}

