/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.service;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.converter.IConverterByName;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.orm.model.ETypeField;
import org.beigesoft.orm.model.TableSql;
import org.beigesoft.service.IFillerObjectFields;
import org.beigesoft.service.IFillerObjectsFrom;

public class FillerEntitiesFromRs<RS>
implements IFillerObjectsFrom<IRecordSet<RS>> {
    private Map<String, TableSql> tablesMap;
    private ILogger logger;
    private IFactoryAppBeansByClass<IFillerObjectFields<?>> fillersFieldsFactory;
    private IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> convertersFieldsFatory;
    private IHolderForClassByName<String> fieldConverterNamesHolder;
    private IHolderForClassByName<Field> fieldsRapiHolder;

    @Override
    public final <T> void fill(Map<String, Object> pAddParam, T pEntity, IRecordSet<RS> pSource) throws Exception {
        IFillerObjectFields<?> filler = this.fillersFieldsFactory.lazyGet(pAddParam, pEntity.getClass());
        TableSql tableSql = this.tablesMap.get(pEntity.getClass().getSimpleName());
        Set<String> fieldsNames = (Set<String>)pAddParam.get(pEntity.getClass().getSimpleName() + "neededFields");
        if (fieldsNames == null) {
            fieldsNames = tableSql.getFieldsMap().keySet();
        }
        boolean isShowDbMsg = this.logger.getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.logger.getDetailLevel();
        String currentLevelNm = "currentLevel";
        List currentLevel = (List)pAddParam.get(currentLevelNm);
        String deepLevelNm = "deepLevel";
        List deepLevel = (List)pAddParam.get(deepLevelNm);
        List foreignFieldNms = (List)pAddParam.get("foreignFieldNms");
        for (String fieldName : fieldsNames) {
            String convName;
            IConverterByName<IRecordSet<RS>, ?> conv;
            if (tableSql.getFieldsMap().get(fieldName).getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE) || (conv = this.convertersFieldsFatory.lazyGet(pAddParam, convName = this.fieldConverterNamesHolder.getFor(pEntity.getClass(), fieldName))) == null) continue;
            try {
                String parName;
                String tableAlias;
                Field field = this.fieldsRapiHolder.getFor(pEntity.getClass(), fieldName);
                if ((Integer)currentLevel.get(0) > 1) {
                    String currForeignFieldNm = (String)foreignFieldNms.get(foreignFieldNms.size() - 1);
                    tableAlias = currForeignFieldNm.toUpperCase();
                } else {
                    tableAlias = "";
                }
                if (Enum.class.isAssignableFrom(field.getType())) {
                    parName = tableAlias + fieldName.toUpperCase();
                    pAddParam.put("fieldClass", field.getType());
                } else if (tableSql.getFieldsMap().get(fieldName).getForeignEntity() != null) {
                    Integer deepLevelReq = (Integer)pAddParam.get(pEntity.getClass().getSimpleName() + fieldName + deepLevelNm);
                    if (deepLevelReq != null) {
                        currentLevel.add(1);
                        deepLevel.add(deepLevelReq);
                    }
                    if (deepLevel.size() != currentLevel.size()) {
                        throw new Exception("Algorithm error: deepLevel.size/currentLevel.size/Entity/Field" + deepLevel.size() + "/" + currentLevel.size() + "/" + pEntity.getClass().getSimpleName() + "/" + fieldName);
                    }
                    parName = fieldName;
                    foreignFieldNms.add(fieldName);
                    pAddParam.put("fieldClass", field.getType());
                    pAddParam.put("entityClass", pEntity.getClass());
                    if (isShowDbMsg && dbgDetLev > 66000) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("deepLevel size/value1/value...: " + deepLevel.size() + "/");
                        for (Integer dl : deepLevel) {
                            sb.append(dl + "/");
                        }
                        sb.append("\ncurrentLevel size/value1/value...: " + currentLevel.size() + "/");
                        for (Integer cl : currentLevel) {
                            sb.append(cl + "/");
                        }
                        sb.append("\nforeignFieldNms size/value1/value...: " + foreignFieldNms.size() + "/");
                        for (String fln : foreignFieldNms) {
                            sb.append(fln + "/");
                        }
                        sb.append("\nForeign class/fieldNm/type: " + pEntity.getClass().getSimpleName() + "/" + fieldName + "/" + field.getType().getSimpleName());
                        this.logger.debug(null, FillerEntitiesFromRs.class, sb.toString());
                    }
                } else {
                    parName = tableAlias + fieldName.toUpperCase();
                }
                Object fieldVal = conv.convert(pAddParam, pSource, parName);
                if (isShowDbMsg && dbgDetLev > 43000) {
                    this.logger.debug(null, FillerEntitiesFromRs.class, "Converted from RS class/field/type/converter/value: " + pEntity.getClass().getSimpleName() + "/" + fieldName + "/" + field.getType().getSimpleName() + "/" + conv.getClass().getSimpleName() + "/" + fieldVal);
                }
                filler.fill(pAddParam, pEntity, fieldVal, fieldName);
            }
            catch (Exception ex) {
                String msg = "Can't fill field/class: " + fieldName + "/" + pEntity.getClass().getCanonicalName();
                throw new ExceptionWithCode(1001, msg, ex);
            }
        }
        pAddParam.remove("fieldClass");
        pAddParam.remove("entityClass");
    }

    public final Map<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final void setTablesMap(Map<String, TableSql> pTablesMap) {
        this.tablesMap = pTablesMap;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final IFactoryAppBeansByClass<IFillerObjectFields<?>> getFillersFieldsFactory() {
        return this.fillersFieldsFactory;
    }

    public final void setFillersFieldsFactory(IFactoryAppBeansByClass<IFillerObjectFields<?>> pFillersFieldsFactory) {
        this.fillersFieldsFactory = pFillersFieldsFactory;
    }

    public final IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> getConvertersFieldsFatory() {
        return this.convertersFieldsFatory;
    }

    public final void setConvertersFieldsFatory(IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> pConvertersFieldsFatory) {
        this.convertersFieldsFatory = pConvertersFieldsFatory;
    }

    public final IHolderForClassByName<String> getFieldConverterNamesHolder() {
        return this.fieldConverterNamesHolder;
    }

    public final void setFieldConverterNamesHolder(IHolderForClassByName<String> pFieldConverterNamesHolder) {
        this.fieldConverterNamesHolder = pFieldConverterNamesHolder;
    }

    public final IHolderForClassByName<Field> getFieldsRapiHolder() {
        return this.fieldsRapiHolder;
    }

    public final void setFieldsRapiHolder(IHolderForClassByName<Field> pFieldsRapiHolder) {
        this.fieldsRapiHolder = pFieldsRapiHolder;
    }
}

