/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.beigesoft.doc.model.CmpElementIdxGrp;
import org.beigesoft.doc.model.DocRectangle;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.service.DeriverElPagination;
import org.beigesoft.doc.service.DeriverElTable;
import org.beigesoft.doc.service.DocumentMaker;
import org.beigesoft.doc.service.EvalMetricsString;
import org.beigesoft.doc.service.FctDocTable;
import org.beigesoft.doc.service.FctDocument;
import org.beigesoft.doc.service.FctElement;
import org.beigesoft.doc.service.IElementWriter;
import org.beigesoft.doc.service.ToHexCoder;
import org.beigesoft.doc.service.UomHelper;
import org.beigesoft.log.ILogger;
import org.beigesoft.log.LoggerFile;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.pdf.model.HasPdfContent;
import org.beigesoft.pdf.model.IPdfObject;
import org.beigesoft.pdf.model.PdfCatalog;
import org.beigesoft.pdf.model.PdfCidFontType2;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.model.PdfFontDescriptor;
import org.beigesoft.pdf.model.PdfFontFile;
import org.beigesoft.pdf.model.PdfImage;
import org.beigesoft.pdf.model.PdfInfo;
import org.beigesoft.pdf.model.PdfPage;
import org.beigesoft.pdf.model.PdfPages;
import org.beigesoft.pdf.model.PdfResources;
import org.beigesoft.pdf.model.PdfToUnicode;
import org.beigesoft.pdf.model.PdfTrailer;
import org.beigesoft.pdf.model.PdfXref;
import org.beigesoft.pdf.service.EvalCharWidth;
import org.beigesoft.pdf.service.FctHasPdfContent;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.ImageWriter;
import org.beigesoft.pdf.service.LineWriter;
import org.beigesoft.pdf.service.PdfMaker;
import org.beigesoft.pdf.service.PdfWriteHelper;
import org.beigesoft.pdf.service.PdfWriter;
import org.beigesoft.pdf.service.StringWriter;
import org.beigesoft.pdf.service.WriterPdfCatalog;
import org.beigesoft.pdf.service.WriterPdfCidFontType2;
import org.beigesoft.pdf.service.WriterPdfContent;
import org.beigesoft.pdf.service.WriterPdfFontDescriptor;
import org.beigesoft.pdf.service.WriterPdfFontFile;
import org.beigesoft.pdf.service.WriterPdfFontType0;
import org.beigesoft.pdf.service.WriterPdfFontType1S14;
import org.beigesoft.pdf.service.WriterPdfImage;
import org.beigesoft.pdf.service.WriterPdfInfo;
import org.beigesoft.pdf.service.WriterPdfPage;
import org.beigesoft.pdf.service.WriterPdfPages;
import org.beigesoft.pdf.service.WriterPdfResources;
import org.beigesoft.pdf.service.WriterPdfToUnicode;
import org.beigesoft.ttf.model.TtfConstants;
import org.beigesoft.ttf.service.TableMakerFc;
import org.beigesoft.ttf.service.TableMakerGlyf;
import org.beigesoft.ttf.service.TableMakerHead;
import org.beigesoft.ttf.service.TableMakerHhea;
import org.beigesoft.ttf.service.TableMakerHmtx;
import org.beigesoft.ttf.service.TableMakerLoca;
import org.beigesoft.ttf.service.TableMakerMaxp;
import org.beigesoft.ttf.service.TdeMaker;
import org.beigesoft.ttf.service.TtfCompactFontMaker;
import org.beigesoft.ttf.service.TtfFileStreamer;
import org.beigesoft.ttf.service.TtfLoader;
import org.beigesoft.ttf.service.TtfResourceStreamer;
import org.beigesoft.zlib.ZLibStreamer;

public class PdfFactory
implements IPdfFactory<HasPdfContent> {
    private ILogger logger;
    private PdfWriter<HasPdfContent> pdfWriter;
    private PdfWriteHelper writeHelper;
    private ZLibStreamer zLibStreamer;
    private UomHelper uomHelper;
    private ToHexCoder toHexCoder;
    private TtfLoader ttfLoader;
    private TtfConstants ttfConstants;
    private TtfCompactFontMaker compactFontMaker;
    private TdeMaker tdeMaker;
    private TableMakerFc tableMakerFc;
    private TableMakerHhea tableMakerHhea;
    private TableMakerLoca tableMakerLoca;
    private TableMakerMaxp tableMakerMaxp;
    private TableMakerHmtx tableMakerHmtx;
    private TableMakerHead tableMakerHead;
    private TableMakerGlyf tableMakerGlyf;
    private PdfMaker<HasPdfContent> pdfMaker;
    private CmpElementIdxGrp cmpElement;
    private DocumentMaker<HasPdfContent> documentMaker;
    private FctElement<HasPdfContent> fctElement;
    private FctDocument<HasPdfContent> fctDocument;
    private FctHasPdfContent fctHasPdfContent;
    private StringWriter stringWriter;
    private ImageWriter imageWriter;
    private WriterPdfPages writerPdfPages;
    private WriterPdfInfo writerPdfInfo;
    private WriterPdfCatalog writerPdfCatalog;
    private WriterPdfResources writerPdfResources;
    private WriterPdfContent writerPdfContent;
    private WriterPdfPage writerPdfPage;
    private WriterPdfToUnicode writerPdfToUnicode;
    private WriterPdfCidFontType2 writerPdfCidFontType2;
    private WriterPdfFontDescriptor writerPdfFontDescriptor;
    private WriterPdfFontFile writerPdfFontFile;
    private WriterPdfImage writerPdfImage;
    private WriterPdfFontType0 writerPdfFontType0;
    private WriterPdfFontType1S14 writerPdfFontType1S14;
    private FctDocTable<HasPdfContent> fctDocTable;
    private DeriverElTable<HasPdfContent> deriverElTable;
    private DeriverElPagination<HasPdfContent> deriverElPagination;
    private EvalMetricsString evalMetricsString;
    private EvalCharWidth evalCharWidth;
    private String fontDir = "/fonts/";
    private LineWriter lineWriter;
    private TtfResourceStreamer ttfResourceStreamer;
    private TtfFileStreamer ttfFileStreamer;

    public final synchronized void init() throws Exception {
        if (this.logger == null) {
            LoggerFile log = new LoggerFile();
            String currDir = System.getProperty("user.dir") + File.separator;
            String fileBaseName = "pdf-writer";
            log.setFilePath(currDir + fileBaseName);
            this.logger = log;
            this.logger.setIsShowDebugMessages(false);
            this.logger.setDetailLevel(5);
        }
        this.compactFontMaker = new TtfCompactFontMaker();
        this.compactFontMaker.setLogger(this.logger);
        this.tdeMaker = new TdeMaker();
        this.tableMakerFc = new TableMakerFc();
        this.tableMakerFc.setLogger(this.logger);
        this.tableMakerHmtx = new TableMakerHmtx();
        this.tableMakerHmtx.setLogger(this.logger);
        this.tableMakerHead = new TableMakerHead();
        this.tableMakerHead.setLogger(this.logger);
        this.tableMakerGlyf = new TableMakerGlyf();
        this.tableMakerGlyf.setLogger(this.logger);
        this.tableMakerLoca = new TableMakerLoca();
        this.tableMakerLoca.setLogger(this.logger);
        this.tableMakerMaxp = new TableMakerMaxp();
        this.tableMakerMaxp.setLogger(this.logger);
        this.tableMakerHhea = new TableMakerHhea();
        this.tableMakerHhea.setLogger(this.logger);
        this.ttfConstants = new TtfConstants();
        this.ttfLoader = new TtfLoader();
        this.ttfLoader.setTdeMaker(this.tdeMaker);
        this.ttfLoader.setTableMakerFc(this.tableMakerFc);
        this.ttfLoader.setTableMakerHmtx(this.tableMakerHmtx);
        this.ttfLoader.setTableMakerHead(this.tableMakerHead);
        this.ttfLoader.setTableMakerGlyf(this.tableMakerGlyf);
        this.ttfLoader.setTableMakerLoca(this.tableMakerLoca);
        this.ttfLoader.setTableMakerMaxp(this.tableMakerMaxp);
        this.ttfLoader.setTableMakerHhea(this.tableMakerHhea);
        this.ttfLoader.setLogger(this.logger);
        this.ttfLoader.setTtfConstants(this.ttfConstants);
        this.writeHelper = new PdfWriteHelper();
        PdfWriter pdfWr = new PdfWriter();
        pdfWr.setWriteHelper(this.writeHelper);
        this.pdfWriter = pdfWr;
        this.zLibStreamer = new ZLibStreamer();
        this.uomHelper = new UomHelper();
        this.toHexCoder = new ToHexCoder();
        this.cmpElement = new CmpElementIdxGrp();
        this.fctHasPdfContent = new FctHasPdfContent();
        this.writerPdfCatalog = new WriterPdfCatalog();
        this.writerPdfCatalog.setWriteHelper(this.writeHelper);
        this.writerPdfCidFontType2 = new WriterPdfCidFontType2();
        this.writerPdfCidFontType2.setWriteHelper(this.writeHelper);
        this.writerPdfFontDescriptor = new WriterPdfFontDescriptor();
        this.writerPdfFontDescriptor.setWriteHelper(this.writeHelper);
        this.writerPdfFontType0 = new WriterPdfFontType0();
        this.writerPdfFontType0.setWriteHelper(this.writeHelper);
        this.writerPdfFontType1S14 = new WriterPdfFontType1S14();
        this.writerPdfFontType1S14.setWriteHelper(this.writeHelper);
        this.writerPdfInfo = new WriterPdfInfo();
        this.writerPdfInfo.setWriteHelper(this.writeHelper);
        this.writerPdfPage = new WriterPdfPage();
        this.writerPdfPage.setWriteHelper(this.writeHelper);
        this.writerPdfPages = new WriterPdfPages();
        this.writerPdfPages.setWriteHelper(this.writeHelper);
        this.writerPdfResources = new WriterPdfResources();
        this.writerPdfResources.setWriteHelper(this.writeHelper);
        this.writerPdfToUnicode = new WriterPdfToUnicode();
        this.writerPdfToUnicode.setWriteHelper(this.writeHelper);
        this.writerPdfToUnicode.setZLibStreamer(this.zLibStreamer);
        this.writerPdfToUnicode.setToHexCoder(this.toHexCoder);
        this.writerPdfFontFile = new WriterPdfFontFile();
        this.writerPdfFontFile.setWriteHelper(this.writeHelper);
        this.writerPdfFontFile.setZLibStreamer(this.zLibStreamer);
        this.writerPdfFontFile.setCompactFontMaker(this.compactFontMaker);
        this.writerPdfImage = new WriterPdfImage();
        this.writerPdfImage.setWriteHelper(this.writeHelper);
        this.writerPdfImage.setZLibStreamer(this.zLibStreamer);
        this.writerPdfContent = new WriterPdfContent();
        this.writerPdfContent.setWriteHelper(this.writeHelper);
        this.writerPdfContent.setZLibStreamer(this.zLibStreamer);
        this.writerPdfContent.setCmpElement(this.cmpElement);
        this.writerPdfContent.setFctHasPdfContent(this.fctHasPdfContent);
        this.ttfResourceStreamer = new TtfResourceStreamer();
        this.ttfFileStreamer = new TtfFileStreamer();
        this.pdfMaker = new PdfMaker();
        this.pdfMaker.setFontDir(this.fontDir);
        this.pdfMaker.setTtfResourceStreamer(this.ttfResourceStreamer);
        this.pdfMaker.setTtfFileStreamer(this.ttfFileStreamer);
        this.pdfMaker.setUomHelper(this.uomHelper);
        this.pdfMaker.setTtfLoader(this.ttfLoader);
        this.pdfMaker.setWriterPdfContent(this.writerPdfContent);
        this.pdfMaker.setWriterPdfFontFile(this.writerPdfFontFile);
        this.pdfMaker.setWriterPdfCidFontType2(this.writerPdfCidFontType2);
        this.pdfMaker.setWriterPdfFontDescriptor(this.writerPdfFontDescriptor);
        this.pdfMaker.setWriterPdfFontType0(this.writerPdfFontType0);
        this.pdfMaker.setWriterPdfFontType1S14(this.writerPdfFontType1S14);
        this.pdfMaker.setWriterPdfToUnicode(this.writerPdfToUnicode);
        this.pdfMaker.setWriterPdfPage(this.writerPdfPage);
        this.pdfMaker.setWriterPdfImage(this.writerPdfImage);
        this.compactFontMaker.setTtfFonts(this.pdfMaker.getTtfFonts());
        this.compactFontMaker.setTtfFontsStreamers(this.pdfMaker.getTtfFontsStreamers());
        this.compactFontMaker.setTtfFontsPaths(this.pdfMaker.getTtfFontsPaths());
        this.fctDocument = new FctDocument();
        this.fctElement = new FctElement();
        this.stringWriter = new StringWriter();
        this.stringWriter.setUomHelper(this.uomHelper);
        this.stringWriter.setToHexCoder(this.toHexCoder);
        this.stringWriter.setWriteHelper(this.writeHelper);
        this.fctElement.setWriterString(this.stringWriter);
        this.imageWriter = new ImageWriter();
        this.imageWriter.setUomHelper(this.uomHelper);
        this.imageWriter.setWriteHelper(this.writeHelper);
        this.fctElement.setWriterImage(this.imageWriter);
        this.lineWriter = new LineWriter();
        this.lineWriter.setUomHelper(this.uomHelper);
        this.lineWriter.setWriteHelper(this.writeHelper);
        this.fctElement.setWriterLine(this.lineWriter);
        this.documentMaker = new DocumentMaker();
        this.documentMaker.setElementFactory(this.fctElement);
        this.evalCharWidth = new EvalCharWidth();
        this.evalCharWidth.setTtfFonts(this.pdfMaker.getTtfFonts());
        this.evalMetricsString = new EvalMetricsString();
        this.evalMetricsString.setEvalCharWidth(this.evalCharWidth);
        this.deriverElTable = new DeriverElTable();
        this.deriverElTable.setElementFactory(this.fctElement);
        this.deriverElTable.setEvalMetricsString(this.evalMetricsString);
        this.deriverElTable.setDocumentMaker(this.documentMaker);
        this.fctDocTable = new FctDocTable();
        this.fctDocTable.setDeriverElements(this.deriverElTable);
        this.documentMaker.setDocTableFactory(this.fctDocTable);
        this.deriverElPagination = new DeriverElPagination();
        this.deriverElPagination.setElementFactory(this.fctElement);
        this.deriverElPagination.setEvalMetricsString(this.evalMetricsString);
        this.deriverElPagination.setDocumentMaker(this.documentMaker);
        this.documentMaker.setDeriverElPagination(this.deriverElPagination);
    }

    @Override
    public final PdfDocument<HasPdfContent> createPdfDoc(Document<HasPdfContent> pBaseDoc) throws Exception {
        PdfDocument<HasPdfContent> doc = new PdfDocument<HasPdfContent>();
        doc.setMainDoc(pBaseDoc);
        doc.setPdfXref(new PdfXref());
        doc.setPdfTrailer(new PdfTrailer());
        doc.setPdfObjects(new ArrayList<IPdfObject>());
        doc.setPdfToUnicodes(new ArrayList<PdfToUnicode>());
        doc.setCidType2Fonts(new ArrayList<PdfCidFontType2>());
        doc.setFontDescriptors(new ArrayList<PdfFontDescriptor>());
        doc.setFontFiles(new ArrayList<PdfFontFile>());
        doc.setImages(new ArrayList<PdfImage>());
        PdfInfo pdfInfo = new PdfInfo();
        pdfInfo.setCreationDate(new Date());
        pdfInfo.setWriter(this.writerPdfInfo);
        doc.setPdfInfo(pdfInfo);
        doc.getPdfObjects().add(pdfInfo);
        doc.getPdfTrailer().setInfo(pdfInfo);
        PdfCatalog pdfCatalog = new PdfCatalog();
        pdfCatalog.setWriter(this.writerPdfCatalog);
        doc.getPdfObjects().add(pdfCatalog);
        doc.getPdfTrailer().setRoot(pdfCatalog);
        PdfPages pdfPages = new PdfPages();
        pdfPages.setWriter(this.writerPdfPages);
        pdfPages.setPages(new ArrayList<PdfPage>());
        pdfCatalog.setPages(pdfPages);
        doc.getPdfObjects().add(pdfPages);
        PdfResources pdfRes = new PdfResources();
        pdfRes.setWriter(this.writerPdfResources);
        pdfRes.setFonts(new ArrayList<IPdfObject>());
        pdfRes.setImages(new ArrayList<IPdfObject>());
        doc.setResources(pdfRes);
        doc.getPdfObjects().add(pdfRes);
        return doc;
    }

    public final StringWriter lazyGetStringWriter() throws Exception {
        return this.stringWriter;
    }

    public final LineWriter lazyGetLineWriter() throws Exception {
        return this.lineWriter;
    }

    @Override
    public final IElementWriter<DocRectangle<HasPdfContent>, HasPdfContent> lazyGetRectangleWriter() throws Exception {
        throw new ExceptionPdfWr("Not yet implemented!");
    }

    @Override
    public final ILogger lazyGetLogger() throws Exception {
        return this.logger;
    }

    @Override
    public final DocumentMaker<HasPdfContent> lazyGetDocumentMaker() throws Exception {
        return this.documentMaker;
    }

    @Override
    public final FctElement<HasPdfContent> lazyGetFctElement() throws Exception {
        return this.fctElement;
    }

    @Override
    public final FctDocument<HasPdfContent> lazyGetFctDocument() throws Exception {
        return this.fctDocument;
    }

    @Override
    public final PdfWriteHelper lazyGetWriteHelper() throws Exception {
        return this.writeHelper;
    }

    @Override
    public final PdfWriter<HasPdfContent> lazyGetPdfWriter() throws Exception {
        return this.pdfWriter;
    }

    @Override
    public final TtfCompactFontMaker lazyGetCompactFontMaker() throws Exception {
        return this.compactFontMaker;
    }

    @Override
    public final PdfMaker<HasPdfContent> lazyGetPdfMaker() throws Exception {
        return this.pdfMaker;
    }

    @Override
    public final TtfLoader lazyGetTtfLoader() throws Exception {
        return this.ttfLoader;
    }

    @Override
    public final ZLibStreamer lazyGetZLibStreamer() throws Exception {
        return this.zLibStreamer;
    }

    @Override
    public final UomHelper lazyGetUomHelper() throws Exception {
        return this.uomHelper;
    }

    @Override
    public final ToHexCoder lazyGetToHexCoder() throws Exception {
        return this.toHexCoder;
    }

    @Override
    public final TdeMaker lazyGetTdeMaker() throws Exception {
        return this.tdeMaker;
    }

    @Override
    public final TableMakerFc lazyGetTableMakerFc() throws Exception {
        return this.tableMakerFc;
    }

    @Override
    public final TableMakerHmtx lazyGetTableMakerHmtx() throws Exception {
        return this.tableMakerHmtx;
    }

    @Override
    public final TableMakerHead lazyGetTableMakerHead() throws Exception {
        return this.tableMakerHead;
    }

    @Override
    public final TableMakerGlyf lazyGetTableMakerGlyf() throws Exception {
        return this.tableMakerGlyf;
    }

    @Override
    public final TableMakerLoca lazyGetTableMakerLoca() throws Exception {
        return this.tableMakerLoca;
    }

    @Override
    public final TableMakerMaxp lazyGetTableMakerMaxp() throws Exception {
        return this.tableMakerMaxp;
    }

    @Override
    public final TableMakerHhea lazyGetTableMakerHhea() throws Exception {
        return this.tableMakerHhea;
    }

    public final CmpElementIdxGrp lazyGetCmpElement() throws Exception {
        return this.cmpElement;
    }

    @Override
    public final FctHasPdfContent lazyGetFctHasPdfContent() throws Exception {
        return this.fctHasPdfContent;
    }

    public final WriterPdfPages lazyGetWriterPdfPages() throws Exception {
        return this.writerPdfPages;
    }

    public final WriterPdfInfo lazyGetWriterPdfInfo() throws Exception {
        return this.writerPdfInfo;
    }

    public final WriterPdfCatalog lazyGetWriterPdfCatalog() throws Exception {
        return this.writerPdfCatalog;
    }

    public final WriterPdfResources lazyGetWriterPdfResources() throws Exception {
        return this.writerPdfResources;
    }

    public final WriterPdfContent lazyGetWriterPdfContent() throws Exception {
        return this.writerPdfContent;
    }

    public final WriterPdfPage lazyGetWriterPdfPage() throws Exception {
        return this.writerPdfPage;
    }

    public final WriterPdfToUnicode lazyGetWriterPdfToUnicode() throws Exception {
        return this.writerPdfToUnicode;
    }

    public final WriterPdfCidFontType2 lazyGetWriterPdfCidFontType2() throws Exception {
        return this.writerPdfCidFontType2;
    }

    public final WriterPdfFontDescriptor lazyGetWriterPdfFontDescriptor() throws Exception {
        return this.writerPdfFontDescriptor;
    }

    public final WriterPdfFontFile lazyGetWriterPdfFontFile() throws Exception {
        return this.writerPdfFontFile;
    }

    public final WriterPdfImage lazyGetWriterPdfImage() throws Exception {
        return this.writerPdfImage;
    }

    public final WriterPdfFontType0 lazyGetWriterPdfFontType0() throws Exception {
        return this.writerPdfFontType0;
    }

    public final WriterPdfFontType1S14 lazyGetWriterPdfFontType1S14() throws Exception {
        return this.writerPdfFontType1S14;
    }

    @Override
    public final FctDocTable<HasPdfContent> lazyGetFctDocTable() throws Exception {
        return this.fctDocTable;
    }

    public final DeriverElTable<HasPdfContent> lazyGetDeriverElTable() throws Exception {
        return this.deriverElTable;
    }

    public final DeriverElPagination<HasPdfContent> lazyGetDeriverElPagination() throws Exception {
        return this.deriverElPagination;
    }

    @Override
    public final EvalMetricsString lazyGetEvalMetricsString() throws Exception {
        return this.evalMetricsString;
    }

    @Override
    public final EvalCharWidth lazyGetEvalCharWidth() throws Exception {
        return this.evalCharWidth;
    }

    @Override
    public final TtfResourceStreamer lazyGetTtfResourceStreamer() throws Exception {
        return this.ttfResourceStreamer;
    }

    @Override
    public final TtfFileStreamer lazyGetTtfFileStreamer() throws Exception {
        return this.ttfFileStreamer;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final String getFontDir() {
        return this.fontDir;
    }

    public final void setFontDir(String pFontDir) {
        this.fontDir = pFontDir;
    }
}

