/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import org.beigesoft.pdf.model.PdfFontDescriptor;
import org.beigesoft.pdf.service.AWriterPdfObject;

public class WriterPdfFontDescriptor
extends AWriterPdfObject<PdfFontDescriptor> {
    @Override
    public final int write(PdfFontDescriptor pPdfObj, OutputStream pOut) throws Exception {
        int bytesWritten = 0;
        byte[] btsNumSp = (pPdfObj.getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (pPdfObj.getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        String startStr = "/Type /FontDescriptor\n";
        bytesWritten += this.getWriteHelper().writeBytes(startStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String fontNameStr = "/FontName /" + pPdfObj.getFontName() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(fontNameStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String flagsStr = "/Flags " + pPdfObj.getFlags() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(flagsStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String italicAngleStr = "/ItalicAngle " + pPdfObj.getItalicAngle() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(italicAngleStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        if (pPdfObj.getFontWeight() != 0.0f) {
            String fontWeightStr = "/FontWeight " + pPdfObj.getFontWeight() + "\n";
            bytesWritten += this.getWriteHelper().writeBytes(fontWeightStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        String ascentStr = "/Ascent " + pPdfObj.getAscent() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(ascentStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String descentStr = "/Descent " + pPdfObj.getDescent() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(descentStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String capHeightStr = "/CapHeight " + pPdfObj.getCapHeight() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(capHeightStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        if (pPdfObj.getXHeight() != 0.0f) {
            String xHeightStr = "/XHeight " + pPdfObj.getXHeight() + "\n";
            bytesWritten += this.getWriteHelper().writeBytes(xHeightStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        String stemVStr = "/StemV " + pPdfObj.getStemV() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(stemVStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String fontBStr = "/FontBBox [" + pPdfObj.getMinX() + " " + pPdfObj.getMinY() + " " + pPdfObj.getMaxX() + " " + pPdfObj.getMaxY() + "]\n";
        bytesWritten += this.getWriteHelper().writeBytes(fontBStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String fontFile2Str = "/FontFile2 " + pPdfObj.getFontFile2().getNumber() + " " + pPdfObj.getFontFile2().getGenNumber() + " R";
        bytesWritten += this.getWriteHelper().writeBytes(fontFile2Str.getBytes(this.getWriteHelper().getAscii()), pOut);
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndObjLf(), pOut);
    }
}

