/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.beigesoft.pdf.model.PdfFontFile;
import org.beigesoft.pdf.service.AWriterPdfObject;
import org.beigesoft.ttf.service.ITtfCompactFontMaker;
import org.beigesoft.zlib.IZLibStreamer;

public class WriterPdfFontFile
extends AWriterPdfObject<PdfFontFile> {
    private IZLibStreamer zLibStreamer;
    private ITtfCompactFontMaker compactFontMaker;

    @Override
    public final int write(PdfFontFile pPdfObj, OutputStream pOut) throws Exception {
        byte[] fntCompact = this.compactFontMaker.make(null, pPdfObj.getFontName(), pPdfObj.getToUnicode().getUsedCids());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(fntCompact);
        this.zLibStreamer.compress(null, is, os);
        byte[] cont = os.toByteArray();
        int bytesWritten = 0;
        byte[] btsNumSp = (pPdfObj.getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (pPdfObj.getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/Filter /FlateDecode\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        String startStr = "/Length " + cont.length + "\n/Length1 " + fntCompact.length;
        bytesWritten += this.getWriteHelper().writeBytes(startStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndDictLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartStreamLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(cont, pOut);
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndStreamObjLf(), pOut);
    }

    public final IZLibStreamer getZLibStreamer() {
        return this.zLibStreamer;
    }

    public final void setZLibStreamer(IZLibStreamer pZLibStreamer) {
        this.zLibStreamer = pZLibStreamer;
    }

    public final ITtfCompactFontMaker getCompactFontMaker() {
        return this.compactFontMaker;
    }

    public final void setCompactFontMaker(ITtfCompactFontMaker pCompactFontMaker) {
        this.compactFontMaker = pCompactFontMaker;
    }
}

